// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widgetbasetextcol.h"

static const char rcsid[]="$Id: widgetbasetextcol.C,v 1.2 1999/03/24 05:28:43 mrsam Exp $";


CBaseTextColWidget::~CBaseTextColWidget()
{
}

void CBaseTextColWidget::Create(CWidget *parent, CString default_widths,
			CString default_gap)
{
	CBaseTextWidget::Create(parent);

	m_colwidths.SetSize(0);
	ConvertUnitsFromResource("colwidths", m_colwidths, default_widths);

CUIntArray dummy;

	ConvertUnitsFromResource("colgap", dummy, default_gap);
	m_gap=dummy[0];
	m_rects.SetSize(m_colwidths.GetSize()+1);
	m_sizes.SetSize(m_colwidths.GetSize()+1);
}

size_t CBaseTextColWidget::Height(POSITION p)
{
	Height(p, m_sizes.GetData());

size_t	h=1;
size_t	i, l=m_sizes.GetSize();

	for (i=0; i<l; i++)
		if (h < m_sizes[i])
			h=m_sizes[i];
	return (h);
}

void CBaseTextColWidget::DrawText(POSITION pos, size_t index,
		unsigned x, unsigned y, unsigned width, unsigned height,
		GC gc, XmRenderTable render_table,
		unsigned char layout_direction, size_t, size_t)
{
size_t	h=Height(pos);
size_t	i, l=m_sizes.GetSize();
unsigned curx=x;

	for (i=0; i<l; i++)
	{
		m_rects[i].y=y+h-m_sizes[i];
		m_rects[i].height=m_sizes[i];

		if (i)	curx += m_gap;
		if (curx > x + width)	curx=x+width;
		m_rects[i].x=curx;
		if (i == l - 1)
			m_rects[i].width = x + width - curx;
		else
			m_rects[i].width=m_colwidths[i];
		if (m_rects[i].width > x + width - curx)
			m_rects[i].width = x+width-curx;
		curx += m_rects[i].width;
	}
	DrawColText(pos, index, x, y, width, height, gc, render_table,
		layout_direction, m_rects.GetData());
}
