// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widget.h"
#include	"widgetcursor.h"

static const char rcsid[]="$Id: widgetcursor.C,v 1.2 1998/06/26 03:06:55 mrsam Exp $";

void CXmTextCursor::Create(CWidget &wid, XRectangle pos, XRectangle clip)
{
// Clip cursor size

	if (pos.width > clip.width)
		pos.width=clip.width;
	if (pos.height > clip.height)
		pos.height=clip.height;

	// Calculate optimum cursor thickness

	m_barh=pos.height / 10;
	m_barw=pos.width / 10;

	if (m_barh < 2)	m_barh=2;
	if (m_barw < 2)	m_barw=2;
	if (m_barh > pos.height)	m_barh=pos.height;
	if (m_barw > pos.width)		m_barw=pos.width;

	// Make cursor symmetric

	pos.width = (pos.width - m_barw)/2*2+m_barw;

	pos.x -= pos.width/2;	// Put vertical bar at desired position

	// Clip cursor position

	if (pos.x < clip.x)
		pos.x=clip.x;
	if (pos.y < clip.y)
		pos.y=clip.y;
	if (pos.x > (clip.x + clip.width - pos.width))
		pos.x=clip.x + clip.width - pos.width;
	if (pos.y > (clip.y + clip.height - pos.height))
		pos.y=clip.y + clip.height - pos.height;

	// Reuse the current pixmap, if possible.

	if (!m_disp || pos.width > CXmPixmap::m_width ||
		pos.height > CXmPixmap::m_height)
		CXmPixmap::Create(wid,
			pos.width > 0 ? pos.width:1,
			pos.height > 0 ? pos.height:1);

	// Save background under cursor

	m_wid= &wid;

	m_gc.Create(m_disp, XtWindow(m_wid->wid()));
	m_pos=pos;

	if (m_pos.width > 0 && m_pos.height > 0)
	{
		m_gc.ChangeFunction(GXcopy);
		XCopyArea(m_disp, XtWindow(m_wid->wid()),
			(Pixmap)*this, m_gc, m_pos.x, m_pos.y,
			m_pos.width, m_pos.height, 0, 0);
	}
}

void CXmTextCursor::Destroy()
{
	CXmPixmap::Destroy();
	m_gc.Destroy();
}

// Erase by restoring background

void	CXmTextCursor::Off()
{
	if (m_pos.width <= 0 || m_pos.height <= 0 || !(Pixmap)*this)
		return;

	m_gc.ChangeFunction(GXcopy);
	XCopyArea(m_disp, (Pixmap)*this, XtWindow(m_wid->wid()), m_gc, 0, 0,
				m_pos.width, m_pos.height, m_pos.x, m_pos.y);
}

// Draw cursor

void	CXmTextCursor::On()
{
	if (m_pos.width <= 0 || m_pos.height <= 0 || !(Pixmap)*this)
		return;

	XSetForeground(m_disp, m_gc, m_wid->GetValueInt(XmNborderColor));

Window	w=XtWindow(m_wid->wid());

	XFillRectangle(m_disp, w, m_gc, m_pos.x, m_pos.y,
				m_pos.width, m_barh);
	XFillRectangle(m_disp, w, m_gc, m_pos.x, m_pos.y+m_pos.height-m_barh,
				m_pos.width, m_barh);
	XFillRectangle(m_disp, w, m_gc, m_pos.x+(m_pos.width - m_barw)/2,
				m_pos.y, m_barw, m_pos.height);
}
