// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetfr_h
#define	widgetft_h

static const char widgetfr_h_rcsid[]="$Id: widgetfr.h,v 1.3 1999/04/09 02:25:54 mrsam Exp $";

//////////////////////////////////////////////////////////////////////
//
// A better file requester.
//

#include	"widget.h"
#include	"widgetmenu.h"
#include	"widgetprim.h"
#include	"widgetlist.h"
#include	"widgetpane.h"
#include	"widgetscroll.h"
#include	"widgetredirect.h"
#include	"widgetxms.h"
#include	"widgetarray.h"
#include	"widgettext.h"

#include	"afx.h"
#include	"afxtempl.h"

// Helper class - COptionMenuWidgetExtended

class	COptionMenuWidgetExtended;

class	COptionMenuWidgetExtended : public CFormWidget {

	CActivateRedirect<CWidgetArrayMenu,
			COptionMenuWidgetExtended> m_options;
	void	OnOptionActivate();
	void	OnActivate();

	CStringArray m_optionArray;
public:
	CString	m_optionStr;
	COptionMenuWidget m_optionMenu;
	CPulldownMenuWidget m_pulldown;
	CActivateRedirect<CTextWidget, COptionMenuWidgetExtended> m_maskText;
	CString	Value()	{ return (m_maskText.Value()); }
	COptionMenuWidgetExtended(const char *);
	~COptionMenuWidgetExtended();
	void Create(CWidget *);
} ;

class	CFileRequesterWidget : public CFormWidget {

	CFormWidget	m_dirname_form;
	CLabelWidget	m_dirname_label;
	CActivateRedirect<CTextWidget, CFileRequesterWidget>	m_dirname_text;
	CActivateRedirect<COptionMenuWidgetExtended, CFileRequesterWidget> m_mask;
	CSeparatorWidget m_sep1;
	CPanedWindowWidget m_pane;
	CScrollWindowWidget m_dirscroll, m_filescroll;
	CListWidgetRedirect<CFileRequesterWidget> m_dirlist, m_filelist;

	CSeparatorWidget m_sep2;
	CFormWidget	m_filename_form;
	CLabelWidget	m_filename_label;
	CActivateRedirect<CTextWidget, CFileRequesterWidget>	m_filename_text;
	void		OnFilenameOk();
	void		OnFilenameCancel();
	CFormWidget	m_buttons;
	CActivateRedirect<CPushButtonWidget, CFileRequesterWidget>	m_ok, m_cancel;

	CStringList	m_files, m_dirs;
	CString		m_curdir;
	CArray<CXmString, const CXmString &> m_filesArray, m_dirsArray;

	void	OnDirNameActivate();
	void	OnDirListDoubleClick(int, int *, XmString *, int);
	void	OnFileListDoubleClick(int, int *, XmString *, int);
	void	OnFileListClick(int, int *, XmString *, int);
	void	OnMaskChange();

static	int	select_contents(const struct dirent *);
public:
	CString	m_filename;

	CFileRequesterWidget(const char *dummy);
	~CFileRequesterWidget();
	void Create(CWidget *parent);
	void Chdir(CString dirname);
	void DoChdir(CString dirname);
	void Filename(CString s)
		{
			m_filename_text.Value(s);
		}
virtual	void OnOk(), OnCancel();

} ;

#endif
