// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetinput_h
#define	widgetinput_h

static const char widgetinput_h_rcsid[]="$Id: widgetinput.h,v 1.5 1999/04/09 02:32:28 mrsam Exp $";


#include	<X11/Intrinsic.h>
#include	"afx.h"
#include	"afxtempl.h"

////////////////////////////////////////////////////////////////////////
//
// CXmInput template - encapsulate XtAppAddInput.
//
// We have a main class that reads or writes stuff.  This template
// encapsulates the XtAppAddInput function to manage i/o on the
// file, setting up the callbacks back to the template.  The template,
// in turn, calls the methods in the main class.  When a class specifies
// a function that will read or write from the file, the template turns
// on the corresponding I/O mask, and calls the function when the I/O
// is ready.

// First - CXmInputBase - common code, no need to put it into template:


class CXmInputBase {

	int m_fd;		// My file descriptor
	AFXBOOL	m_canRead,	// m_readId is valid
		m_canWrite;	// m_writeId is valid
	XtInputId
		m_readId,
		m_writeId;

static CList<CXmInputBase *, CXmInputBase *> m_list;

	POSITION	m_pos;	// My position in list

public:

static void findabug();

	CXmInputBase() : m_fd(-1), m_canRead(FALSE), m_canWrite(FALSE)	{}
	virtual ~CXmInputBase();

static	void	Forked();

private:
	CXmInputBase(const CXmInputBase &);			// UNDEFINED
	CXmInputBase &operator=(const CXmInputBase &);		// UNDEFINED

static void read_proc(CXmInputBase *, int *, XtInputId *);
static void write_proc(CXmInputBase *, int *, XtInputId *);

	void readon();
	void readoff();
	void writeon();
	void writeoff();

protected:
	int ReadBuffer();

virtual void Read();
virtual void Write();
virtual void CanRead(AFXBOOL=TRUE);
virtual void CanWrite(AFXBOOL=TRUE);

	CString	m_readBuf;
	CString	m_writeBuf;
	size_t	m_writeCnt;

public:

	// Here are the only function that the main class needs to know about

	int	fd() { return (m_fd); }
	void	fd(int);

virtual void	ProcessRead(CString)=0;
virtual	CString	GetWrite()=0;
} ;

// And now, the template


template<class T> class CXmInput : public CXmInputBase {

protected:
	T *m_instance;				// Instance of my class
	void	(T::*m_readPtr)(CString);	// The read function
	CString	(T::*m_writePtr)();		// The write function
public:
	CXmInput(T *w=NULL) : m_instance(w) {}
				// Specify the instance, if it is known at
				// creation,

	void operator=(T *p) { m_instance=p; }
				// Or specify it now.

	virtual ~CXmInput();

private:
	void	ProcessRead(CString);
	CString	GetWrite();

public:
virtual	void	Read( void (T::*)(CString) );

virtual	void	Write( CString (T::*)(void) );
} ;

template<class T> CXmInput<T>::~CXmInput()
{
}

template<class T> void CXmInput<T>::Write( CString (T::*p)() )
{
	if (!p)	CanWrite(FALSE);
	m_writePtr=p;
	if (p)	CanWrite(TRUE);
}

template<class T> void CXmInput<T>::Read( void (T::*p)(CString) )
{
	m_readPtr=p;
	if (p)
		CanRead(TRUE);
	else
		CanRead(FALSE);
}

template<class T> CString CXmInput<T>::GetWrite()
{
	return ( (m_instance->*m_writePtr)() );
}

template<class T> void CXmInput<T>::ProcessRead(CString s)
{
	(m_instance->*m_readPtr)(s);
}
#endif
