// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetlineinput_h
#define	widgetlineinput_h

static const char widgetlineinput_h_rcsid[]="$Id: widgetlineinput.h,v 1.3 1999/04/09 02:25:54 mrsam Exp $";


//////////////////////////////////////////////////////////////////////////
//
// Derive from CXmInput to provide line-oriented input, so that the read
// function gets called for complete lines of input, and that the
// read function will be called from the context of the Xt main loop.
//
// This permits the read function to destroy its object.  If we had a loop
// here that called the function when multiple lines have been read, and this
// object got destroyed before all lines were processed, we would end up
// still running in the method of a destroyed instance.

#include	<errno.h>
#include	"widgetinput.h"
#include	"widgettimer.h"

template<class T, class Base> class CXmLineInput : public Base {

	CEvent<CXmLineInput> m_event;
	int	m_errno;

	int FindEOL()
	{
	const char *p=m_readBuf;
	size_t l=m_readBuf.GetLength();
	size_t i;

		for (i=0; i<l; i++)
			if (p[i] == '\r' || p[i] == '\n')
				return (i);
		return (-1);
	}

public:
	CXmLineInput(T *w=NULL) : Base(w) { m_event=this; }
	void operator=(T *p) { Base::operator=(p); }
	virtual ~CXmLineInput();

	void	fd(int f);
	int	fd() { return (Base::fd()); }
	void	Read( void (T::*)(CString) );
private:
	void	Read();			// _MY_ implementation
	void	Fire();
	CString m_line;
} ;

template<class T, class Base> CXmLineInput<T, Base>::~CXmLineInput()
{
}

template<class T, class Base> inline void CXmLineInput<T, Base>::fd(int f)
{
	m_event.Cancel();
	m_readBuf="";
	Base::fd(f);
}

template<class T, class Base> void CXmLineInput<T, Base>::Read(
							void (T::*p)(CString) )
{
	m_readPtr=p;
	if (!p)
	{
		Base::CanRead(FALSE);
		return;
	}

	if (FindEOL() >= 0)
		m_event.Arm( &CXmLineInput<T, Base>::Fire );
	else
		Base::CanRead(TRUE);
}

template<class T, class Base> void CXmLineInput<T, Base>::Read()
{
	if (Base::ReadBuffer() <= 0)
	{
		m_errno=errno;
		m_event.Arm( &CXmLineInput<T, Base>::Fire );
		return;
	}

	if (FindEOL() >= 0)
	{
		Base::CanRead(FALSE);
		m_event.Arm( &CXmLineInput<T, Base>::Fire );
	}
}

template<class T, class Base> void CXmLineInput<T, Base>::Fire()
{
	if (m_readBuf.GetLength() > 0)	// Not EOF signal.
	{
	int	n=FindEOL();

		m_line=m_readBuf.Left(n+1);
		m_readBuf=m_readBuf.Mid(n+1);
		if (FindEOL() >= 0)
			m_event.Arm( &CXmLineInput<T, Base>::Fire );
		else
			if (n >= 0)
				Base::CanRead(TRUE);
	}
	else
	{
		m_line="";
		errno=m_errno;
	}

	(m_instance->*m_readPtr)(m_line);
}
#endif
