// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<Xm/Xm.h>
#include	<Xm/List.h>
#include	"widget.h"
#include	"widgetlist.h"
#include	"widgetxms.h"
#include	"afx.h"

static const char rcsid[]="$Id: widgetlist.C,v 1.5 1999/04/09 02:32:28 mrsam Exp $";

static void OnListClickCallback(Widget, XtPointer clientData, XtPointer xp)
{
CListWidget *p=(CListWidget *)clientData;
XmListCallbackStruct *cp=(XmListCallbackStruct *)xp;
int	button=cp->event && (cp->event->type == ButtonPress ||
					cp->event->type == ButtonRelease)
			? cp->event->xbutton.button:0;

	switch (cp->reason)	{
	case XmCR_SINGLE_SELECT:
	case XmCR_BROWSE_SELECT:
		p->OnClick( cp->item_position ? 1:0,
				&cp->item_position,
				&cp->item, button);
		break;
	default:
		p->OnClick(cp->selected_item_count,
			cp->selected_item_positions,
			cp->selected_items, button);
	}
}

static void OnListDoubleClickCallback(Widget, XtPointer clientData,
			XtPointer xp)
{
CListWidget *p=(CListWidget *)clientData;
XmListCallbackStruct *cp=(XmListCallbackStruct *)xp;
int	button=cp->event && (cp->event->type == ButtonPress ||
					cp->event->type == ButtonRelease)
			? cp->event->xbutton.button:0;


	p->OnDoubleClick(cp->selected_item_count,
			cp->selected_item_positions,
			cp->selected_items, button);
}

////////////////////////////////////////////////////////////////////////

void CListWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);
	XtAddCallback(wid(), XmNbrowseSelectionCallback, &OnListClickCallback,
			(XtPointer)this);
	XtAddCallback(wid(), XmNextendedSelectionCallback, &OnListClickCallback,
			(XtPointer)this);
	XtAddCallback(wid(), XmNmultipleSelectionCallback, &OnListClickCallback,
			(XtPointer)this);
	XtAddCallback(wid(), XmNsingleSelectionCallback, &OnListClickCallback,
			(XtPointer)this);
	XtAddCallback(wid(), XmNdefaultActionCallback, &OnListDoubleClickCallback,
			(XtPointer)this);
}

CListWidget::CListWidget(const char * name) : CWidget(name)
{
}

CListWidget::~CListWidget()
{
}

WidgetClass CListWidget::Class()
{
	return (xmListWidgetClass);
}

void	CListWidget::AddItem(const CXmString &item, size_t pos)
{
Widget	w=wid();

	if (!w)	AfxThrowInternalException();
	XmListAddItemUnselected(w, item, pos);
}

void	CListWidget::AddItems(const CXmString *items, size_t cnt, size_t pos)
{
Widget	w=wid();

	if (!w)	AfxThrowInternalException();

CArray<XmString, XmString> s;
size_t	i;

	s.SetSize(cnt);
	for (i=0; i<cnt; i++)
		s[i]=items[i];
	XmListAddItemsUnselected(w, s.GetData(), cnt, pos);
}

void	CListWidget::RemoveAll()
{
Widget	w=wid();

	if (!w)	AfxThrowInternalException();
	XmListDeleteAllItems(w);
}

void	CListWidget::DeleteItem(size_t pos)
{
Widget	w=wid();

	if (!w)	AfxThrowInternalException();
	XmListDeleteItemsPos(w, 1, pos+1);
}

int	CListWidget::NumSelected()
{
Widget	w=wid();

	if (!w)	AfxThrowInternalException();

Arg	a;
int	cnt;

	cnt=0;
	XtSetArg(a, XmNselectedPositionCount, (XtArgVal) &cnt );
	XtGetValues(w, &a, 1);
	return (cnt);
}

size_t	*CListWidget::GetSelected()
{
Widget	w=wid();

	if (!w)	AfxThrowInternalException();

Arg	a;
unsigned int	*p;

	p=NULL;
	XtSetArg(a, XmNselectedPositions, (XtArgVal) &p );
	XtGetValues(w, &a, 1);
	return (p);
}

XmString	CListWidget::GetItem(size_t n)
{
Widget	w=wid();

	if (!w)	AfxThrowInternalException();

Arg	a;
XmStringTable p=NULL;

	XtSetArg(a, XmNitems, (XtArgVal) &p );
	XtGetValues(w, &a, 1);
	return (p[n]);
}

size_t	CListWidget::NumItems()
{
Widget	w=wid();

	if (!w)	AfxThrowInternalException();

Arg	a;
int	n=0;

	XtSetArg(a, XmNitemCount, (XtArgVal) &n );
	XtGetValues(w, &a, 1);
	return (n);
}



// Override OnPopup to pop up a menu only if there's at least 1 item
// selected.

AFXBOOL	CListWidget::OnPopup(CPopupMenuWidget *&)
{
	return (NumSelected() ? TRUE:FALSE);
}

void	CListWidget::OnClick(int, int *, XmString *, int)
{
}

void	CListWidget::OnDoubleClick(int, int *, XmString *, int)
{
}
