// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetprim_h
#define	widgetprim_h

static const char widgetprim_h_rcsid[]="$Id: widgetprim.h,v 1.6 1999/04/09 02:32:28 mrsam Exp $";

#include	"afx.h"
#include	<X11/Intrinsic.h>

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
//
//  Simple widgets:  separators, labels, buttons, ...
//
//  Routine encapsulation
//
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
//
//  The separator widget
//

class CSeparatorWidget : public CWidget {
	WidgetClass	Class();
public:
	enum separator_orientation { horizontal, vertical };
	CSeparatorWidget(const char *);
	~CSeparatorWidget();
	void	Create(CWidget *parent, separator_orientation=horizontal);
	void	Create(CWidget *parent, CWidgetArgs &args);
} ;

/////////////////////////////////////////////////////////////////////
//
//  Here's a label widget
//

class CLabelWidget : public CWidget {

	WidgetClass	Class();
public:
	CLabelWidget(const char *);
	~CLabelWidget();
	void	Create(CWidget *parent);
	void	Create(CWidget *parent, CWidgetArgs &);
} ;

/////////////////////////////////////////////////////////////////////
//
//  Here's a pushbutton widget
//

class CPushButtonWidget : public CWidget {

	WidgetClass	Class();
public:
	CPushButtonWidget(const char *);
	~CPushButtonWidget();
	void	Create(CWidget *parent);
} ;

/////////////////////////////////////////////////////////////////////
//
//  Here's a cascadebutton widget
//

class CCascadeButtonWidget : public CWidget {

	WidgetClass	Class();
public:
	CCascadeButtonWidget(const char *);
	~CCascadeButtonWidget();
	void	Create(CWidget *parent);
} ;

/////////////////////////////////////////////////////////////////////
//
//  Here's a togglebutton widget
//

class CToggleButtonWidget : public CWidget {

	WidgetClass	Class();
public:
	CToggleButtonWidget(const char *);
	~CToggleButtonWidget();
	void	Create(CWidget *parent);
	AFXBOOL	IsSet();
	void	Set(AFXBOOL);
} ;

/////////////////////////////////////////////////////////////////////
//
// Here's a form widget (hey, it's a simple implementation!

class CFormWidget : public CWidget {
	WidgetClass	Class();
	Widget	CreateWidget(const char *, Widget, CWidgetArgs *);
	AFXBOOL		m_autoDialogUnmanage;
public:
	CFormWidget(const char *);
	~CFormWidget();
	void	Create(CWidget *parent);
	void	AutoDialogUnmanage(AFXBOOL f) { m_autoDialogUnmanage=f; }
} ;


#endif
