// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetredirect_h
#define	widgetredirect_h

static const char widgetredirect_h_rcsid[]="$Id: widgetredirect.h,v 1.3 1999/04/09 02:25:54 mrsam Exp $";

///////////////////////////////////////////////////////////////////////
//
// Redirect templates are used to redirect virtual functions of a base
// class into member functions of another class.  These are generic
// templates applicable to several base classes.  Specific templates
// customized for a specific class are defined in the header file
// for that class.

///////////////////////////////////////////////////////////////////////
//
//  Redirect OnActivate()

template<class Base, class T> class CActivateRedirect : public Base {
	T *m_instance;
	void (T::*m_method)();
public:
	CActivateRedirect(const char * name) : Base(name),
		m_instance(NULL), m_method( (void (T::*)()) NULL)
	{
	}

	~CActivateRedirect()	{}

	void operator=(T *p) { m_instance=p; }
	void operator=(void (T::*p)()) { m_method=p; }
	void OnActivate() { if (m_instance && m_method)
				(m_instance->*m_method)();
			}
} ;

///////////////////////////////////////////////////////////////////////
//
//  Redirect OnOk()/OnCancel()s

template<class fromClass, class toClass> class CSelectionRedirect:
		 public fromClass {

	toClass	*m_instance;
	void	(toClass::*m_applyFunc)();
	void	(toClass::*m_cancelFunc)();
public:
	CSelectionRedirect(const char * strName): fromClass(strName),
		m_instance(NULL),
		m_applyFunc( (void (toClass::*)()) NULL),
			m_cancelFunc( (void (toClass::*)()) NULL)
	{
	}
	~CSelectionRedirect()	{}

	void	operator=( toClass *p)	{ m_instance=p; }
	void	Ok( void (toClass::*p)() ) { m_applyFunc=p; }
	void	Cancel( void (toClass::*p)() ) { m_cancelFunc=p; }

	void	OnOk();
	void	OnCancel();
} ;

template<class fromClass, class toClass> void
		CSelectionRedirect<fromClass, toClass>::OnOk()
{
	if (m_instance && m_applyFunc)
		(m_instance->*m_applyFunc)();
}

template<class fromClass, class toClass> void
		CSelectionRedirect<fromClass, toClass>::OnCancel()
{
	if (m_instance && m_cancelFunc)
		(m_instance->*m_cancelFunc)();
}

#endif
