// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<Xm/Xm.h>
#include	<Xm/ScrolledW.h>
#include	<Xm/ScrollBar.h>
#include	"widgetscroll.h"
#include	"widgetargs.h"

static const char rcsid[]="$Id: widgetscroll.C,v 1.2 1999/04/09 02:25:54 mrsam Exp $";

static void OnScrollStatusCallback(Widget, XtPointer clientData, XtPointer p)
{
XmScrollBarCallbackStruct	*scs=(XmScrollBarCallbackStruct *)p;

	((CWidget *)clientData)->OnScrollStatus(scs->value);
}

//////////////////////////////////////////////////////////////////

WidgetClass CScrollBarWidget::Class()
{
	return (xmScrollBarWidgetClass);
}

CScrollBarWidget::CScrollBarWidget(const char * str) : CWidget(str)
{
}

CScrollBarWidget::~CScrollBarWidget()
{
}

void CScrollBarWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);
	XtAddCallback(wid(), XmNvalueChangedCallback, &OnScrollStatusCallback,
		(XtPointer)this);
}

void CScrollBarWidget::OnScrollStatus(int)
{
}

void CScrollBarWidget::Set(int minimum, int maximum, int size, int top)
{
CWidgetArgs	args;

	args.Add(XmNminimum, minimum);
	args.Add(XmNmaximum, maximum+size);
	args.Add(XmNsliderSize, size);
	args.Add(XmNvalue, top);
	SetValues(args);
}

void CScrollBarWidget::PageSize(unsigned s)
{
CWidgetArgs	args;

	args.Add(XmNpageIncrement, s);
	SetValues(args);
}

void CScrollBarWidget::OnBaseTextChange(size_t /*total*/, size_t top,
		size_t last, size_t pagesize)
{
	Set(0, last, 1, top);
	PageSize(pagesize ? pagesize:1);
}

int CScrollBarWidget::Value()
{
Arg	a;
int	val;

	XtSetArg(a, XmNvalue, (XtArgVal)&val);
	if (wid())
		XtGetValues(wid(), &a, 1);
	return ((int)val);
}

int CScrollBarWidget::SliderSize()
{
Arg	a;
int	val;

	XtSetArg(a, XmNsliderSize, (XtArgVal)&val);
	if (wid())
		XtGetValues(wid(), &a, 1);
	return ((int)val);
}
/////////////////////////////////////////////////////////////////////

CScrollWindowWidget::CScrollWindowWidget(const char * name)
	: CWidget(name)
{
}

CScrollWindowWidget::~CScrollWindowWidget()
{
}

WidgetClass CScrollWindowWidget::Class()
{
	return (xmScrolledWindowWidgetClass);
}

void CScrollWindowWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);
}
