// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetscroll_h
#define	widgetscroll_h

static const char widgetscroll_h_rcsid[]="$Id: widgetscroll.h,v 1.2 1999/04/09 02:25:54 mrsam Exp $";


#include	"widget.h"

/////////////////////////////////////////////////////////////////////
//
// Here's the scroll bar

class CScrollBarWidget : public CWidget {
	WidgetClass	Class();
public:
	CScrollBarWidget(const char *);
	~CScrollBarWidget();
	void	Create(CWidget *);
	void	OnScrollStatus(int);
	void	Set(int, int, int, int);
	void	PageSize(unsigned);
	int	Value();
	int	SliderSize();

	// The following shortcut allows CBaseTextWidget::OnStatusChange
	// to be redirected here

	void	OnBaseTextChange(size_t total, size_t top, size_t last,
				size_t pagesize);
} ;

/////////////////////////////////////////////////////////////////////
//
// Here's the scrollwindow bar

class CScrollWindowWidget : public CWidget {
	WidgetClass	Class();
public:
	CScrollWindowWidget(const char *);
	~CScrollWindowWidget();
	void	Create(CWidget *);
} ;

// Redirection template for the scrollbar

template<class T> class CScrollBarWidgetRedirect : public CScrollBarWidget {
        T	*m_instance;
	void	(T::*m_method)(int);
public:
        CScrollBarWidgetRedirect(const char * s) : CScrollBarWidget(s),
			m_instance(0), m_method((void (T::*)(int))0) {}
        void operator=(T *p) { m_instance=p; }
	void operator=( void (T::*p)(int) ) { m_method=p; }

        ~CScrollBarWidgetRedirect()     {}
        void    OnScrollStatus(int val)
		{
			if (m_instance && m_method)
				(m_instance->*m_method)(val);
		}
} ;

#endif
