// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<X11/Intrinsic.h>
#include	<X11/Shell.h>
#include	"widget.h"
#include	"widgetshell.h"
#include	"widgetpixmap.h"
#include	"widgetargs.h"

#include	<stdio.h>
static const char rcsid[]="$Id: widgetshell.C,v 1.4 1999/04/12 04:38:22 mrsam Exp $";

CShellWidget::CShellWidget(const char * name)
	: CWidget(name),
	m_auto_deiconify(0),
	m_auto_iconify_seconds(0),
	m_auto_close_seconds(0)
{
	m_autoiconify_timeout=this;
	m_autoclose_timeout=this;
}

CShellWidget::~CShellWidget()
{
}

void CShellWidget::Create(CString title)
{
	if (!CApplicationWidget::m_shellptr)	AfxThrowInternalException();
	if (!CApplicationWidget::m_shellptr->wid()) AfxThrowInternalException();
	Destroy();

	m_class=ClassName();

Widget	w=XtAppCreateShell (m_name, m_class,
                applicationShellWidgetClass, *CApplicationWidget::m_shellptr,
			NULL, 0);
	if (!w)	AfxThrowMemoryException();
	try
	{
		wid(w);
		installDestroyCallback();
		installOnCloseCallback();
		installMapCallback();
	}
	catch (...)
	{
		XtDestroyWidget(w);
		throw;
	}
	Title(title);
}

CString CShellWidget::ClassName()
{
	return (CApplicationWidget::m_AppClass);
}

void CShellWidget::Realize()
{
	if ((Pixmap)CApplicationWidget::m_DefaultIcon)
	{
		if (!m_icon.Ptr() && !m_icon.Init(new CXmIcon))
			AfxThrowMemoryException();
		m_icon->Create( *this, CApplicationWidget::m_DefaultIcon );
	}
	CWidget::Realize();
}

void CShellWidget::OnClose()
{
	CWidget::OnClose();
}

void CShellWidget::OnDestroy()
{
	if (m_icon.Ptr())
		m_icon->Destroy();
	CWidget::OnDestroy();
}

int CShellWidget::Iconic()
{
	return (GetValueBool(XmNiconic));
}

void CShellWidget::Iconify()
{
Widget	w=wid();
CWidgetArgs	arg;

	if (!w)	return;

	arg.Add(XmNiconic, TRUE);
	SetValues(arg);
}


void CShellWidget::DeIconify()
{
Widget	w=wid();

	if (!w)	return;

	if (Iconic())
		XtMapWidget(w);
}

void	CShellWidget::AutoDeIconify(AFXBOOL flag)
{
	m_auto_deiconify=flag;
}

void	CShellWidget::AutoIconify(unsigned nseconds)
{
	if ((m_auto_iconify_seconds=nseconds) == 0)
		m_autoiconify_timeout.Cancel();
	else
		m_autoiconify_timeout.Arm( &CShellWidget::iconify, nseconds);
}

void	CShellWidget::AutoClose(unsigned nseconds)
{
	if ((m_auto_close_seconds=nseconds) == 0)
		m_autoclose_timeout.Cancel();
	else
		m_autoclose_timeout.Arm( &CShellWidget::close, nseconds);
}

void	CShellWidget::AutoClose()
{
	Destroy();
}

void	CShellWidget::Activity()
{
	if (m_auto_deiconify)
		DeIconify();
	if (m_auto_iconify_seconds)
		m_autoiconify_timeout.Arm( &CShellWidget::iconify,
			m_auto_iconify_seconds);
	if (m_auto_close_seconds)
		m_autoclose_timeout.Arm( &CShellWidget::close,
			m_auto_close_seconds);
}

void	CShellWidget::iconify()
{
	Iconify();
}

void	CShellWidget::close()
{
	AutoClose();
}

void	CShellWidget::OnMapped()
{
	Activity();
}

void	CShellWidget::OnUnmapped()
{
}
