// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgettext_h
#define	widgettext_h

static const char widgettext_h_rcsid[]="$Id: widgettext.h,v 1.4 1999/04/09 02:32:28 mrsam Exp $";


#include	"afx.h"
#include	<X11/Intrinsic.h>

/////////////////////////////////////////////////////////////////////
//
// Here's the text widget

class CTextWidget : public CWidget {
	WidgetClass	Class();

	AFXBOOL	m_hresize;
	AFXBOOL	m_vresize;
	AFXBOOL	m_wrap;
	AFXBOOL	m_multiline;
	AFXBOOL	m_hscroll;
	AFXBOOL	m_vscroll;

	CString	m_verifystr;
	CString	m_initialValid, m_allValid;
public:
	void	DoHorizResize(AFXBOOL flag=TRUE)	{ m_hresize=flag; }
	void	DoVertResize(AFXBOOL flag=TRUE)	{ m_vresize=flag; }
	void	DoWordWrap(AFXBOOL flag=TRUE)	{ m_wrap=flag; }
	void	DoMultiline(AFXBOOL flag=TRUE)	{ m_multiline=flag; }
	void	DoHorizScroll(AFXBOOL flag=TRUE)	{ m_hscroll=flag; }
	void	DoVertScroll(AFXBOOL flag=TRUE)	{ m_vscroll=flag; }
	CTextWidget(const char *);
	~CTextWidget();
	void	Create(CWidget *parent, size_t ncols=0, size_t nrows=0);

	void	Editable(AFXBOOL=TRUE);
	void	VisibleCursor(AFXBOOL=TRUE);
	void	MaxLength(size_t);
	void	CursorPos(size_t);
	size_t	CursorPos();
	void	TopPos(size_t);
	size_t	TopPos();
	size_t	LastPosition();
	void	Redisplay(AFXBOOL=TRUE);
	void	GetSelected(size_t &, size_t &);
	void	SetSelected(size_t, size_t);
	void	InsertAt(size_t, CString);
virtual	CString	Value();
virtual	void	Value(CString);
	void	Append(CString);
virtual	void	OnModified();
virtual void	OnGotFocus();
virtual void	OnLostFocus();
	void	Verify(XmTextVerifyCallbackStruct *);
virtual AFXBOOL	OnVerify(CString, CString, size_t, size_t, CString &);
} ;

// Password text widget

class CPasswordTextWidget : public CTextWidget {

	CString	m_password;
public:
	CPasswordTextWidget(const char * str);
	~CPasswordTextWidget();
	void	Create(CWidget *parent, size_t ncols=0);

virtual	CString	Value();
virtual	void	Value(CString);

	AFXBOOL	OnVerify(CString, CString, size_t, size_t, CString &);
	void	OnActivate();
} ;
#endif
