// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetxms_h
#define	widgetxms_h

static const char widgetxms_h_rcsid[]="$Id: widgetxms.h,v 1.4 1999/04/09 02:32:28 mrsam Exp $";

#include	<X11/Intrinsic.h>
#include	<Xm/Xm.h>
#include	"afx.h"
#include	"afxtempl.h"

class	CWidget;

///////////////////////////////////////////////////////////////////////
//
// Encapsulate XmString.  I need to do a few things of my own, that's
// why I don't use CxxXmstring.
//
// I need a fast copy here, so I use the same approach as CString.

// Data ptr for the actual XmString, and a reference count.

class	CXmStringData {
public:
	unsigned m_refcnt;
	XmString m_str;
	} ;

// Here's the actual encapsulation.

class	CXmString {

	CXmStringData *m_ptr;

			// Return my XmString

	XmString	xmptr() const {
			return (m_ptr ? m_ptr->m_str:(XmString)NULL); }

			// Return a private copy of my XmString

public:
	CXmString();

virtual	~CXmString();

private:

	// Destroy my XmString.

	void Destroy()
	{
		if (m_ptr && --m_ptr->m_refcnt == 0)	// Last ref - destroy data
		{
			if (m_ptr->m_str)
				XmStringFree(m_ptr->m_str);
			delete m_ptr;
		}
		m_ptr=NULL;
	}
public:
	CXmString(const CXmString &p) : m_ptr(p.m_ptr)
			{
				if (m_ptr)	++m_ptr->m_refcnt;
			}

	CXmString &operator=(CString);
	CXmString &operator=(XmString);

			// Copy constructor just deletes private data, and
			// increments reference count.

	CXmString &operator=(const CXmString &p)
			{
			CXmStringData *ptr=p.m_ptr;

				if (ptr)	
					++ptr->m_refcnt;
				Destroy();
				m_ptr=ptr;
				return (*this);
			}

	operator	CString() const;
	operator	XmString() const { return (xmptr()); }

	CXmString &operator += (XmString);
	CXmString operator + (XmString) const;

	void	Rendition(CString);
	void	Rendition(const char *);
} ;

////////////////////////////////////////////////////////////
//
// Unparse CXmString into a convenient String/Rendition list

class	CXmStringRenditions {
	CStringList	m_stack;
public:
	CStringList	m_strings;
	CStringList	m_renditions;

	CXmStringRenditions()	{}
	~CXmStringRenditions()	{}

	void	operator=(const CXmString &);
} ;

/////////////////////////////////////////////////////////////
//
// Get metrics for a CXmString

class CXmStringMetrics {
	CArray<XRectangle, XRectangle &>	m_aux;
public:
	CArray<XRectangle, XRectangle &>	m_metrics;
	CXmStringMetrics()		{}
	~CXmStringMetrics()		{}

	void	Measure(CWidget &w, XmRenderTable r, CXmString s)
		{
		CXmStringRenditions	sr;

			sr=s;
			Measure(w, r, sr);
		}

	void	Measure(CWidget &w, XmRenderTable r, CXmStringRenditions &);
} ;

/////////////////////////////////////////////////////////////
//
// Iterate over CXmStringRenditions and CXmStringMetrics

class CXmStringMetricIterator {

	CXmStringRenditions *m_renditions;
	POSITION	m_stringPos;	// in m_rendition.m_strings
	POSITION	m_rendPos;	// in m_rendition.m_renditions
public:
	size_t	m_metricIndex;	// Index in metrics
	CString	m_curString;	// Current string
	CString	m_curRendition;	// Current rendition
	size_t	m_curStringPos;	// Current index into m_curString;
	const char *	m_chptr;

	CXmStringMetricIterator() : m_renditions(NULL),
		m_stringPos(NULL), m_rendPos(NULL),
		m_metricIndex(0), m_curStringPos(0)	{}
	~CXmStringMetricIterator()			{}


	void	Start(CXmStringRenditions &);
	AFXBOOL	EOL() {
			return (m_stringPos == NULL);
		}
	void	Next()
		{
			++m_metricIndex;
			++m_curStringPos;
			++m_chptr;
			if (m_curStringPos == (size_t)m_curString.GetLength())
				Advance();
		}

	void	Advance();
} ;

/////////////////////////////////////////////////////////////
//
// Get metrics for a XmString

class	CXmStringWordWrap {

public:
	CXmStringWordWrap(const CXmString &xms,
		CWidget &w, XmRenderTable r, size_t wrapWidth,
		CList<CXmString, CXmString &> &list)
	{
	CXmStringRenditions	renditions;
	CXmStringMetrics	metrics;

		renditions=xms;
		metrics.Measure(w, r, renditions);
		WordWrap(renditions, metrics, wrapWidth, list);
	}

	~CXmStringWordWrap()	{}

	void	WordWrap(CXmStringRenditions &,
			CXmStringMetrics &,
			size_t,
			CList<CXmString, CXmString &> &);
	} ;

// Helper class for parsing

class CXmStringContext {
	XmStringContext context;
	unsigned int len;
	CString	val;
public:
	CXmStringContext() : context(NULL)	{}
	~CXmStringContext();
	AFXBOOL Start(XmString);
private:
	void Destroy();
public:
	XmStringComponentType Next();
	unsigned int Len() { return (len); }
	CString Val() { return ( val ); }
} ;
#endif
