// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"xwidget.h"
#include	"widget/widgettext.h"
#include	"X11/Intrinsic.h"
#include	<iostream.h>
#include	<strstream.h>

static const char rcsid[]="$Id: xwidget.C,v 1.3 1999/04/09 03:02:54 mrsam Exp $";


CXSimpleEditForm::CXSimpleEditForm(const char *name, size_t nfields) :
	CFormWidget(name), m_nfields(nfields),
	m_ok("ok"), m_cancel("cancel"), m_sep1("sep1")
{
	m_ok=this;
	m_cancel=this;
	m_ok= &Ok;
	m_cancel= &Cancel;
}

CXSimpleEditForm::~CXSimpleEditForm()
{
	Cleanup();
}

void CXSimpleEditForm::Cleanup()
{
size_t i;

	if (m_wlabels.GetSize())
		for (i=0; i<m_nfields; i++)
		{
			if (m_wlabels[i])
			{
				delete m_wlabels[i];
				m_wlabels[i]=NULL;
			}
			if (m_wfields[i])
			{
				delete m_wfields[i];
				m_wfields[i]=NULL;
			}
		}
}

void CXSimpleEditForm::OnDestroy()
{
	Cleanup();
	CFormWidget::OnDestroy();
}

// Allocate the arrays (but not the widgets themselves)

void CXSimpleEditForm::init_all_this()
{
	try
	{
		if (m_wlabels.GetSize() == 0)
		{
		size_t	i;

			m_wlabels.SetSize(m_nfields);
			for (i=0; i<m_nfields; i++)
				m_wlabels[i]=NULL;
			m_wfields.SetSize(m_nfields);
			for (i=0; i<m_nfields; i++)
				m_wfields[i]=NULL;

			m_labelNames.SetSize(m_nfields);
			m_textNames.SetSize(m_nfields);

			for (i=0; i<m_nfields; i++)
			{
			char	buf[40];

				ostrstream(buf, sizeof(buf))
					<< "label" << (i+1) << '\0';
				m_labelNames[i]=buf;
				ostrstream(buf, sizeof(buf))
					<< "edit" << (i+1) << '\0';
				m_textNames[i]=buf;
			}
		}
	}
	catch (...)
	{
		Destroy();
		throw;
	}
}

void CXSimpleEditForm::OverrideField(size_t i, CTextWidget *p)
{
	if (i >= m_nfields)	AfxThrowInternalException();
	init_all_this();
	if (m_wfields[i])
		delete m_wfields[i];
	m_wfields[i]=p;
}

CTextWidget *CXSimpleEditForm::GetField(size_t i)
{
	if (i >= m_nfields)	AfxThrowInternalException();
	return (m_wfields[i]);
}

void CXSimpleEditForm::Create(CWidget *parent)
{
size_t	i;

	CFormWidget::Create(parent);
	try
	{
		init_all_this();
		for (i=0; i<m_nfields; i++)
			if ((m_wlabels[i] == NULL &&
				(m_wlabels[i]=new CLabelWidget(m_labelNames[i]))
					== NULL) ||

				(m_wfields[i] == NULL && (m_wfields[i]=
					new CTextWidget(m_textNames[i]))
					== NULL)
				)
				AfxThrowMemoryException();

		m_sep1.IsGadget(TRUE);
		m_sep1.Create(this, m_sep1.horizontal);
		m_ok.Create(this);
		m_cancel.Create(this);

		m_ok.Attach(CWidgetToForm, NULL, m_sep1, NULL);
		m_cancel.Attach(NULL, CWidgetToForm, m_sep1, NULL);

		for (i=0; i<m_nfields; i++)
			m_wlabels[i]->Create(this);

		for (i=0; i<m_nfields; i++)
			m_wfields[i]->Create(this);

		for (i=0; i<m_nfields; i++)
		{
			m_wfields[i]->Attach(NULL, CWidgetToForm, CWidgetToForm,
					NULL);

			if (i)
				m_wfields[i]->AttachOpposite( *m_wfields[0],
					NULL, *m_wfields[i-1], NULL);

			m_wlabels[i]->Attach(NULL, *m_wfields[i], NULL, NULL);
			m_wlabels[i]->AttachOpposite(NULL, NULL,
					*m_wfields[i], *m_wfields[i]);
		}
		m_sep1.Attach(CWidgetToForm, CWidgetToForm,
			m_nfields ?  (CWidgetAttach)*m_wlabels[m_nfields-1]:
			CWidgetToForm, NULL);

		for (i=0; i<m_nfields; i++)
		{
			m_wlabels[i]->Manage();
			m_wfields[i]->Manage();
		}
		m_sep1.Manage();
		m_ok.Manage();
		m_cancel.Manage();
	}
	catch (...)
	{
		Destroy();
		throw;
	}
}

void CXSimpleEditForm::Ok()
{
	UnManage();
}

void CXSimpleEditForm::Cancel()
{
	UnManage();
}
