// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	xwidget_h
#define	xwidget_h

static const char xwidget_h_rcsid[]="$Id: xwidget.h,v 1.2 1999/04/09 03:02:54 mrsam Exp $";


#include	"widget/widget.h"
#include	"widget/widgetprim.h"
#include	"widget/widgetredirect.h"

class CXSimpleEditForm;
class CTextWidget;
class CLabelWidget;

class CXSimpleEditForm : public CFormWidget {
	size_t	m_nfields;
	CActivateRedirect<CPushButtonWidget, CXSimpleEditForm> m_ok;
	CActivateRedirect<CPushButtonWidget, CXSimpleEditForm> m_cancel;
	CSeparatorWidget			m_sep1;
	CArray<CLabelWidget *, CLabelWidget *>	m_wlabels;
	CArray<CTextWidget *, CTextWidget *>	m_wfields;
	CStringArray		m_labelNames, m_textNames;
	void	init_all_this();
public:
	CXSimpleEditForm(const char *, size_t);
	~CXSimpleEditForm();
	void	Create(CWidget *);
	void	OverrideField(size_t, CTextWidget *);
	CTextWidget *GetField(size_t);

virtual void	Ok(), Cancel();
private:
	void	Cleanup();
	void	OnDestroy();
} ;

template<class T> class	CXSimpleEditFormRedirect : public CXSimpleEditForm {
	T *m_instance;
	void (T::*m_method)(AFXBOOL);
public:
	CXSimpleEditFormRedirect(const char *name, size_t cnt) :
		CXSimpleEditForm(name, cnt),
		m_instance(NULL), m_method( (void (T::*)(AFXBOOL)) NULL)
	{
	}
	~CXSimpleEditFormRedirect()	{}

	void operator=(T *p) { m_instance=p; }
	void operator=(void (T::*p)(AFXBOOL)) { m_method=p; }
	void Ok() { if (m_instance && m_method)
				(m_instance->*m_method)(TRUE);
			}
	void Cancel() { if (m_instance && m_method)
				(m_instance->*m_method)(FALSE);
			}
} ;

#endif
