;; Copy this file to ~/.sula/.gsularc
;; /home/ft22/.sula/.gsularc.
;; ---------------
;; last edited 23Aug99.
;; Put anything in here that you want done on startup.

(say "This is .gsularc loading ...") 
(say "-- Using Guile version @b" (version) "@!b --")

;;Unreal IRCD:
;;------------
; load UnrealIRCD.scm instead

;; some modules you may want to have
(catch #t (lambda() (use-modules (ice-9 string-fun))) gs-handler)
(catch #t (lambda() (use-modules (ice-9 session))) gs-handler); apropos
(catch #t (lambda() (use-modules (math random))) gs-handler)

;disable beep_on_error and restore it in the end. beeps are annoying.
(define beep_on_err (gs-set? "beep_on_error"))
(gs-set! "beep_on_error" #f)

;;nice listing of  channel bans
(gs-add-hook 367 "*" (lambda(m w)
  (_say2 w "@f@C1*@C6[@!C@$" (next-word m 4) "@!$@C6]@!C @C1@$" (next-word m 5)
    "@!$@!C by @C5@$" (next-word m 6) "@!$@C6[@!C"
    (strftime "%a %b %d %H:%M:%S" (localtime (string->number (next-word m 7))))
    "@C6]")))

; these overwrite settings in X resource file. Only look nice with GTK
; and if u have a black window background.
(let((__vars '(
  ("fmt_ctcp_reply"		"@f@C6[@C5%n@C6]@C7@.CTCP %f %p")
  ("fmt_other_dccchat"		"@f@D9=@C5%n@!C=@^@. %p")
  
  ("fmt_other_kick"		"@C1**@!C%f has been kicked off channel %c by %n (@$%p@!$)")
  ("fmt_priv_action"		"@C2>Action:@!C@. %n %p")
  ("fmt_priv_msg"		"@f@C6[@!C%H:%M.%S@C6]@C5<%n>@^@. %p")
  ("fmt_priv_notice"		"@f@C6[@!C%H:%M.%S@C6]@C5<-%n:@$%l@!$@@@$%h@!$-@^@. %p")
  ("fmt_pub_action"		"@C5Action on %c:@!C@. %n %p")
  ("fmt_pub_msg"		"@f@b%c@!b @C5%n:@^@.%p")
  ("fmt_pub_msg2"		"@f%c/@C5%n:@^@. %p")
  ("fmt_pub_msg3"		"@f@C5(@!C%c/@C5%n)@^@i@. %p")
  ("fmt_pub_notice"		"@f@b%c @!b-@C5%n@!C-@^@. %p")
  ("fmt_pub_notice2"		"@f-%c/@C5%n@!C-@^@. %p")
  ("fmt_pub_notice3"		"@f(-%c/@C5%n@!C-)@^@i@. %p")
  ("fmt_sed_nokey"		"@f@b%c@!b@C5%n:@C9@D7[encrypted]")
  ("fmt_sed_priv"		"@i@.[%H:%M.%S]<%n> %p")
  ("fmt_sed_pub"		"@f@b%c@!b@C5%n:@^@C1@v@.%p")
  ("fmt_sed_your"		"@fE@b%c@!b @C2%n:@^@.%p")
  ("fmt_signoff"		"[%H:%M.%S]@C1%n has left IRC (@i@$%p@!$@!i)")
  ("fmt_topic"          "%n has changed the topic on channel %c to @i@.%p")
  ("fmt_you_dccchat"		"@f@C2>=%c@!C=@^@. %p")
  
  ("fmt_you_kick"		"@v[%H:%M:%S]@!v @C2@l%n@m has kicked you off @l%c@m (@$%p@!$)")
  ("fmt_you_priv_msg"		"@f@C6[@!C%H:%M.%S@C6]@C2>%c:@^@. %p")
  ("fmt_you_priv_notice"		"@f@C6[@!C%H:%M.%S@C6]@C2>-%c-@^@. %p")
  ("fmt_you_pub_action"		"@C2Action on %c:@!C@. %n %p")
  ("fmt_you_pub_msg"		"@f@b%c@!b @C2%n:@^@.%p")
  ("fmt_you_pub_notice"		"@f@b%c @!b-@C2%n@!C-@^@. %p")
  
  ("fmt_you_join"		"@f@C6[@!C%H:%M.%S@C6]@^You have joined channel @C6@.%c")
  ("fmt_you_part"   "@f@C6[@!C%H:%M.%S@C6]@^You have left channel @C6@.%c")
  ("fmt_other_join"	"@f@C6[@!C%H:%M.%S@C6]@^@C2@b%n@!C@!b (@C2%l@@%h@^) has joined @C6%c")
  ("fmt_other_part"	"@f@C6[@!C%H:%M.%S@C6]@^@C2@b%n@!C@!b (@C2%l@@%h@^) hat @C6@$%c@!$@^ verlassen.")
  
  ("fmt_dcc_chat_notify"
    "@C6[@!C%H:%M.%S@C6] @C2@,%i.@!C Chat request from @C2@$%n@!$@!C (@C2@$%h@!$@!C) @C6[@C1@s%z, %Z@C6@^]")
  ("fmt_dcc_file_notify"
    "@C6[@!C%H:%M.%S@C6] @C2@,%i.@!C DCC GET @C2@$%f@!$@!C (size:@C2 %j@!C, cksum:@C2 %k@!C) from @C2@$%n@!$@!C (@C2@$%h@!$@!C) @C6[@C1@s1%z, %Z@^@C6]")
  ("fmt_server_notice" "@C1-@C6@$%n@!$@C1-@. %p")
  )))
  
  (for-each (lambda(var) (gs-set! (car var) (cadr var))) __vars))

(gs-set! "beep_on_error" beep_on_err)
(undefine beep_on_err)

(connect-and-join "irc.gimp.org" 6667 "#gimp")
;(server "de.undernet.org")
(say ".gsularc has been loaded.")
