;; Example of a DESTROY_WINDOW hook
;; Before closing down a window, this hook sends a message to all the
;; channels on the window

(gs-on "#WINDOW_DESTROY" 200 "*" (lambda(junk window)
  (call-with-current-continuation
    (lambda(return)
      (define server (gs-window-server))
      (if(null? server) (return #f)) ;; window is not connected to a server
      (define channels (gs-window-channels window))
      (if(null? channels) (return #f));; window has no channels;
       ;; Let's write directly to the server using IRC protocol
      (define fd (server:fd server))
      (for-each
        (lambda(chan) (gs-raw-write fd
          (string-append "PRIVMSG " (channel:name chan)
          " :bye bye Cruel world!\n")))
        channels)))))
 
