;; examples of regex hooks
(let()
  (define (kick_lamer lamer channel reason window)
    (if(channel:op? (gs-channel channel window))
      (gs-exec (string-append "kick " channel " " lamer " " reason) window)))
  (define (no-CAPS-please m w)
    (kick_lamer ($nick m) ($dest m) "Turn off the damn CAPS" w))
  ;; Excessive CAPS: message is longer than 10 chars but contains
  ;; no lowercase characters and no digits
  (gs-regex-hook "#public_msg" 001 "^([^ ]+ ){3}[^a-z0-9]{10,}$" no-CAPS-please)
  (gs-regex-hook "#public_notice" 001 "^([^ ]+ ){3}[^a-z0-9]{10,}$" no-CAPS-please)
  ;;EXcessive !!!! or ?????? or a combination of both (atleast 5 together)
  (gs-regex-hook "#public_msg" 001 ".*[!?]{5,}" (lambda(m w)
    (kick_lamer ($nick m) ($dest m) "Calm down!" w)))
  ;; A message which contains no alphabetic characters
  (gs-regex-hook "#public_msg" -1 "^([^ ]+ ){3}[^a-zA-Z0-9]{4,}$" (lambda(m w)
    (gs-exec
      (string-append "/msg " ($dest m) " "($nick m) ": say something legible")
      w))))
