/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


#ifndef _gtk_tb_H
#define _gtk_tb_H
#include <sys/param.h>
#include <gtk/gtk.h>
#include <gtk/gtk.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/X.h>
#include <X11/Xresource.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

typedef XrmOptionDescRec GTK_CMD_OPT;
typedef enum
{
  GTK_NONE,
  GTK_BOOL, GTK_SHORT, GTK_INT, GTK_LONG,
  GTK_FLOAT, GTK_DOUBLE, GTK_STRING
}
GTK_RESOURCE_TYPE;
typedef struct
{
  char *str_name;
  char *str_class;
  GTK_RESOURCE_TYPE type;
  void *buf;                    /* result will be stored here */
  char *defval;
  size_t size;                  /* size of buf if type of GTK_STRING */
}
GTK_resource;

extern int gtk_initialize(int *argc, char **argv,
                          const char *app_class_name,
                          GTK_CMD_OPT * cmd_opt,
                          size_t cmd_opt_count);
extern char *gtk_get_app_resource(const char *str_name,
                                  const char *str_class,
                                  GTK_RESOURCE_TYPE type,
                                  const char *defval,
                                  void *buf,
                                  size_t size);
extern void gtk_get_app_resources(GTK_resource *, size_t);
extern void init_fonts(void);
/* load a file, interpreting format characters if flag!=0 */
extern int _spx_load_file(GtkWidget * text, const char *fname, int flag);

/* for lack of better names... */
#define spx_load_file(__w_, __f_) _spx_load_file((__w_), (__f_), 1)
#define spx_load_simple_file(__w_, __f_) _spx_load_file((__w_), (__f_), 0)

extern void spx_write(GtkWidget * text, const char *str);
#define spx_write1(_w, _s) do{\
  gtk_text_insert(GTK_TEXT(_w),NULL,NULL,NULL,"\n",1);\
  spx_write((_w), (_s));}while(0)
#define spx_writeln(_w, _s) do{spx_write((_w), (_s));\
  gtk_text_insert(GTK_TEXT(_w),NULL,NULL,NULL,"\n",1);}while(0)
extern char spx_format_char;
extern int spx_add_colour(const char *name);
extern int spx_max_colour;
typedef enum
{
  STYLE_NORMAL, STYLE_BOLD, STYLE_ITALIC, STYLE_ITALICBOLD,
  STYLE_FIXED, STYLE_FIXEDBOLD, STYLE_FIXEDITALIC, STYLE_FIXEDBOLDITALIC,

  STYLE_SMALL, STYLE_BOLD_SMALL, STYLE_ITALIC_SMALL, STYLE_ITALICBOLD_SMALL,
  STYLE_FIXED_SMALL, STYLE_FIXEDBOLD_SMALL, STYLE_FIXEDITALIC_SMALL,
  STYLE_FIXEDBOLDITALIC_SMALL,

  STYLE_LARGE, STYLE_BOLD_LARGE, STYLE_ITALIC_LARGE, STYLE_ITALICBOLD_LARGE,
  STYLE_FIXED_LARGE, STYLE_FIXEDBOLD_LARGE, STYLE_FIXEDITALIC_LARGE,
  STYLE_FIXEDBOLDITALIC_LARGE,

  STYLE_INVALID
}
Font_idx;
extern GdkFont *spx_idx2font(Font_idx);
typedef enum{
 SPX_COL_BLACK=0, SPX_COL_RED, SPX_COL_GREEN,
 SPX_COL_YELLOW, SPX_COL_BLUE, SPX_COL_MAGENTA,
 SPX_COL_CYAN, SPX_COL_WHITE, SPX_COL_INVALID} SPX_COLOUR;
extern GdkColor spx_get_colour(SPX_COLOUR);
extern int spx_str2col_font(const char *, int *bg, int *fg, GdkFont **);
#define SPX_BLACK() spx_get_colour(SPX_COL_BLACK)
#define SPX_RED() spx_get_colour(SPX_COL_RED)
#define SPX_GREEN() spx_get_colour(SPX_COL_GREEN)
#define SPX_YELLOW() spx_get_colour(SPX_COL_YELLOW)
#define SPX_BLUE() spx_get_colour(SPX_COL_BLUE)
#define SPX_MAGENTA() spx_get_colour(SPX_COL_MAGENTA)
#define SPX_CYAN() spx_get_colour(SPX_COL_CYAN)
#define SPX_WHITE() spx_get_colour(SPX_COL_WHITE)
#endif
