/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


#ifndef _spx_gui_gtk_h
#define _spx_gui_gtk_h
#include <X11/X.h>
#include <X11/keysym.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include "selection_dialog.h"
extern GtkWidget *create_pixmap_from_data(GtkWidget *, gchar **);
extern GtkWidget *create_pixmap_from_path(GtkWidget *, gchar *);

typedef struct
{
  GtkWidget *clist;
  GtkWidget *update;
  GtkWidget *go;
  GtkWidget *kick;
  GtkWidget *ban;
  GtkWidget *ignore;
  GtkWidget *channel;
  GtkWidget *ok;
}
SPX_chanusers;

#define hide_chanusers_channel(__win, __hide) do{\
   if(__hide){\
      if (GTK_WIDGET_VISIBLE((__win)->chanwin->chanusers.channel)){\
        gtk_widget_hide((__win)->chanwin->chanusers.channel);\
        gtk_widget_hide((__win)->chanwin->chanusers.ok);\
        gtk_widget_hide((__win)->chanwin->chanusers.update);\
      }\
    }else if (!GTK_WIDGET_VISIBLE((__win)->chanwin->chanusers.channel)){\
       gtk_widget_show((__win)->chanwin->chanusers.channel);\
       gtk_widget_show((__win)->chanwin->chanusers.ok);\
       gtk_widget_show((__win)->chanwin->chanusers.update);\
    }\
  }while(0)

typedef struct
{
  GtkWidget *chanwin;
  SPX_chanusers chanusers;
  GtkWidget *cmd_bwd;
  GtkWidget *cmd_fwd;
  GtkWidget *browser;
  GtkWidget *sinput;
  GtkWidget *status;
  GtkWidget *clock;
  GtkWidget *menubar;
  GtkWidget *brow2;
  GtkWidget *WinStatusLine;
  GtkWidget *chan_right;
  GtkWidget *chan_left;
  GtkWidget *part;
  GtkWidget *dcc;
  GtkWidget *info;
  GtkWidget *close_con;
  GtkWidget *join;
  GtkWidget *away;
  GtkWidget *minput;
  GtkWidget *lead;              /*be the lead window for a server */
  GtkWidget *history;
  GtkWidget *action;
  GtkWidget *type;
#if 1
  GtkWidget *find;
#endif
  GtkWidget *r_quote;
  GtkWidget *r_query;
  GtkWidget *r_channel;
  GtkWidget *r_dcc_chat;
  GtkWidget *r_echo;

  GtkWidget *lag;
  GtkWidget *lag_button;

  GtkItemFactory *ifactory;
}
SPX_chanwin;
typedef struct
{
  GtkWidget *main_window;
  GtkWidget *FwdHist;
  GtkWidget *HistRew;
  GtkWidget *servers;
  GtkWidget *newwin;
  GtkWidget *quit;
  GtkWidget *setup;
  GtkWidget *script;
  GtkWidget *editor;
  GtkWidget *browser;
  GtkWidget *main_input;
  GtkWidget *uguide;
  GtkWidget *clock;
  GtkWidget *verbose_ret;
}
SPX_main_window;
typedef struct
{
  GtkWidget *window;
  GtkWidget *browser;
  GtkWidget *connect;
  GtkWidget *disconnect;
  GtkWidget *add;
  GtkWidget *edit;
  GtkWidget *remove;
  GtkWidget *update;
  GtkWidget *save;
  GtkWidget *dismiss;
  GtkWidget *status;
}
Server_tool;

typedef struct
{
  GtkWidget *window;
  GtkWidget *browser;
  GtkWidget *update;
  GtkWidget *status;
}
Script_control;
typedef struct
{
  short w;
  char *s;
}
Go_menu_info;
typedef struct
{
  short w;
  short data;
}
Menu_info;
typedef struct
{
  GtkWidget *setup;
  GtkWidget *notebook;
  GtkWidget *status;
  GtkWidget *s_clist;           /*strings */
  GtkWidget *s_entry;
  GtkWidget *n_clist;           /*numbers */
  GtkWidget *n_entry;           /*spin button input */
  GtkWidget *f_clist;           /*flags */
  GtkWidget *state;             /*checkbuttn */
}
Setup_tool;
extern Setup_tool *setup_tool;
extern Setup_tool *create_setup_tool(void);

SPX_main_window *create_control_window(void);
Server_tool *create_server_tool(void);
GtkWidget *create_server_add(void);
#define page_up(_adj) do{\
        gfloat _cur_= (_adj)->value- (_adj)->page_size;\
        if(_cur_<0) _cur_=0.0;\
        gtk_adjustment_set_value(_adj, _cur_);\
    }while(0)

#define page_down(_adj) do{\
        gfloat _cur_= ((_adj)->value+(_adj)->page_size);\
        if(_cur_>= (_adj)->upper)  _cur_= (_adj)->upper-(_adj)->page_size;\
        else if(_cur_+ (_adj)->page_size> (_adj)->upper)\
          while(_cur_+ (_adj)->page_size> (_adj)->upper)\
            _cur_ -= (_adj)->step_increment;\
        gtk_adjustment_set_value(_adj, _cur_);\
    }while(0)
extern void confirm2(const char *, const char *, int tmout,
                     void (*)(int, void *), void *);

extern GtkTooltips *tooltips;
extern void chanwin_cb(GtkWidget * widget, gpointer data);
extern void radio_cb(GtkWidget * widget, gpointer data);
extern void
     serverlist_cb(GtkButton * button, gpointer data);
extern void
     menu_cb(
#if 1
              GtkWidget * menuitem,
#endif
              gpointer data);

void
     main_cb(GtkWidget * widget,
             gpointer data);
#endif
