/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


#ifndef _skriptx_h
#define _skriptx_h

#include "spx.h"
#include <gtk/gtk.h>

typedef enum{
  SX_TOGGLE,/* checkbutton*/
  SX_NUMBER, /* whole number*/
  SX_FLOAT,
  SX_STRING, /* string*/
  SX_FILE,/*pathname*/
  SX_FONT,/*font name*/
  SX_COLOUR, /*colour spec*/
  SX_TEXT, /*multiple line text (editor)*/
  SX_SLIST, SX_MLIST,
  SX_PIXMAP,/*display pixamp*/
/* SkriptX -menus */
  SX_LABEL, /* display text*/
  SX_BROWSE, /* display text in a text widget*/
  SX_FILELOAD, /*load file into text widget*/
  SX_HBOX,
  SX_BUTTON,
  SX_CLIST,/* SX_CLIST singl */
  SX_CANCEL, /* label cancel butn*/
  SX_OK,     /* label ok butn*/
  SX_DESCR,
  /*SX_AUTHOR, SX_ADDRESS, SX_DATE,*/
  SX_TITLE=999,
  } ParamType;
typedef struct{
  int scm;
  int box;
  SCM data;
}CB_struct;
typedef struct{
  ParamType type;
  char *prompt;
  char *prev_value;
  union{
    char *sval;
    int ival;
    char **vval; /* a list*/
    struct{
      int multiple; /* single/multiple selection*/
      int len;
      char **title;
      SCM val;
    }clist;
    CB_struct cbs;  /*if button, proc*/
  }val;
  int w, h;/* widget size (for those that require it)*/
}_Param;
typedef struct{
  /*char *author;
  char *address;
  char *date;*/
  char *path;
  char *cmd; /* name of procedure (cmd w par1 par2 ...)*/
}_Misc;
typedef struct{
  char *window_title;
  char *descr;
  char *ok_label;
  char *cancel_label;
  int flag;
  #define SKX_DIALOG  (1<<0)
  #define SKX_MENU    (1<<1)
  #define SKX_ISFREE  (1<<2)
  #define SKX_CONSOLE (1<<3) /*a console menu item */
  union{
     _Misc *sx;
     int scm[2];/* ok, cancel*/
  }proc;
  int nparams;/* number of parameters */
  _Param *param;/* array of size nparams */
}Win_pup;
extern Win_pup *win_pup;
extern int win_pup_count;
extern void initialize_skriptx(void);
extern long sx_submit_data;
extern void sx_populate_factory(GtkItemFactory *);
#endif
