/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


#ifndef _chanuser_pup_h
#define _chanuser_pup_h
#include "spx.h"
#include <gtk/gtk.h>

/*channel user popup menu*/

typedef struct TPup_cmd{
  char *title;
  char *cmd; /* 
   (cmd channel nick addr)
        cmd: name of scheme proc
   process_cmd(cmd+string,win)
        in string:
                $N == selcted nick
                $C == channel
                $U == user@host
   */
  int type;
  #define PUP_CMD_SCM 1<<0
  #define PUP_CMD_IN 1<<1
  struct TPup_cmd *left;
  struct TPup_cmd *right;
  short bf;
}Pup_cmd;
typedef Pup_cmd *pPup_cmd;
extern Pup_cmd *pup_cmd;
extern GtkWidget *user_popup_list;/* window for listing cmds */
extern GtkWidget *chanusers_pup_menu;/* the menu*/
extern Winstruct *chanusers_pup_window;
#define initialize_user_pup() do{\
    GtkWidget *_menuitem = gtk_menu_item_new_with_label("Command list");\
    gtk_widget_set_state(_menuitem,GTK_STATE_INSENSITIVE);\
    gtk_widget_show(_menuitem);\
    if(chanusers_pup_menu) gtk_widget_destroy(chanusers_pup_menu);\
    chanusers_pup_menu = gtk_menu_new();\
    gtk_menu_append(GTK_MENU(chanusers_pup_menu), _menuitem);\
  }while(0)
extern Pup_cmd *find_pup(Pup_cmd * p, const char *name);
extern GtkWidget *create_new_pup(void);
extern GtkWidget *create_user_popup_list(void);
extern GtkWidget *user_popup_list;
extern void update_pup_list(int redraw_menu);
extern int add_users_pup(pPup_cmd *, const char *name, const char *cmd,int type);
extern void remove_pup(const char *title, char update);
extern void clear_pups(Pup_cmd *root);
extern void save_pups(const char *filename, void *junk);

#endif
