/*
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
*/
#include "spx.h"
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <assert.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include "gui_gtk.h"

#include "etc.h"
#include "selection_dialog.h"
#include "skriptx.h"
#include "userpup.h"
#include "spx2-mini.xpm"

extern void set_entry_focus(GtkObject * entry);
extern void chanusers_cb(GtkWidget * wid, gpointer data);

extern gint dont_close(gpointer data);
extern gint chanwin_raw_cb(GtkWidget *, GdkEventKey *, gpointer);
extern gint clist_raw_cb(GtkWidget *, GdkEventButton *, gpointer);
extern gint browser_raw_cb(GtkWidget *, GdkEventButton *, gpointer);
extern void chanuser_puplist_cb(GtkWidget * menuitem, gpointer data);
extern void file_menu_cb(GtkWidget * ob, gpointer data);
static Menu_info *file_menu_cb_data = NULL;

#define MAX_FILE_ITEMS (sizeof(DATA)/sizeof(short))
const short DATA[] =  {1, 2, 3, 401, 5, 701, 702, 703, 704, 8, 9};
static GtkItemFactory *win_pup_setup(Winstruct * win,
                      SPX_chanwin * chanwin,
                      Menu_info * fm)

{
  GtkItemFactoryEntry pup_menu_items[] =
  {
    {"/File", NULL, NULL, 0, "<Branch>"},
    {"/File/New window", 0, file_menu_cb, (long) &fm[0], 0},
    {"/File/div2", NULL, NULL, 0, "<Separator>"},
    {"/File/Load a file", NULL, file_menu_cb, (long) &fm[4], NULL},
    {"/File/div4", NULL, NULL, 0, "<Separator>"},
    {"/File/Close", 0, file_menu_cb, (long) &fm[9], NULL},
    {"/File/Exit", 0, file_menu_cb, (long) &fm[10], NULL},

    {"/Go", NULL, NULL, 0, "<Branch>"},
    {"/Part", NULL, NULL, 0, "<Branch>"},
    {"/Window", NULL, NULL, 0, "<Branch>"},
    {"/Window/Ignore", NULL, menu_cb, 802, NULL},
    {"/Window/Servers", NULL, menu_cb, 805, NULL},
    {"/Window/Channel user pup", NULL, menu_cb, 806, NULL},
    
    {"/SkriptX", 0, 0, 0, "<Branch>"},	/* 400 */
    {"/div", NULL, NULL, 0, "<Separator>"},

    {"/Help", NULL, NULL, 0, "<Branch>"},
    {"/Help/About", NULL, menu_cb, 901, NULL},
    {"/Help/div4", NULL, NULL, 0, "<Separator>"},
    {"/Help/Getting started", NULL, menu_cb, 903, NULL},
    {"/Help/Help guide", NULL, NULL, 0, "<Branch>"},
    {"/Help/Command list", NULL, menu_cb, 902, NULL},
    
  };
  GtkItemFactory *ifactory;

  chanwin->ifactory=ifactory = gtk_item_factory_new(GTK_TYPE_MENU,
    "<main>", 0);
  gtk_item_factory_create_items(ifactory,
                         sizeof(pup_menu_items) / sizeof(pup_menu_items[0]),
                                pup_menu_items, NULL);
  gtk_object_set_data(GTK_OBJECT(chanwin->chanwin),
                      "popup", ifactory);
  gtk_widget_set_sensitive(gtk_item_factory_get_item(ifactory, "/Part"), FALSE);
  sx_populate_factory(ifactory);
  gtk_widget_set_sensitive(
      gtk_item_factory_get_item(ifactory, "/Help/Getting started"),
                            FALSE);
  gtk_widget_set_sensitive(
           gtk_item_factory_get_item(ifactory, "/Help/Help guide"),
                            FALSE);
  
  return ifactory;
}
SPX_chanwin *create_chanwin(Winstruct * win)
{
  GtkWidget *vpaned;
  GtkWidget *hpaned;
  GtkWidget *vbox,
      *vbox2,
      *vbox3;
  GtkWidget *toolbar;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *table;
  GtkWidget *frame,
      *frame2;
  GtkWidget *hbox,
      *hbox2,
      *hbox3;
  GSList *radio_group;
  GtkWidget *wid_menu;
  GtkWidget *status_button,
      *status_hbox;
  GdkColormap *cmap;
  GtkWidget *scrolledwindow;
  GtkWidget *arrow;
  GtkWidget *wid;

  GtkStyle *style,
      *lag_style;
  GdkFont *font;
  SPX_chanwin *chanwin;
  int i;
  GtkItemFactory *ifactory;

  assert(win);
  cmap = gdk_colormap_get_system();

  chanwin = calloc(1, sizeof(SPX_chanwin));
  chanwin->chanwin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_object_set_user_data(GTK_OBJECT(chanwin->chanwin),
                           (gpointer) (win - winstruct));
  gtk_window_set_title(GTK_WINDOW(chanwin->chanwin), "No server connection");
  gtk_window_set_policy(GTK_WINDOW(chanwin->chanwin), TRUE, TRUE, FALSE);
  gtk_widget_set_name(chanwin->chanwin, "channel window");
  gtk_signal_connect(GTK_OBJECT(chanwin->chanwin), "delete_event",
                     GTK_SIGNAL_FUNC(dont_close),
                     NULL);
  //gtk_widget_set_usize(chanwin->chanwin, 540, 430);
  chanwin->sinput = gtk_entry_new();
  vpaned = gtk_vpaned_new();
  gtk_paned_gutter_size(GTK_PANED(vpaned), 5);
  gtk_widget_show(vpaned);
  gtk_container_add(GTK_CONTAINER(chanwin->chanwin), vpaned);
  gtk_signal_connect(GTK_OBJECT(chanwin->chanwin),
                     "event",
                     GTK_SIGNAL_FUNC(chanwin_raw_cb),
                     NULL);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_paned_add1(GTK_PANED(vpaned), vbox);

  file_menu_cb_data = g_malloc0(sizeof(Menu_info) * MAX_FILE_ITEMS);
  for (i = 0; i < MAX_FILE_ITEMS; i++)
  {
    file_menu_cb_data[i].data = DATA[i];
    file_menu_cb_data[i].w = win - winstruct;
  }
  gtk_object_set_data(GTK_OBJECT(chanwin->chanwin),
                      "file_menu_data", file_menu_cb_data);
  ifactory= win_pup_setup(win, chanwin, file_menu_cb_data);
  
  i = win - winstruct;
  
  toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_hide(toolbar);
  chanwin->info = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanwin_cb), (gpointer) 5);
  gtk_widget_hide(wid);

  tmp_toolbar_icon = NULL;//create_pixmap_from_data(chanwin->chanwin, away2_xpm);*/
  chanwin->away = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanwin_cb), (gpointer) 6);
  gtk_widget_hide(wid);

  //tmp_toolbar_icon = create_pixmap_from_data(chanwin->chanwin, disconnect2_xpm);
  chanwin->close_con = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_object_set_data(GTK_OBJECT(wid), "connecting", 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanwin_cb), (gpointer) 7);
  gtk_widget_hide(wid);

  {

    char *titles[] = {"Nickname", "Mode", "Address", "IRC Name"};

    hpaned = gtk_hpaned_new();
    gtk_widget_show(hpaned);
    gtk_box_pack_start(GTK_BOX(vbox), hpaned, TRUE, TRUE, 0);

    scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_show(scrolledwindow);
    gtk_paned_add1(GTK_PANED(hpaned), scrolledwindow);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    chanwin->browser = wid = gtk_text_new(NULL, NULL);
    gtk_text_set_word_wrap(GTK_TEXT(wid), TRUE);
    gtk_widget_set_usize(wid, 520, 250);
    gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
    gtk_object_set_data(GTK_OBJECT(wid), "sw", scrolledwindow);
    gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
    gtk_widget_show(wid);
    gtk_signal_connect(GTK_OBJECT(wid),
                       "event",    //"button_press_event",
                        GTK_SIGNAL_FUNC(browser_raw_cb),
                       (gpointer) ifactory);
    gtk_signal_connect_object(GTK_OBJECT(wid),
                              "button_release_event",
                              GTK_SIGNAL_FUNC(set_entry_focus),
                              GTK_OBJECT(chanwin->sinput));

    wid =
       scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_show(scrolledwindow);
    gtk_paned_add2(GTK_PANED(hpaned), scrolledwindow);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
                                   (scrolledwindow),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    vbox2 = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox2);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW
                                          (scrolledwindow), vbox2);
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(hbox);
    gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, FALSE, 0);

    chanwin->chanusers.channel = wid = gtk_combo_new();
    gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(wid)->entry), FALSE);
    gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
    gtk_widget_hide(wid);       /*todo:hide if not on any channels */
    gtk_signal_connect_object(GTK_OBJECT(wid),
                              "button_release_event",
                              GTK_SIGNAL_FUNC(set_entry_focus),
                              GTK_OBJECT(chanwin->sinput));
    /*gtk_signal_connect(GTK_OBJECT(GTK_COMBO(wid)->entry), "activate",
                       GTK_SIGNAL_FUNC(chanusers_cb),
                       (gpointer) 0); */
    chanwin->chanusers.ok = wid = gtk_button_new_with_label("ok");
    gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
    gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(wid), 2);
    gtk_widget_set_usize(wid, 30, -2);
    gtk_tooltips_set_tip(tooltips, wid, "display user list", 0);
    gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                       GTK_SIGNAL_FUNC(chanusers_cb),
                       (gpointer) 0);
    gtk_widget_hide(wid);

    chanwin->chanusers.update = wid = gtk_button_new_with_label("Update");
    gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
    gtk_container_border_width(GTK_CONTAINER(wid), 2);
    gtk_tooltips_set_tip(tooltips, wid, "force update from server", NULL);
    gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                       GTK_SIGNAL_FUNC(chanusers_cb),
                       (gpointer) 1);
    gtk_widget_hide(wid);

    scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_show(scrolledwindow);
    gtk_box_pack_start(GTK_BOX(vbox2), scrolledwindow, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    chanwin->chanusers.clist = wid = gtk_clist_new_with_titles(4, titles);
    gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
    gtk_clist_set_selection_mode(GTK_CLIST(wid), GTK_SELECTION_MULTIPLE);
    gtk_clist_set_column_width(GTK_CLIST(wid), 2, 140);
    gtk_clist_set_column_width(GTK_CLIST(wid), 3, 140);
    gtk_widget_show(wid);
    gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
    gtk_clist_column_titles_show(GTK_CLIST(wid));
    gtk_signal_connect(GTK_OBJECT(wid),
                       "button_press_event",
                       GTK_SIGNAL_FUNC(clist_raw_cb),
                       NULL);
    gtk_signal_connect_object(GTK_OBJECT(wid),
                              "button_release_event",
                              GTK_SIGNAL_FUNC(set_entry_focus),
                              GTK_OBJECT(chanwin->sinput));

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(hbox);
    gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, FALSE, 3);

    frame = gtk_frame_new(NULL);
    gtk_widget_show(frame);
    gtk_container_border_width(GTK_CONTAINER(frame), 2);
    gtk_box_pack_start(GTK_BOX(hbox), frame, FALSE, FALSE, 0);

    hbox2 = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(hbox2);
    gtk_container_add(GTK_CONTAINER(frame), hbox2);

    chanwin->chanusers.go = wid = gtk_button_new_with_label("Go!");
    gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
    gtk_tooltips_set_tip(tooltips, wid, "perform selected op -->", NULL);
    gtk_widget_show(wid);
    gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                       GTK_SIGNAL_FUNC(chanusers_cb),
                       (gpointer) 2);
    chanwin->chanusers.kick = wid = gtk_check_button_new_with_label("kick");
    gtk_object_set_data(GTK_OBJECT(chanwin->chanwin), "kick", wid);
    gtk_tooltips_set_tip(tooltips, wid, "kick selected persons", NULL);
    gtk_widget_show(wid);
    gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
    gtk_signal_connect_object(GTK_OBJECT(wid),
                              "button_release_event",
                              GTK_SIGNAL_FUNC(set_entry_focus),
                              GTK_OBJECT(chanwin->sinput));

    chanwin->chanusers.ban = wid = gtk_check_button_new_with_label("ban");
    gtk_object_set_data(GTK_OBJECT(chanwin->chanwin), "ban", wid);
    gtk_tooltips_set_tip(tooltips, wid, "ban selected names", NULL);
    gtk_widget_show(wid);
    gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
    gtk_signal_connect_object(GTK_OBJECT(wid),
                              "button_release_event",
                              GTK_SIGNAL_FUNC(set_entry_focus),
                              GTK_OBJECT(chanwin->sinput));

    chanwin->chanusers.ignore = wid = gtk_check_button_new_with_label("ignore");
    gtk_object_set_data(GTK_OBJECT(chanwin->chanwin), "ignore", wid);
    gtk_tooltips_set_tip(tooltips, wid, "ignore selected names", NULL);
    gtk_widget_show(wid);
    gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
    gtk_signal_connect_object(GTK_OBJECT(wid),
                              "button_release_event",
                              GTK_SIGNAL_FUNC(set_entry_focus),
                              GTK_OBJECT(chanwin->sinput));

    wid = gtk_button_new_with_label("add routine");
    gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
    gtk_container_border_width(GTK_CONTAINER(wid), 2);
    gtk_tooltips_set_tip(tooltips, wid, "bind proc to popup", NULL);
    gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
    gtk_widget_show(wid);
    gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                       GTK_SIGNAL_FUNC(chanusers_cb),
                       (gpointer) 3);
  }

  table = gtk_table_new(3, 2, FALSE);
  gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, TRUE, 0);
  gtk_table_set_row_spacings(GTK_TABLE(table), 1);
  gtk_widget_show(table);

  /* clock and status bar 
     note: no style defined. Use rc file */
  status_button = gtk_event_box_new();
  gtk_object_set_data(GTK_OBJECT(chanwin->chanwin), "status", status_button);
  gtk_table_attach(GTK_TABLE(table), status_button, 0, 1, 0, 1,
                   (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
                   (GtkAttachOptions) 0, 2, 0);
  gtk_widget_show(status_button);
  status_hbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(status_button), status_hbox);
  gtk_widget_show(status_hbox);
  chanwin->clock = wid = gtk_label_new("");
  gtk_misc_set_padding(GTK_MISC(wid), 2, 0);
  gtk_box_pack_start(GTK_BOX(status_hbox), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);
  chanwin->status = wid = gtk_label_new("");
  gtk_label_set_justify(GTK_LABEL(wid), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(status_hbox), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);

  status_hbox = gtk_hbox_new(FALSE, 0);
  gtk_table_attach(GTK_TABLE(table), status_hbox, 0, 1, 1, 2,
                   (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
                   (GtkAttachOptions) 0, 2, 0);
  gtk_widget_show(status_hbox);

  /* lag display */
  status_button = gtk_button_new();
  gtk_box_pack_start(GTK_BOX(status_hbox), status_button, FALSE, FALSE, 0);
  gtk_object_set_user_data(GTK_OBJECT(status_button), (gpointer) i);
  gtk_object_set_data(GTK_OBJECT(chanwin->chanwin), "lag button", status_button);
  gtk_signal_connect(GTK_OBJECT(status_button), "clicked",
                     GTK_SIGNAL_FUNC(chanwin_cb),
                     (gpointer) 11);
  gtk_tooltips_set_tip(tooltips, status_button,
                       "force lag update", NULL);

  lag_style = gtk_style_copy(GTK_WIDGET(chanwin->chanwin)->style);
  gdk_font_unref(lag_style->font);
  lag_style->font = gdk_font_load("-*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*");
  lag_style->fg[GTK_STATE_NORMAL] = SPX_CYAN();
  lag_style->fg[GTK_STATE_PRELIGHT] = SPX_CYAN();
  lag_style->fg[GTK_STATE_ACTIVE] = SPX_CYAN();
  lag_style->bg[GTK_STATE_NORMAL] = SPX_BLACK();
  lag_style->bg[GTK_STATE_PRELIGHT] = lag_style->bg[GTK_STATE_NORMAL];
  lag_style->bg[GTK_STATE_ACTIVE].red =
     lag_style->bg[GTK_STATE_ACTIVE].green =
     lag_style->bg[GTK_STATE_ACTIVE].blue = 20000;
  gtk_widget_set_style(status_button, lag_style);
  chanwin->lag_button = status_button;

  chanwin->lag = wid = gtk_label_new("L000000s");
  gtk_widget_set_style(wid, lag_style);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(status_button), wid);
  gtk_widget_show(status_button);

  /* message bar
     note:rc file not used for  style */
  style = gtk_style_copy(GTK_WIDGET(chanwin->chanwin)->style);
  style->fg[GTK_STATE_NORMAL] = SPX_WHITE();
  style->bg[GTK_STATE_NORMAL] = SPX_BLACK();
  font = gdk_font_load("-*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*");
  if (font)
  {
    gdk_font_unref(style->font);
    style->font = font;
  }

  status_button = gtk_event_box_new();
  gtk_box_pack_start(GTK_BOX(status_hbox), status_button, TRUE, TRUE, 0);
  gtk_widget_set_style(status_button, style);
  gtk_widget_show(status_button);

  chanwin->WinStatusLine = wid = gtk_label_new(sula_DESCR);
  gtk_container_add(GTK_CONTAINER(status_button), wid);
  gtk_widget_set_style(wid, style);
  gtk_widget_show(wid);

  chanwin->cmd_fwd = wid = gtk_button_new();
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_object_set_data(GTK_OBJECT(wid), "H", histCur);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanwin_cb),
                     (gpointer) 30);
  gtk_widget_hide(wid);

  chanwin->cmd_bwd = wid = gtk_button_new();
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanwin_cb),
                     (gpointer) 31);
  gtk_widget_hide(wid);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_table_attach(GTK_TABLE(table), hbox, 2, 3, 0, 1,
                   (GtkAttachOptions) 0,
                   (GtkAttachOptions) 0, 2, 0);
  //gtk_widget_set_usize (arrow_vbox, 28, 20);
  gtk_widget_show(hbox);

  chanwin->chan_right = wid = gtk_button_new();
  gtk_widget_set_usize(wid, 15, -1);
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanwin_cb),
                     (gpointer) 33);

  arrow = gtk_arrow_new(GTK_ARROW_UP, GTK_SHADOW_IN);
  gtk_container_add(GTK_CONTAINER(wid), arrow);
  gtk_widget_show(arrow);

  chanwin->chan_left = wid = gtk_button_new();
  gtk_widget_set_usize(wid, 15, -1);
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanwin_cb),
                     (gpointer) 34);

  arrow = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_IN);
  gtk_container_add(GTK_CONTAINER(wid), arrow);
  gtk_widget_show(arrow);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_table_attach(GTK_TABLE(table), hbox, 2, 3, 1, 2,
                   (GtkAttachOptions) 0,
                   (GtkAttachOptions) 0, 2, 0);
  gtk_widget_show(hbox);

  chanwin->lead = wid = gtk_check_button_new();
  gtk_widget_set_usize(wid, 20, -1);
  gtk_tooltips_set_tip(tooltips, wid, "server lead window", NULL);
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "toggled",
                     GTK_SIGNAL_FUNC(chanwin_cb),
                     (gpointer) 8);
  gtk_widget_show(wid);

  frame = gtk_frame_new(NULL);
  gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, TRUE, 0);
  gtk_widget_set_usize(frame, -2, 60);
  gtk_widget_show(frame);

  vbox3 = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox3);
  gtk_container_add(GTK_CONTAINER(frame), vbox3);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox3), hbox, FALSE, TRUE, 0);

  gtk_object_set_user_data(GTK_OBJECT(chanwin->sinput), (gpointer) i);
  gtk_box_pack_start(GTK_BOX(hbox), chanwin->sinput, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(chanwin->sinput), "activate",
                     GTK_SIGNAL_FUNC(chanwin_cb),
                     (gpointer) 0);
  gtk_widget_show(chanwin->sinput);
  gtk_widget_grab_focus(chanwin->sinput);

  chanwin->history = wid = gtk_check_button_new_with_label("Log");
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_tooltips_set_tip(tooltips, wid, sflags & LOG ? "suspend logging" :
                       "resume logging", NULL);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "toggled",
                     GTK_SIGNAL_FUNC(chanwin_cb),
                     (gpointer) 14);
  gtk_widget_show(wid);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox3), hbox, FALSE, TRUE, 0);

  frame2 = gtk_frame_new(NULL);
  gtk_widget_show(frame2);
  gtk_box_pack_start(GTK_BOX(hbox), frame2, TRUE, TRUE, 0);

  hbox2 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox2);
  gtk_container_add(GTK_CONTAINER(frame2), hbox2);

  wid = create_pixmap_from_data(chanwin->chanwin, spx2_mini_xpm);
  gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);

#if _GUILE
  wid = gtk_radio_button_new_with_label(NULL, "Parse F1");
  gtk_tooltips_set_tip(tooltips, wid, "parse input", NULL);
#else
  wid = gtk_radio_button_new_with_label(NULL, "Quote F1");
  gtk_tooltips_set_tip(tooltips, wid, "quote input to server", NULL);
#endif
  radio_group = gtk_radio_button_group(GTK_RADIO_BUTTON(wid));
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);

  gtk_signal_connect(GTK_OBJECT(wid), "toggled",
                     GTK_SIGNAL_FUNC(radio_cb),
                     (gpointer) 0);
  gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);
  chanwin->r_quote = wid;

  chanwin->r_query = wid = gtk_radio_button_new_with_label(radio_group, "Query F2");
  gtk_tooltips_set_tip(tooltips, wid, "input to query", NULL);
  radio_group = gtk_radio_button_group(GTK_RADIO_BUTTON(wid));
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_signal_connect(GTK_OBJECT(wid), "toggled",
                     GTK_SIGNAL_FUNC(radio_cb),
                     (gpointer) 1);
  gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);

  chanwin->r_channel = wid = gtk_radio_button_new_with_label(radio_group, "Channel F3");
  radio_group = gtk_radio_button_group(GTK_RADIO_BUTTON(wid));
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_tooltips_set_tip(tooltips, wid, "send input to current channel", NULL);
  gtk_signal_connect(GTK_OBJECT(wid), "toggled",
                     GTK_SIGNAL_FUNC(radio_cb),
                     (gpointer) 2);
  gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);

  wid = gtk_radio_button_new_with_label(radio_group, "DCC F4");
  radio_group = gtk_radio_button_group(GTK_RADIO_BUTTON(wid));
  gtk_object_set_data(GTK_OBJECT(chanwin->chanwin), "dcc", wid);
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_tooltips_set_tip(tooltips, wid, "input goes to DCC", NULL);
  gtk_signal_connect(GTK_OBJECT(wid), "toggled",
                     GTK_SIGNAL_FUNC(radio_cb),
                     (gpointer) 3);
  gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);
  chanwin->r_dcc_chat = wid;

  chanwin->r_echo = wid = gtk_radio_button_new_with_label(radio_group, "Echo F5");
  radio_group = gtk_radio_button_group(GTK_RADIO_BUTTON(wid));
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_tooltips_set_tip(tooltips, wid, "echo input", NULL);
  gtk_signal_connect(GTK_OBJECT(wid), "toggled",
                     GTK_SIGNAL_FUNC(radio_cb),
                     (gpointer) 4);
  gtk_box_pack_start(GTK_BOX(hbox2), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);
  
  

  hbox2 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox2);
  gtk_box_pack_start(GTK_BOX(hbox), hbox2, FALSE, TRUE, 0);
  gtk_widget_set_usize(hbox2, 120, -2);

  frame2 = gtk_frame_new(NULL);
  gtk_widget_show(frame2);
  gtk_box_pack_start(GTK_BOX(hbox2), frame2, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox3);
  gtk_container_add(GTK_CONTAINER(frame2), hbox3);

  chanwin->type = wid = gtk_check_button_new();
  gtk_tooltips_set_tip(tooltips, wid, "use default msg type", NULL);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);
  gtk_signal_connect_object(GTK_OBJECT(wid),
                            "button_release_event",
                            GTK_SIGNAL_FUNC(set_entry_focus),
                            GTK_OBJECT(chanwin->sinput));

  wid_menu = gtk_menu_new();
  wid = gtk_menu_item_new_with_label("notice");
  gtk_object_set_data(GTK_OBJECT(wid), "cmd", "1");
  gtk_widget_show(wid);
  gtk_menu_append(GTK_MENU(wid_menu), wid);
  wid = gtk_menu_item_new_with_label("action");
  gtk_object_set_data(GTK_OBJECT(wid), "cmd", "2");
  gtk_widget_show(wid);
  gtk_menu_append(GTK_MENU(wid_menu), wid);
  wid = gtk_menu_item_new_with_label("msg");
  gtk_object_set_data(GTK_OBJECT(wid), "cmd", "3");
  gtk_widget_show(wid);
  gtk_menu_append(GTK_MENU(wid_menu), wid);

  chanwin->action = wid = gtk_option_menu_new();
  gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer) i);
  gtk_tooltips_set_tip(tooltips, wid, "default msg type", NULL);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, FALSE, 0);
  gtk_widget_set_usize(wid, 90, -2);
  gtk_option_menu_set_menu(GTK_OPTION_MENU(wid), wid_menu);
  gtk_widget_show(wid);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_paned_add2(GTK_PANED(vpaned), scrolledwindow);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
  gtk_widget_show(scrolledwindow);

  chanwin->brow2 = wid = gtk_text_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
  gtk_text_set_word_wrap(GTK_TEXT(wid), TRUE);
  gtk_widget_show(wid);
  gtk_signal_connect_object(GTK_OBJECT(wid),
                            "button_release_event",
                            GTK_SIGNAL_FUNC(set_entry_focus),
                            GTK_OBJECT(chanwin->sinput));
  //gtk_widget_set_name(wid, "brow2");

  return chanwin;
}

static void add_pup_cb(GtkWidget * button, GtkWidget * pup)
{
  GtkWidget *wid;
  char *name,
      *cmd;

  wid = gtk_object_get_data(GTK_OBJECT(pup), "name");
  name = gtk_entry_get_text(GTK_ENTRY(wid));
  if (isspace(*name))
    UNSPACE(name);
  if (*name == 0)
  {
    spx_bell(0);
    return;
  }
  wid = gtk_object_get_data(GTK_OBJECT(pup), "command");
  cmd = gtk_entry_get_text(GTK_ENTRY(wid));
  if (isspace(*cmd))
    UNSPACE(cmd);
  if (*cmd == 0)
  {
    spx_bell(0);
    return;
  }
  wid = gtk_object_get_data(GTK_OBJECT(pup), "checkbutton");
  add_users_pup(&pup_cmd, name, cmd,
                BUTTON_IS_ON(wid) ? PUP_CMD_SCM : PUP_CMD_IN);
  gtk_widget_destroy(pup);
}

GtkWidget *
   create_new_pup(void)
{
  GtkWidget *new_pup;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *hbuttonbox;
  GtkWidget *wid;

  new_pup = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(new_pup), sula_NAME ": New pup item");
  gtk_window_set_policy(GTK_WINDOW(new_pup), TRUE, TRUE, FALSE);
  gtk_widget_set_name(new_pup, "dialog new popup");
  gtk_window_position(GTK_WINDOW(new_pup), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy(GTK_WINDOW(new_pup), FALSE, TRUE, FALSE);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(new_pup)->vbox),
                     vbox, TRUE, TRUE, 0);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(hbox), 2);

  wid = gtk_label_new("Label:");
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);

  wid = gtk_entry_new();
  gtk_object_set_data(GTK_OBJECT(new_pup), "name", wid);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox), wid, TRUE, TRUE, 0);

  wid = gtk_check_button_new_with_label("script");
  gtk_object_set_data(GTK_OBJECT(new_pup), "checkbutton", wid);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);
  gtk_tooltips_set_tip(tooltips, wid, "command is the name"
                       " of a scheme procedure", NULL);
#if !_GUILE
  SET_BUTTON(wid, 0);
  gtk_widget_set_sensitive(wid, FALSE);
#endif

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(hbox), 1);

  wid = gtk_label_new("Command:");
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_label_set_justify(GTK_LABEL(wid), GTK_JUSTIFY_LEFT);

  wid = gtk_entry_new();
  gtk_object_set_data(GTK_OBJECT(new_pup), "command", wid);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox), wid, TRUE, TRUE, 0);
  gtk_tooltips_set_tip(tooltips, wid,
                       "either the name of a procedure,"
                       " or a valid user command input", 0);

  gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(new_pup)->action_area), 2);

  hbuttonbox = gtk_hbutton_box_new();
  gtk_widget_show(hbuttonbox);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(new_pup)->action_area), hbuttonbox, TRUE, TRUE, 0);

  wid = gtk_button_new_with_label("OK");
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(add_pup_cb),
                     new_pup);
  gtk_widget_show(wid);
  GTK_WIDGET_SET_FLAGS(wid, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(wid);

  wid = gtk_button_new_with_label("Cancel");
  gtk_signal_connect_object(GTK_OBJECT(wid), "clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(new_pup));
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);

  return new_pup;
}

static void reset_pup_list(GtkWidget * w, gpointer junk)
{
  gtk_widget_destroy(user_popup_list);
  user_popup_list = NULL;
}

GtkWidget *create_user_popup_list(void)
{

  GtkWidget *clist;
  GtkWidget *wid;
  GtkWidget *box;
  char *titles[] = {"Label", "Command/Procedure", "Type"};

  if (user_popup_list)
    return NULL;
  user_popup_list = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(user_popup_list), sula_NAME ": Chanuser pup");
  gtk_window_set_policy(GTK_WINDOW(user_popup_list), TRUE, TRUE, FALSE);
  gtk_widget_set_name(user_popup_list, "popup listing");
  gtk_widget_set_usize(user_popup_list, 400, 250);
  gtk_signal_connect(GTK_OBJECT(user_popup_list), "destroy",
                     GTK_SIGNAL_FUNC(reset_pup_list),
                     NULL);
  gtk_window_position(GTK_WINDOW(user_popup_list), GTK_WIN_POS_MOUSE);

  box = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(box);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
                                 (box),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(user_popup_list)->vbox),
                     box, TRUE, TRUE, 0);

  clist = gtk_clist_new_with_titles(3, titles);
  gtk_container_add(GTK_CONTAINER(box), clist);
  gtk_object_set_data(GTK_OBJECT(user_popup_list), "clist", clist);
  gtk_widget_show(clist);
  gtk_container_border_width(GTK_CONTAINER(clist), 2);
  gtk_clist_set_column_width(GTK_CLIST(clist), 0, 80);
  gtk_clist_set_column_width(GTK_CLIST(clist), 1, 240);
  gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_MULTIPLE);
  gtk_clist_column_titles_show(GTK_CLIST(clist));

  gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(user_popup_list)->action_area), 3);
  box = gtk_hbox_new(TRUE, 5);
  gtk_widget_show(box);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(user_popup_list)->action_area),
                     box, TRUE, FALSE, 2);

  wid = gtk_button_new_with_label("New");
  gtk_box_pack_start(GTK_BOX(box), wid, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanuser_puplist_cb),
                     (gpointer) 0);
  gtk_widget_show(wid);
  gtk_tooltips_set_tip(tooltips, wid, "create new item", 0);

  wid = gtk_button_new_with_label("Edit");
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(box), wid, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanuser_puplist_cb),
                     (gpointer) 1);
  gtk_tooltips_set_tip(tooltips, wid, "edit selected entry", 0);

  wid = gtk_button_new_with_label("Delete");
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(box), wid, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanuser_puplist_cb),
                     (gpointer) 2);
  gtk_tooltips_set_tip(tooltips, wid, "remove selected items", 0);

  wid = gtk_button_new_with_label("Save");
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(box), wid, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(chanuser_puplist_cb),
                     (gpointer) 3);
  gtk_tooltips_set_tip(tooltips, wid,
                       "create a script for current pup items", 0);

  wid = gtk_button_new_with_label("Dismiss");
  gtk_tooltips_set_tip(tooltips, wid, "hide this window", 0);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(box), wid, TRUE, TRUE, 0);
  gtk_signal_connect_object(GTK_OBJECT(wid), "clicked",
             GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(user_popup_list));

  return user_popup_list;
}

