/*
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix)
*/
#include "spx.h"
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui_gtk.h"
#include "userpup.h"
#include "etc.h"
#include "cmd.h"
#if 0
#include "skriptx.h"
#else
extern long sx_submit_data;
#endif
#include "ignore.h"

#define reset_focus(__w) gtk_widget_grab_focus((__w)->chanwin->sinput)
extern GtkWidget *create_about(void);
extern GtkWidget *create_userguide(void);
extern GtkWidget *create_ignore(void);

/*int pup_window = -1;*/
extern int set_bg_pixamp(GtkWidget * wid, const char *pix);
extern int set_text_colour(GtkWidget * wid, const char *, int bg);
extern void confirm2(const char *, const char *, int tmout,
                     void (*)(int, void *), void *);

void chanwin_pup_cb(gpointer data, guint action, GtkWidget * widget)
{
/* callback for /Part menu items */
  if (action == 101)
  {
    char *path = gtk_item_factory_path_from_widget(widget);
    char *chan = strrchr(path, '/');
    char *buf;

    chan++;
    buf = malloc(sizeof(char) * (strlen(chan) + 8));

    sprintf(buf, "/part %s", chan);
    new_process_cmd(buf, sx_submit_data);
    free(buf);
  }
}
#if _GUILE

static SCM set_font(GtkWidget * wid, char *fontname)
{
  GtkStyle *style;
  GdkFont *font;

  font = gdk_font_load(fontname);
  free(fontname);
  if (!font)
    return SCM_BOOL_F;
  style = gtk_style_copy(wid->style);
  gdk_font_unref(style->font);
  style->font = font;
  gtk_widget_set_style(wid, style);
  return SCM_BOOL_T;
}
static SCM set_pixmap(GtkWidget * wid, char *pix)
{
  int n = set_bg_pixamp(wid, pix);

  free(pix);
  return n ? SCM_BOOL_F : SCM_BOOL_T;
}
SCM gs_set_status_bg_pixmap(SCM fname, SCM win)
{
/*
   (gs-set-status-bg-pixmap "foo.xpm" -1|0)
 */
  int n;
  char *pix;
  GtkWidget *wid = NULL;
  int w;

  pix = gh_scm2newstr(fname, &n);
  if (n == 0)
    pix = NULL;
  w = (int) gh_scm2long(win);
  if (win_invalid(w))
    return SCM_BOOL_F;
  wid = gtk_object_get_data(GTK_OBJECT(winstruct[w].chanwin->chanwin),
                            "status");
  return set_pixmap(wid, pix);
}

SCM gs_set_window_bg_pixmap(SCM fname, SCM win, SCM args)
{
/*
   (gs-set-bg-pixmap "foo.xpm" -1|0 1)
 */
  int n;
  char *pix;
  GtkWidget *wid = NULL;
  int w;

  pix = gh_scm2newstr(fname, &n);
  if (n == 0)
    pix = NULL;
  w = (int) gh_scm2long(win);
  if (w == -1)
    wid = main_window->browser;
  else if (win_invalid(w))
    return SCM_BOOL_F;
  else
  {
    int which = 0;

    if (!gh_null_p(args))
      which = gh_scm2int(gh_car(args));
    wid = which ? winstruct[w].chanwin->brow2 : winstruct[w].chanwin->browser;
  }
  return set_pixmap(wid, pix);
}

static int name2colour(SCM name, GdkColor * c)
{
  int n;
  char *colname;

  colname = gh_scm2newstr(name, &n);
  if (n == 0)
    return -1;

  if (!gdk_color_parse(colname, c))
    return -1;
  free(colname);
  return 0;
}
static SCM set_colour(GtkWidget * wid, SCM name, int bg)
{
  int n;
  char *colname;

  colname = gh_scm2newstr(name, &n);
  if (n == 0)
    return SCM_BOOL_F;
  n = set_text_colour(wid, colname, bg);
  free(colname);
  return n ? SCM_BOOL_F : SCM_BOOL_T;
}

static SCM set_window_colour(SCM name, SCM win, SCM args, int bg)
{
  int w;
  GtkWidget *wid;

  w = (int) gh_scm2long(win);
  if (w == -1)
    wid = main_window->browser;
  else if (win_invalid(w))
    return SCM_BOOL_F;
  else
  {
    int which = 0;

    if (!gh_null_p(args))
      which = gh_scm2int(gh_car(args));
    wid = which ? winstruct[w].chanwin->brow2 : winstruct[w].chanwin->browser;
  }
  return set_colour(wid, name, bg);
}
/*++++++++++++++bg, fg colours ++++++++++++++++++++++++++++ */
SCM gs_set_window_bg_colour(SCM name, SCM win, SCM args)
{
  return set_window_colour(name, win, args, 1);
}
SCM gs_set_window_fg_colour(SCM name, SCM win, SCM args)
{
  return set_window_colour(name, win, args, 0);
}

static SCM set_input_colour(SCM name, SCM win, int bg)
{
  int w;
  GtkWidget *wid;
  GdkColor col;
  GtkStyle *style;

  if (name2colour(name, &col))
    return SCM_BOOL_F;
  w = (int) gh_scm2long(win);
  if (w == -1)
    wid = main_window->main_input;
  else if (win_invalid(w))
    return SCM_BOOL_F;
  else
    wid = winstruct[w].chanwin->sinput;
  style = gtk_style_copy(wid->style);
  if (bg)
    style->base[GTK_STATE_NORMAL] = col;
  else
    style->fg[GTK_STATE_NORMAL] = col;
  gtk_widget_set_style(wid, style);
  return SCM_BOOL_T;
}

SCM gs_set_input_bg_colour(SCM name, SCM win)
{
  return set_input_colour(name, win, 1);
}
SCM gs_set_input_fg_colour(SCM name, SCM win)
{
  return set_input_colour(name, win, 0);
}
static SCM set_status_colour(SCM name, SCM win, int bg)
{
  int w;
  GtkWidget *wid;
  GdkColor col;
  GtkStyle *style;

  w = (int) gh_scm2long(win);
  if (win_invalid(w))
    return SCM_BOOL_F;
  if (name2colour(name, &col))
    return SCM_BOOL_F;
  if (bg)
  {
    wid = gtk_object_get_data(GTK_OBJECT(winstruct[w].chanwin->chanwin),
                              "status");
    style = gtk_style_copy(wid->style);
    style->bg[GTK_STATE_NORMAL] = col;
    gtk_widget_set_style(wid, style);
  }
  else
  {
    wid = winstruct[w].chanwin->status;
    style = gtk_style_copy(wid->style);
    style->fg[GTK_STATE_NORMAL] = col;
    gtk_widget_set_style(wid, style);
    wid = winstruct[w].chanwin->clock;
    style = gtk_style_copy(wid->style);
    style->fg[GTK_STATE_NORMAL] = col;
    gtk_widget_set_style(wid, style);
  }
  return SCM_BOOL_T;
}
SCM gs_set_status_bg_colour(SCM name, SCM win)
{
  return set_status_colour(name, win, 1);
}
SCM gs_set_status_fg_colour(SCM name, SCM win)
{
  return set_status_colour(name, win, 0);
}

/*++++++++++++++++++++fonts++++++++++++++++++++++++++++++ */
SCM gs_set_window_text_font(SCM fname, SCM win, SCM args)
{
/*
   (gs-set-text-font "-*-new-*12..." -1|0 1)
 */
  int n;
  char *font;
  GtkWidget *wid = NULL;
  int w;

  font = gh_scm2newstr(fname, &n);
  if (n == 0)
    return SCM_BOOL_F;
  w = (int) gh_scm2long(win);
  if (w == -1)
    wid = main_window->browser;
  else if (win_invalid(w))
    return SCM_BOOL_F;
  else
  {
    int which = 0;

    if (!gh_null_p(args))
      which = gh_scm2int(gh_car(args));
    wid = which ? winstruct[w].chanwin->brow2 : winstruct[w].chanwin->browser;
  }
  return set_font(wid, font);
}
SCM gs_set_console_clock_font(SCM fname)
{
  char *font;
  int w;

  font = gh_scm2newstr(fname, &w);
  if (w == 0)
    return SCM_BOOL_F;
  return set_font(main_window->clock, font);
}
static SCM set_cclock_colour(SCM col_spec, int bg)
{
  GdkColor col;
  GtkStyle *style;

  if (name2colour(col_spec, &col))
    return SCM_BOOL_F;
  if (bg)
  {
    GtkWidget *wid = gtk_object_get_data(GTK_OBJECT(main_window->main_window),
                                         "cl");

    style = gtk_style_copy(wid->style);
    style->bg[GTK_STATE_NORMAL] = col;
    gtk_widget_set_style(wid, style);
  }
  else
  {
    style = gtk_style_copy(main_window->clock->style);
    style->fg[GTK_STATE_NORMAL] = col;
    gtk_widget_set_style(main_window->clock, style);
  }
  return SCM_BOOL_T;
}
SCM gs_set_console_clock_fg_colour(SCM col_spec)
{
  return set_cclock_colour(col_spec, 0);
}
SCM gs_set_console_clock_bg_colour(SCM col_spec)
{
  return set_cclock_colour(col_spec, 1);
}

SCM gs_set_input_font(SCM fname, SCM win)
{
/*
   (gs-set-text-font "-*-new-*12..." -1|0)
 */
  char *font;
  GtkWidget *wid = NULL;
  int w;

  font = gh_scm2newstr(fname, &w);
  if (w == 0)
    return SCM_BOOL_F;
  w = (int) gh_scm2long(win);
  if (w == -1)
    wid = main_window->main_input;
  else if (win_invalid(w))
    return SCM_BOOL_F;
  else
    wid = winstruct[w].chanwin->sinput;
  return set_font(wid, font);
}
SCM gs_set_status_font(SCM fname, SCM win)
{
/*
   (gs-set-text-font "-*-new-*12..." -1|0)
 */
  char *fontname;
  GtkWidget *wid;
  int w;
  GtkStyle *style;
  GdkFont *font;

  fontname = gh_scm2newstr(fname, &w);
  if (w == 0)
    return SCM_BOOL_F;
  w = (int) gh_scm2long(win);
  if (win_invalid(w))
    return SCM_BOOL_F;
  font = gdk_font_load(fontname);
  free(fontname);
  if (!font)
    return SCM_BOOL_F;
  wid = winstruct[w].chanwin->status;
  style = gtk_style_copy(wid->style);
  gdk_font_unref(style->font);
  style->font = font;
  gtk_widget_set_style(wid, style);
  wid = winstruct[w].chanwin->clock;
  style = gtk_style_copy(wid->style);
  gdk_font_unref(style->font);
  style->font = font;
  gtk_widget_set_style(wid, style);
  return SCM_BOOL_T;
}
/////////////////////////////////////////////////////////////
#endif

void go_menu_cb(GtkWidget * w, gpointer data)
{
  Go_menu_info *mi = (Go_menu_info *) data;
  Go *p;

  assert(!win_invalid(mi->w));
  p = winstruct[mi->w].goStart;
  while (p != winstruct[mi->w].goEnd)
  {
    if (!strcasecmp(p->name, mi->s))
    {
      char *buf;

      buf = malloc(sizeof(char) * (strlen(p->name) +
                                   (p->key ? (strlen(p->key)) : 0) + 12));

      sprintf(buf, "/join %s %s", p->name, p->key ? p->key : "");
      new_process_cmd(buf, mi->w);
      free(buf);
      return;
    }
    p = p->next;
  }
}

gint chanwin_raw_cb(GtkWidget * widget, GdkEventKey * event, gpointer junk)
{
  switch (event->type)
  {
     case GDK_KEY_PRESS:
       {
         int w = (int) gtk_object_get_user_data(GTK_OBJECT(widget));

         /*Winstruct *win = */
#if _GUILE
         int res;

         res = key_preempted(event->keyval, event->state, w);
         if (res)
           return TRUE;
         else
#endif
           switch (event->keyval)
           {
              case GDK_Up:
                TRIGGER_OBJECT(winstruct[w].chanwin->cmd_fwd);
                return TRUE;
              case GDK_Down:
                TRIGGER_OBJECT(winstruct[w].chanwin->cmd_bwd);
                return TRUE;
              case GDK_Page_Down:
                {
                  GtkAdjustment *adj =
                     gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW
                                                         (gtk_object_get_data
                                                          (GTK_OBJECT
                                                           (winstruct[w].
                                                            chanwin->browser),
                                                           "sw")));

                  page_down(adj);
                }
                break;
              case GDK_Page_Up:
                {
                  GtkAdjustment *adj =
                     gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW
                                                         (gtk_object_get_data
                                                          (GTK_OBJECT
                                                           (winstruct[w].
                                                            chanwin->browser),
                                                           "sw")));

                  page_up(adj);
                }
                break;
              case GDK_F1:
                ACTIVATE_BUTTON(winstruct[w].chanwin->r_quote);
                return TRUE;
              case GDK_F2:
                ACTIVATE_BUTTON(winstruct[w].chanwin->r_query);
                return TRUE;
              case GDK_F3:
                ACTIVATE_BUTTON(winstruct[w].chanwin->r_channel);
                return TRUE;
              case GDK_F4:
                ACTIVATE_BUTTON(winstruct[w].chanwin->r_dcc_chat);
                return TRUE;
              case GDK_F5:
                ACTIVATE_BUTTON(winstruct[w].chanwin->r_echo);
                return TRUE;
              case GDK_c:
                if (event->state & ControlMask)
                {
                  TRIGGER_OBJECT(winstruct[w].chanwin->chan_right);
                  return TRUE;
                }
                break;
              case GDK_C:      //XK_C:

                if (event->state & ControlMask)
                {
                  TRIGGER_OBJECT(winstruct[w].chanwin->chan_left);
                  return TRUE;
                }
                break;
              default:
                return FALSE;
           }
       }
     default:
       break;
  }
  return FALSE;
}

void menu_cb(GtkWidget * w, gpointer data)
{
  switch ((long) data)
  {
     case 105:
        TRIGGER_OBJECT(main_window->quit);
        break;
     case 802:
       {
         GtkWidget *wid = create_ignore();

         if (wid)
         {
           gtk_widget_show(wid);
           TRIGGER_OBJECT(ignore_form->update);
         }
       }
       break;
     case 805:
       TRIGGER_OBJECT(main_window->servers);
       break;
     case 806:
       if (user_popup_list)
       {
         if (!GTK_WIDGET_VISIBLE(user_popup_list))
           gtk_widget_show_all(user_popup_list);
         else
           spx_bell(0);
         return;
       }
       else
       {

         user_popup_list = create_user_popup_list();
         if (user_popup_list)
         {
           update_pup_list(0);
           gtk_widget_show(user_popup_list);
         }
       }
       break;
     case 901:                 //help/about

       {
         GtkWidget *wid = create_about();

         if (wid)
           gtk_widget_show(wid);
       }
       break;
     case 902:                 //help/user guie

       {
         GtkWidget *wid = create_userguide();

         if (wid)
           gtk_widget_show(wid);
       }
       break;
     default:
       /*printf("data:%ld %p\n", (long) data, data); */
       break;
  }
}

void chanuser_puplist_cb(GtkWidget * button, gpointer data)
{
  switch ((long) data)
  {
     case 0:
       {
         GtkWidget *wid = create_new_pup();

         gtk_widget_show(wid);
         break;
       }
     case 1:
       {
         GtkCList *clist =
            GTK_CLIST(gtk_object_get_data

                      (GTK_OBJECT(user_popup_list), "clist"));

         if (clist->selection)
         {
           gint row = GPOINTER_TO_INT(clist->selection->data);
           GtkWidget *wid = create_new_pup();
           char *name, *cmd;
           int type = (int) gtk_clist_get_row_data(clist, row);
           GtkWidget *ww;

           gtk_clist_get_text(clist, row, 0, &name);
           gtk_clist_get_text(clist, row, 1, &cmd);
           ww = gtk_object_get_data(GTK_OBJECT(wid), "name");
           spx_set_input(ww, name);
           ww = gtk_object_get_data(GTK_OBJECT(wid), "command");
           spx_set_input(ww, cmd);
           ww = gtk_object_get_data(GTK_OBJECT(wid), "checkbutton");
           SET_BUTTON(ww, type & PUP_CMD_SCM);
           gtk_widget_show(wid);
         }
         break;
       }
     case 2:
       {
         GtkCList *clist =
            GTK_CLIST(gtk_object_get_data

                      (GTK_OBJECT(user_popup_list), "clist"));
         GList *p = clist->selection;
         gint row;
         char *name;

         while (p)
         {
           row = GPOINTER_TO_INT(p->data);
           gtk_clist_get_text(clist, row, 0, &name);
           remove_pup(name, 0);
           p = p->next;
         }
         if (clist->selection)
           update_pup_list(1);
       }
       break;
     case 3:
       get_filename2(sula_NAME " : Save pup list file", NULL, save_pups, 0);
       break;
     case 4:
       gtk_widget_hide(user_popup_list);
       break;
  }
}

void chanusers_pup_cb(GtkWidget * menuitem, gpointer junk)
{
  GtkCList *clist;

  assert(chanusers_pup_window);
  clist = GTK_CLIST(chanusers_pup_window->chanwin->chanusers.clist);

  if (!clist->selection)
  {
    if (gflags & BEEP_ERR)
      spx_bell(0);
    return;
  }
  else
  {

    GList *p = clist->selection;
    char *nick, *buf = 0;
    char *channel;
    int len;
    char *addr;
    gint row;
    char *cc = gtk_object_get_user_data(GTK_OBJECT(menuitem));
    Pup_cmd *cmd;

    assert(cc);
    cmd = find_pup(pup_cmd, cc);
    assert(cmd);
    channel =
       gtk_entry_get_text(GTK_ENTRY
                          (GTK_COMBO
                           (chanusers_pup_window->chanwin->chanusers.
                            channel)->entry));
    if (*channel == 0)
      return;
    len = strlen(channel) + strlen(cmd->cmd);
    while (p)
    {
      row = GPOINTER_TO_INT(p->data);
      gtk_clist_get_text(clist, row, 0, &nick);
      gtk_clist_get_text(clist, row, 2, &buf);
      addr = strdup(buf);
      if (*addr == '~')
        strshift(addr, 1);
#if _GUILE
      if (cmd->type & PUP_CMD_SCM)
      {
        buf = malloc(sizeof(char) * (len + strlen(nick) + strlen(addr) + 20));

        sprintf(buf, "(%s %d \"%s\" \"%s\" \"%s\")",
                cmd->cmd,
                chanusers_pup_window - winstruct, channel, nick, addr);
        (void) gh_eval_str_with_catch(buf, &exception_handler);
        free(buf);
      }
      else
#endif
      {
        char tmp[512];
        register char *ptr = &tmp[0];
        register char *c = cmd->cmd;
        register char *q;

        while ((*ptr = *c) && (ptr - &tmp[0] < 300))
        {
          if (*ptr == '$')
          {
            switch (*++c)
            {
                 /* dont use a copy'ing func (strcpy, ...). slow */
               case 'I':
                 q = spx_get_input(chanusers_pup_window->chanwin->sinput);
                 while ((*ptr = *q))
                 {
                   ptr++;
                   q++;
                 }
                 c++;
                 break;
               case 'N':
                 q = nick;
                 while ((*ptr = *q))
                 {
                   ptr++;
                   q++;
                 }
                 c++;
                 break;
               case 'C':
                 q = channel;
                 while ((*ptr = *q))
                 {
                   ptr++;
                   q++;
                 }
                 c++;
                 break;
               case 'U':
                 q = addr;
                 while ((*ptr = *q))
                 {
                   ptr++;
                   q++;
                 }
                 c++;
                 break;
               default:
                 ptr++;
                 break;
            }                   //swtich

          }
          else
          {
            ptr++;
            c++;
          }
        }
        *ptr = 0;
        process_cmd(tmp, chanusers_pup_window);
      }
      free(addr);
      p = p->next;
    }
  }
}

#if _GUILE

SCM gs_add_pup(SCM _title, SCM _proc, SCM flag)
{
  int n;
  char *title;
  char *cmd;
  int type;

  cmd = gh_scm2newstr(_proc, &n);
  if (n == 0)
    return SCM_BOOL_F;
  title = gh_scm2newstr(_title, &n);
  if (n == 0)
    title = nextword(cmd, 0);
  if (gh_null_p(flag))
    type = PUP_CMD_SCM;
  else
    type = PUP_CMD_IN;
  n = add_users_pup(&pup_cmd, title, cmd, type);
  free(cmd);
  free(title);
  return n ? SCM_BOOL_F : SCM_BOOL_T;
}
SCM gs_remove_pup(SCM _proc)
{
  int n;
  char *cmd;

  cmd = gh_scm2newstr(_proc, &n);
  if (n == 0)
    return SCM_BOOL_F;
  remove_pup(cmd, 1);
  free(cmd);
  return SCM_UNSPECIFIED;
}
SCM gs_clear_pup(void)
{
  clear_pups(pup_cmd);
  return SCM_UNSPECIFIED;
}
#endif

gint clist_raw_cb(GtkWidget * widget, GdkEventButton * event, gpointer junk)
{
  if (event->button == Button3)
  {
    chanusers_pup_window = WINSTRUCT(widget);
    gtk_menu_popup(GTK_MENU(chanusers_pup_menu),
                   NULL, NULL, NULL, NULL, event->button, event->time);
    return TRUE;
  }
  return FALSE;
}
gint browser_raw_cb(GtkWidget * widget, GdkEvent * event,
                    //GdkEventButton * event,
                    gpointer data)
{

  if (event->type == GDK_BUTTON_PRESS &&
      ((GdkEventButton *) event)->button == Button3)
  {
    GtkWidget *pup;

    sx_submit_data = iWINSTRUCT(widget);
    pup = gtk_item_factory_get_widget((GtkItemFactory *) data, "<main>");

    gtk_menu_popup(GTK_MENU(pup),
                   NULL, NULL, NULL, NULL,
                   ((GdkEventButton *) event)->button,
                   ((GdkEventButton *) event)->time);
    return TRUE;
  }
  return FALSE;
}

void chanusers_cb(GtkWidget * wid, gpointer data)
{
  Winstruct *win = WINSTRUCT(wid);

  switch ((long) data)
  {
     case 0:
       {
         char *channel =  gtk_entry_get_text(GTK_ENTRY 
                        (GTK_COMBO (win->chanwin->chanusers.channel)->entry));

         if (*channel)
           load_userlist(win, channel, 0);
       }
       break;
     case 1:
       {                        /* update */
         char *chan =
            gtk_entry_get_text(GTK_ENTRY
                               (GTK_COMBO (win->chanwin->chanusers.channel)->entry));

         if (*chan)
         {
           char *buf = malloc(sizeof(char) * (strlen(chan) + 16));

           sprintf(buf, "/WHO -update %s", chan);
           process_cmd(buf, win);
           free(buf);
         }
       }
       break;
     case 2:
       {
         GtkCList *clist = GTK_CLIST(win->chanwin->chanusers.clist);

         if (!clist->selection)
         {
           if (gflags & BEEP_ERR)
             spx_bell(0);
           break;
         }
         else
         {
           GList *p = clist->selection;
           char *buf = 0, *kick_reason = 0, *channel;

           size_t len = 0;
           int row;
           char flag = 0;

#define F_KICK_ (1<<0)
#define F_BAN_  (1<<1)
#define F_IGNORE_ (1<<2)

           channel =
              gtk_entry_get_text(GTK_ENTRY
                                 (GTK_COMBO (win->chanwin->chanusers.channel)->entry));
           if (*channel == 0)
             break;
           if (BUTTON_IS_ON(win->chanwin->chanusers.kick))
             flag |= F_KICK_;
           if (BUTTON_IS_ON(win->chanwin->chanusers.ban))
             flag |= F_BAN_;
           if (BUTTON_IS_ON(win->chanwin->chanusers.ignore))
             flag |= F_IGNORE_;
           if (flag & (F_BAN_ | F_KICK_))
           {
             kick_reason = spx_get_input(win->chanwin->sinput);
             if (*kick_reason == 0)
               kick_reason = sula_NAME " " sula_VERSION;
             len = strlen(kick_reason) + strlen(channel);
           }
           while (p)
           {
             char *nick, *addr = 0;

             row = GPOINTER_TO_INT(p->data);
             gtk_clist_get_text(clist, row, 0, &nick);
             if (flag & (F_BAN_ | F_IGNORE_))
             {
               gtk_clist_get_text(clist, row, 2, &buf);
               addr = strdup(buf);
               if (*addr == '~')
                 strshift(addr, 1);
               len += strlen(addr);
             }
             buf = malloc(sizeof(char) * (len + strlen(nick) + 16));

             if (flag & F_BAN_)
             {
               sprintf(buf, "/MODE %s +b *!*%s", channel, addr);
               process_cmd(buf, win);
             }
             if (flag & F_KICK_)
             {
               sprintf(buf, "/kick %s %s %s", channel, nick, kick_reason);
               process_cmd(buf, win);
             }
             if (flag & F_IGNORE_)
             {
               sprintf(buf, "/ignore *!*%s", addr);
               process_cmd(buf, win);
             }
             free(buf);
             p = p->next;
           }
         }
       }
       break;
     case 3:
       {
         GtkWidget *wid = create_new_pup();

         gtk_widget_show(wid);
       }
       break;
     default:
       break;
  }
  reset_focus(win);
}

