/*
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
*/
#include "spx.h"
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <sys/utsname.h>
#include "gtk_tb.h"
#include "selection_dialog.h"
#include "config.h"
#include "cmd.h"
#include "ignore.h"
//#include "gui_gtk.h"
#include "etc.h"
#include "warning2.xpm"
#include "spx_people.xpm"
#include "spx.xpm"
#include "spx2-mini.xpm"

extern void script_cb(GtkWidget *, gpointer);
extern void ignore_form_cb(GtkWidget *, gpointer);
extern void ig_edit_cb(GtkWidget *, gpointer);
extern gint dont_close(gpointer data);
Server_add *form_add_server = NULL;
typedef struct
{
  GtkWidget *confirm;
  GtkWidget *no;
}
_Confirm;

static _Confirm *make_confirm(const char *msg, const char *title,
                              void (*cb) (int, void *), void *);

void confirm2(const char *msg,
              const char *title,
              int tmout,
              void (*cb) (int, void *), void *data)
{
  _Confirm *form;

  form = make_confirm(msg, title, cb, data);
  gtk_widget_show(form->confirm);
}

static void confirm_cb(GtkWidget * wid, gpointer data)
{
  void (*cb) (int, void *);
  void *arg;
  _Confirm *form = gtk_object_get_user_data(GTK_OBJECT(wid));

  cb = gtk_object_get_data(GTK_OBJECT(wid), "cb");
  arg = gtk_object_get_data(GTK_OBJECT(wid), "arg");
  gtk_widget_destroy(form->confirm);
  (*cb) ((int) data, arg);
}

static _Confirm *make_confirm(const char *msg,
                              const char *title,
                              void (*cb) (int res, void *arg), void *arg)
{
  GtkWidget *confirm;
  GtkWidget *vbox;
  GtkWidget *hbuttonbox;
  GtkWidget *wid;
  _Confirm *c;

  c = calloc(1, sizeof(_Confirm));
  c->confirm = confirm = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(confirm), title);
  gtk_window_set_policy(GTK_WINDOW(confirm), FALSE, FALSE, FALSE);
  gtk_window_position(GTK_WINDOW(confirm), GTK_WIN_POS_MOUSE);
  gtk_widget_set_name(confirm, "dialog confirm");

  gtk_widget_show(GTK_DIALOG(confirm)->vbox);
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(confirm)->vbox), vbox, TRUE, TRUE, 0);

  wid = create_pixmap_from_data(confirm, warning2_xpm);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox), wid, TRUE, FALSE, 0);

  wid = gtk_label_new(msg);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox), wid, TRUE, TRUE, 0);

  gtk_container_border_width(
                        GTK_CONTAINER(GTK_DIALOG(confirm)->action_area), 5);

  hbuttonbox = gtk_hbutton_box_new();
  gtk_widget_show(hbuttonbox);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(confirm)->action_area),
                     hbuttonbox, TRUE, TRUE, 0);

  wid = gtk_button_new_with_label("Yes");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
  gtk_object_set_user_data(GTK_OBJECT(wid), c);
  gtk_object_set_data(GTK_OBJECT(wid), "cb", cb);
  gtk_object_set_data(GTK_OBJECT(wid), "arg", arg);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(confirm_cb),
                     (gpointer) 1);

  c->no = wid = gtk_button_new_with_label("No");
  gtk_object_set_user_data(GTK_OBJECT(wid), c);
  gtk_object_set_data(GTK_OBJECT(wid), "cb", cb);
  gtk_object_set_data(GTK_OBJECT(wid), "arg", arg);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(confirm_cb),
                     (gpointer) 0);
  gtk_widget_show(wid);
  GTK_WIDGET_SET_FLAGS(wid, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(wid);
  return c;
}

static gint close_server_tool(GtkWidget * w, gpointer junk)
{
  if (form_add_server)
    return TRUE;
  free(server_tool);
  server_tool = NULL;
  return (FALSE);
}
Server_tool *create_server_tool(void)
{
  GtkWidget *servers;
  GtkWidget *servers_scrolledwindow;
  //GtkWidget *server_browser;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *frame;
  GtkWidget *right_vbox;
  GtkWidget *buttonbox;
  GtkWidget *wid;
  Server_tool *st;
  char *titles[] = { "Server/Network", "Port", "1. Nick", "Nick group",
    "Address", "(IRC Name)"
  };

  if (server_tool)
  {
    if (GTK_WIDGET_VISIBLE(server_tool->window))
      gtk_widget_hide(server_tool->window);
    else
      gtk_widget_show(server_tool->window);
    return NULL;
  }

  server_tool=st = calloc(1, sizeof(Server_tool));
  st->window = servers = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(servers, 620, -260);
  gtk_window_set_title(GTK_WINDOW(servers), sula_NAME  ": Server tool");
  gtk_window_set_policy(GTK_WINDOW(servers), FALSE, TRUE, FALSE);
  gtk_signal_connect(GTK_OBJECT(servers), "delete_event",
                     GTK_SIGNAL_FUNC(close_server_tool),
                     NULL);
  gtk_widget_set_name(servers, "server tool");

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(servers), hbox);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

  servers_scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(servers_scrolledwindow);
  gtk_box_pack_start(GTK_BOX(vbox), servers_scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(servers_scrolledwindow),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  st->browser = wid = gtk_ctree_new_with_titles(6, 0, titles);
  gtk_container_add(GTK_CONTAINER(servers_scrolledwindow), wid);
  //gtk_clist_set_column_width(GTK_CLIST(wid), 0, 20);
  //gtk_clist_set_column_width(GTK_CLIST(wid), 1, 20);
  gtk_clist_set_column_auto_resize(GTK_CLIST(wid), 0, TRUE);
  gtk_clist_set_column_auto_resize(GTK_CLIST(wid), 1, TRUE);
  //gtk_clist_set_column_width(GTK_CLIST(wid), 2, 154);
  //gtk_clist_set_column_width(GTK_CLIST(wid), 2, 80);
  gtk_clist_set_column_width(GTK_CLIST(wid), 3, 80);
  //gtk_clist_set_column_auto_resize(GTK_CLIST(wid), 4, TRUE);
  gtk_clist_set_column_width(GTK_CLIST(wid), 4, 120);
  gtk_clist_set_column_width(GTK_CLIST(wid), 5, 120);
  gtk_clist_column_titles_show(GTK_CLIST(wid));
  
  gtk_clist_set_shadow_type(GTK_CLIST(wid), GTK_SHADOW_NONE);
  gtk_widget_show(wid);

  st->status = wid = gtk_label_new("ready");
  //gtk_label_set_justify(GTK_LABEL(wid), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);

  frame = gtk_frame_new(NULL);  // right box

  gtk_widget_show(frame);
  gtk_box_pack_start(GTK_BOX(hbox), frame, FALSE, FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(frame), 3);

  right_vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(right_vbox);
  gtk_container_add(GTK_CONTAINER(frame), right_vbox);

  buttonbox = gtk_vbutton_box_new();
  gtk_widget_show(buttonbox);
  gtk_box_pack_start(GTK_BOX(right_vbox), buttonbox, FALSE, FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(buttonbox), 3);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(buttonbox), 0);
  gtk_button_box_set_child_size(GTK_BUTTON_BOX(buttonbox), 75, 27);
  gtk_button_box_set_child_ipadding(GTK_BUTTON_BOX(buttonbox), 3, 3);

  st->connect = wid = gtk_button_new_with_label("Connect");
  gtk_tooltips_set_tip(tooltips, wid, "connect to server", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(serverlist_cb),
                     (gpointer) 0);

  st->disconnect = wid = gtk_button_new_with_label("Disconnect");
  gtk_tooltips_set_tip(tooltips, wid, "disconnect from server", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(serverlist_cb),
                     (gpointer) 1);

  st->add = wid = gtk_button_new_with_label("Add");
  gtk_tooltips_set_tip(tooltips, wid, "add a new server entry", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(serverlist_cb),
                     (gpointer) 2);

  st->edit = wid = gtk_button_new_with_label("Edit");
  gtk_tooltips_set_tip(tooltips, wid, "edit a server entry", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(serverlist_cb),
                     (gpointer) 3);

  st->remove = wid = gtk_button_new_with_label("Remove");
  gtk_tooltips_set_tip(tooltips, wid, "remove server entry", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(serverlist_cb),
                     (gpointer) 4);

  st->update = wid = gtk_button_new_with_label("Redraw");
  gtk_tooltips_set_tip(tooltips, wid, "redraw display", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(serverlist_cb),
                     (gpointer) 5);

  st->save = wid = gtk_button_new_with_label("Save");
  gtk_tooltips_set_tip(tooltips, wid, "save server list", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(serverlist_cb),
                     (gpointer) 6);
  wid = gtk_button_new_with_label("Load");
  gtk_tooltips_set_tip(tooltips, wid, "merge from file", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(serverlist_cb),
                     (gpointer) 7);

  buttonbox = gtk_vbutton_box_new();
  gtk_widget_show(buttonbox);
  gtk_box_pack_start(GTK_BOX(right_vbox), buttonbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_child_size(GTK_BUTTON_BOX(buttonbox), 75, 27);

  st->dismiss = wid = gtk_button_new_with_label("Hide");
  gtk_tooltips_set_tip(tooltips, wid, "hide this window", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(serverlist_cb),
                     (gpointer) 8);
  wid = create_pixmap_from_data(st->window, spx2_mini_xpm);
  gtk_box_pack_start(GTK_BOX(right_vbox), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);
  return st;
}

static gint free_server_add(GtkWidget * w, gpointer data)
{
  free(form_add_server);
  form_add_server = NULL;
  if(server_tool)
    {
      gtk_widget_set_sensitive(server_tool->add, TRUE);
      gtk_widget_set_sensitive(server_tool->edit, TRUE);
    }
  return FALSE;
}
Server_add *create_add_form(void)
{
  Server_add *add;
  GtkWidget *server_add;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *table;
  GtkWidget *hbuttonbox;
  GtkWidget *wid;

  if (form_add_server){
     if (GTK_WIDGET_VISIBLE(form_add_server->window))
      gtk_widget_hide(form_add_server->window);
    else
      gtk_widget_show(form_add_server->window);
    return NULL;
  }
  form_add_server=add = calloc(1, sizeof(Server_add));
  add->window = server_add = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(server_add, 310, -240);
  gtk_window_set_title(GTK_WINDOW(server_add),
                       sula_NAME ": Server edit");
  gtk_window_set_policy(GTK_WINDOW(server_add), FALSE, TRUE, FALSE);
  gtk_signal_connect(GTK_OBJECT(server_add), "destroy",
                     GTK_SIGNAL_FUNC(free_server_add),
                     (gpointer) 0);
  gtk_widget_set_name(server_add, "dialog add server");

  frame = gtk_frame_new(NULL);
  gtk_widget_show(frame);
  gtk_container_add(GTK_CONTAINER(server_add), frame);
  gtk_container_border_width(GTK_CONTAINER(frame), 6);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(frame), vbox);

  table = gtk_table_new(7, 2, FALSE);
  gtk_table_set_row_spacings(GTK_TABLE(table), 2);
  gtk_widget_show(table);
  gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 2);
  gtk_container_border_width(GTK_CONTAINER(table), 8);

  wid = gtk_label_new("Nick group");
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 0, 1,
                   (GtkAttachOptions) 0, (GtkAttachOptions) 0, 0, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);

  add->nicklist = wid = gtk_combo_new();
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(wid)->entry), FALSE);
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 2, 0, 1,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  add->nick = wid = gtk_entry_new();
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 2, 1, 2,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  add->email = wid = gtk_entry_new();
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 2, 2, 3,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  
  add->ircname = wid = gtk_entry_new();
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 2, 3, 4,
      (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) 0, 0, 0);

  add->servername = wid = gtk_entry_new();
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 2, 4, 5,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  add->port = wid = gtk_entry_new();
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 2, 5, 6,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  add->password = wid = gtk_entry_new();
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 2, 6, 7,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  add->group = wid = gtk_combo_new();
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(wid)->entry), TRUE);
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 2, 7, 8,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_combo_set_case_sensitive(GTK_COMBO(wid), 0);

  wid = gtk_label_new("Nick");
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 1, 2,
                   (GtkAttachOptions) 0, (GtkAttachOptions) 0, 0, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);
  wid = gtk_label_new("E-mail addr");
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 2, 3,
                   (GtkAttachOptions) 0, (GtkAttachOptions) 0, 0, 0);
  gtk_label_set_justify(GTK_LABEL(wid), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_widget_show(wid);
  
  wid = gtk_label_new("Irc name");
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 3, 4,
                   (GtkAttachOptions) 0, (GtkAttachOptions) 0, 0, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);

  wid = gtk_label_new("Server");
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 4, 5,
                   (GtkAttachOptions) 0, (GtkAttachOptions) 0, 0, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);
  wid = gtk_label_new("Port");
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 5, 6,
                   (GtkAttachOptions) 0, (GtkAttachOptions) 0, 0, 0);
  gtk_widget_show(wid);
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);

  wid = gtk_label_new("Password");
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 6, 7,
                   (GtkAttachOptions) 0, (GtkAttachOptions) 0, 0, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);
  gtk_widget_show(wid);

  wid = gtk_label_new("Network");
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 7, 8,
                   (GtkAttachOptions) 0, (GtkAttachOptions) 0, 0, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);
  gtk_widget_show(wid);

  wid = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, FALSE, 0);
  gtk_widget_set_usize(wid, 30, -2);
  gtk_widget_show(wid);

  hbuttonbox = gtk_hbutton_box_new();
  gtk_box_pack_start(GTK_BOX(vbox), hbuttonbox, FALSE, TRUE, 0);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_SPREAD);
  gtk_container_set_border_width(GTK_CONTAINER(hbuttonbox), 8);
  gtk_widget_show(hbuttonbox);

  add->done = wid = gtk_button_new_with_label("Add");
  gtk_tooltips_set_tip(tooltips, wid, "add as new entry", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(add_server_cb),
                     (gpointer) 0);

  add->close = wid = gtk_button_new_with_label("Cancel");
  gtk_tooltips_set_tip(tooltips, wid, "cancel operation", NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(add_server_cb),
                     (gpointer) 1);

  
  if(server_tool)
    {
      gtk_widget_set_sensitive(server_tool->add, FALSE);
      gtk_widget_set_sensitive(server_tool->edit, FALSE);
    }
  return add;
}


static GtkWidget *about = NULL;
static void quit_about(GtkWidget * wid, GdkEventButton * event, gpointer junk)
{
  if (about)
    gtk_widget_destroy(about);
  about = NULL;
}
static gint about_clear(GtkWidget * wid, gpointer junk)
{
  about = NULL;
  return FALSE;
}
GtkWidget *create_about(void)
{
  GtkWidget *vbox,
      *vbox0;
  GtkWidget *wid;
  GtkWidget *hbox2,
      *hbox3;
  GtkWidget *vbox2;
  GtkStyle *style;
  GtkWidget *eventbox;
  struct utsname ut;
  char s[30];
  static char *release = NULL;

  if (about)
  {
    if (GTK_WIDGET_VISIBLE(about))
      gtk_widget_hide(about);
    else
      gtk_widget_show(about);
    return NULL;
  }
  if (release == 0)
  {
    time_t t = sula_RELEASE;

    release = ctime(&t);
    *(release + strlen(release) - 1) = 0;
  }

  about = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(about), "About " sula_NAME);
  gtk_window_position(GTK_WINDOW(about), GTK_WIN_POS_CENTER);
  gtk_window_set_policy(GTK_WINDOW(about), FALSE, FALSE, FALSE);
  gtk_widget_set_name(about, "about");
  gtk_signal_connect(GTK_OBJECT(about), "destroy",
                     GTK_SIGNAL_FUNC(about_clear),
                     (gpointer) 0);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(about), vbox);

  eventbox = gtk_event_box_new();
  gtk_box_pack_start(GTK_BOX(vbox), eventbox, FALSE, TRUE, 0);
  gtk_widget_show(eventbox);
  wid = create_pixmap_from_data(about, spx_xpm);
  gtk_container_add(GTK_CONTAINER(eventbox), wid);
  gtk_widget_show(wid);
  
  hbox2 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox2);
  gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, FALSE, 0);

  eventbox = gtk_event_box_new();
  gtk_widget_set_events(eventbox, GDK_BUTTON_PRESS_MASK);
  gtk_signal_connect(GTK_OBJECT(eventbox), "button_press_event",
                     GTK_SIGNAL_FUNC(quit_about),
                     NULL);
  gtk_box_pack_start(GTK_BOX(hbox2), eventbox, TRUE, FALSE, 0);
  gtk_widget_realize(eventbox);
  gdk_window_set_cursor(eventbox->window, gdk_cursor_new(GDK_HAND2));
  gtk_widget_show(eventbox);
  wid = create_pixmap_from_data(about, spx_people_xpm);
  gtk_container_add(GTK_CONTAINER(eventbox), wid);
  gtk_widget_show(wid);

  vbox0 = gtk_vbox_new(FALSE, 0);	//left side

  gtk_widget_show(vbox0);
  gtk_box_pack_start(GTK_BOX(hbox2), vbox0, TRUE, FALSE, 0);

  vbox2 = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox2);
  gtk_box_pack_start(GTK_BOX(vbox0), vbox2, TRUE, TRUE, 0);

  style = gtk_style_copy(GTK_WIDGET(about)->style);
  gdk_font_unref(style->font);
  style->font = spx_idx2font(STYLE_FIXED);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox3);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, TRUE, 0);

  wid = gtk_label_new("Author : ");
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  wid = gtk_label_new("Ta" "no" " F" "o" "ta" "n" "g");
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_widget_set_style(wid, style);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, TRUE, TRUE, 0);

  hbox3 = gtk_hbox_new(FALSE, 0);	// Version : 03044

  gtk_widget_show(hbox3);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, TRUE, 0);
  wid = gtk_label_new("Version: ");
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  gtk_widget_show(wid);
  wid = gtk_label_new(sula_VERSION);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_widget_set_style(wid, style);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, TRUE, TRUE, 0);
  gtk_widget_show(wid);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox3);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, TRUE, 0);
  wid = gtk_label_new("Release: ");
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  gtk_widget_show(wid);
  wid = gtk_label_new(release);
  gtk_widget_set_style(wid, style);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, TRUE, TRUE, 0);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox3);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, TRUE, 0);
  wid = gtk_label_new("Machine: ");
  gtk_misc_set_alignment(GTK_MISC(wid), 1.0, 0.5);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  if (uname(&ut) != 0)
    wid = gtk_label_new("unknown");
  else
  {
    char t[132];                /* 64*2 */

    sprintf(t, "%s %s", ut.sysname, ut.release);
    wid = gtk_label_new(t);
  }
  gtk_widget_set_style(wid, style);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, TRUE, TRUE, 0);

  wid = gtk_hseparator_new();
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox2), wid, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox3);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, TRUE, 0);
  wid = gtk_label_new("Compiled ");
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  gtk_widget_show(wid);
  sprintf(s, "%s (%s)", __DATE__, __TIME__);
  wid = gtk_label_new(s);
  gtk_widget_set_style(wid, style);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_widget_show(wid);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox3);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, TRUE, 0);
  wid = gtk_label_new("by ");
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  gtk_widget_show(wid);
  wid = gtk_label_new(sula_COMPILED);
  gtk_widget_set_style(wid, style);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_widget_show(wid);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox3);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, TRUE, 0);
  wid = gtk_label_new("on host ");
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  gtk_widget_show(wid);
  wid = gtk_label_new(sula_HOST " (" sula_OS ")");
  gtk_widget_set_style(wid, style);
  gtk_box_pack_start(GTK_BOX(hbox3), wid, FALSE, TRUE, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_widget_show(wid);

  wid = gtk_hseparator_new();
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox2), wid, FALSE, FALSE, 0);
#if 0
  wid = gtk_button_new_with_label("Copyrite and warranty");
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox2), wid, FALSE, FALSE, 0);
  //GTK_WIDGET_SET_FLAGS (wid, GTK_CAN_DEFAULT);
  /*gtk_signal_connect (GTK_OBJECT(wid), "clicked",
     GTK_SIGNAL_FUNC (about_cb),
     NULL); */
#endif
  style = gtk_style_copy(GTK_WIDGET(about)->style);
  gdk_font_unref(style->font);
  style->font = spx_idx2font(STYLE_NORMAL);
  style->fg[GTK_STATE_NORMAL] = SPX_BLUE();
  wid = gtk_entry_new();
  spx_set_input(wid, sula_GETTING);
  gtk_entry_set_editable(GTK_ENTRY(wid), FALSE);
  gtk_widget_set_style(wid, style);
  gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, TRUE, 0);
  gtk_widget_show(wid);
  wid = gtk_entry_new();
  gtk_entry_set_editable(GTK_ENTRY(wid), FALSE);
  spx_set_input(wid, sula_EMAIL);
  gtk_widget_set_style(wid, style);
  gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, TRUE, 0);
  gtk_widget_show(wid);

  return about;
}

static GtkWidget *userguide = NULL;
static void show_help(const char *s1,
                      const char *s2, GtkWidget * text)
{
  char *hfname = NULL;
  char *hdir = sula_lib;
  size_t ll;

  ll = strlen(hdir);
  if (!s2)
  {
    hfname = (char *) malloc(sizeof(char) * (ll + strlen(s1) + 16));

    sprintf(hfname, "%s/help/%s.hlp", *hdir ? hdir : ".", s1);
  }
  else
  {
    hfname = (char *) malloc(sizeof(char) * (ll + strlen(s1) + strlen(s2) + 16));

    sprintf(hfname, "%s/help/%s/%s.hlp", *hdir ? hdir : ".", s1, s2);
  }
  if (spx_load_file(text, hfname))
  {
#if 1
    int err = errno;
    char *buf = malloc(sizeof(char) * (strlen(hfname) + 256));
    GtkWidget *status = gtk_object_get_data(GTK_OBJECT(userguide),
                                            "status");

    sprintf(buf, "%s: %s", hfname, strerror(err));
    fit_object_label(status, buf);
#endif
    if (gflags & BEEP_ERR)
      spx_bell(-40);

  }
  free(hfname);
}

static void userguide_cb(GtkWidget * wid, gpointer data)
{
  if (!userguide)
    return;                     //desection/selection when widget hidden?segv

  switch ((long) data)
   {
     case 5:
       {
         GtkWidget *wid = gtk_object_get_data(GTK_OBJECT(userguide),
                                              "browser");

         TEXT_CLEAR(wid);
         break;
       }
     case 0:
       {
         GtkWidget *list = gtk_object_get_user_data(GTK_OBJECT(userguide));
         GList *choice = GTK_LIST(list)->selection;

         if (choice)
         {
           GtkWidget *text = gtk_object_get_data(GTK_OBJECT(userguide),
                                                 "browser");
           GtkObject *item = GTK_OBJECT(choice->data);
           char *cmd = gtk_object_get_user_data(item);

           show_help(uppercase(cmd), NULL, text);
         }
         break;
       }
   }
}
static gint form_reset(GtkWidget * wid, gpointer junk)
{
  userguide = NULL;
  return FALSE;
}

static void browse_cmds(Cmd * p, GtkWidget * list)
{
  if (p)
  {
    GtkWidget *item;

    browse_cmds(p->left, list);
    item = gtk_list_item_new_with_label(p->name);
    gtk_object_set_user_data(GTK_OBJECT(item), p->name);
    gtk_container_add(GTK_CONTAINER(list), item);
    gtk_widget_show(item);
    browse_cmds(p->right, list);
  }
}

GtkWidget *create_userguide(void)
{
  GtkWidget *hpaned;
  GtkWidget *scrolledwindow;
  GtkWidget *wid;
  GtkWidget *hbox;
  GtkStyle *style;

  if (userguide)
  {
    if (GTK_WIDGET_VISIBLE(userguide))
      gtk_widget_hide(userguide);
    else
      gtk_widget_show(userguide);
    return NULL;
  }
  userguide = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(userguide), sula_NAME ": Command list");
  gtk_window_set_policy(GTK_WINDOW(userguide), TRUE, TRUE, FALSE);
  gtk_widget_set_name(userguide, "command list");
  gtk_signal_connect(GTK_OBJECT(userguide), "destroy",
                     GTK_SIGNAL_FUNC(form_reset),
                     (gpointer) userguide);
  hpaned = gtk_hpaned_new();
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(userguide)->vbox), hpaned, TRUE, TRUE, 0);
  gtk_widget_set_usize(hpaned, 500, 365);
  gtk_container_border_width(GTK_CONTAINER(hpaned), 2);
  gtk_paned_gutter_size(GTK_PANED(hpaned), 5);
  gtk_widget_show(hpaned);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);

  gtk_container_add(GTK_CONTAINER(hpaned), scrolledwindow);
  gtk_widget_set_usize(scrolledwindow, 120, -2);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  wid = gtk_list_new();
  gtk_object_set_user_data(GTK_OBJECT(userguide), wid);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW
                                        (scrolledwindow), wid);
  browse_cmds(bi_cmdTree, wid);
  gtk_widget_show(wid);
  gtk_signal_connect(GTK_OBJECT(wid), "selection_changed",
                     GTK_SIGNAL_FUNC(userguide_cb),
                     (gpointer) 0);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(hpaned), scrolledwindow);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(scrolledwindow);

  wid = gtk_text_new(NULL, NULL);
  gtk_object_set_data(GTK_OBJECT(userguide), "browser", wid);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
  gtk_widget_show(wid);

  gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(userguide)->action_area), 3);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(userguide)->action_area),
                     hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);
  wid = gtk_label_new("");
  style = gtk_style_copy(GTK_WIDGET(userguide)->style);
  gdk_font_unref(style->font);
  style->font = spx_idx2font(STYLE_ITALIC);
  gtk_label_set_justify(GTK_LABEL(wid), GTK_JUSTIFY_LEFT);
  gtk_widget_set_style(wid, style);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_object_set_data(GTK_OBJECT(userguide), "status", wid);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);

  wid = gtk_button_new_with_label("Clear");
  gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(userguide_cb),
                     (gpointer) 5);
  gtk_tooltips_set_tip(tooltips, wid, "clear text area", 0);
  gtk_widget_show(wid);

  wid = gtk_button_new_with_label("Dismiss");
  gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_signal_connect_object(GTK_OBJECT(wid), "clicked",
                   GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(userguide));
  gtk_tooltips_set_tip(tooltips, wid, "hide this window", 0);
  gtk_widget_show(wid);

  return userguide;
}
static gint script_form_reset(GtkWidget * wid, gpointer junk)
{
  free(script_form);
  script_form = NULL;
  return FALSE;
}
Script_control *create_script(void)
{
  GtkWidget *script;
  GtkWidget *vbox;
  GtkWidget *right_vbox;
  GtkWidget *notebook;
  GtkWidget *hbox4;
  GtkWidget *scrolledwindow;
  GtkWidget *vbuttonbox;
  GtkWidget *hbox5;
  GtkWidget *wid;
  GtkWidget *eventbox;
  GtkStyle *style;
  char *titles[] = {"Command", "SN", "Sock", "Flag", "[P]", "Pattern"};
  char *titles1[] = {"Name", "Sock", "Command"};

  if (script_form)
  {
    if (GTK_WIDGET_VISIBLE(script_form->window))
      gtk_widget_hide(script_form->window);
    else
      gtk_widget_show(script_form->window);
    return NULL;
  }
  script_form = calloc(1, sizeof(Script_control));
  script_form->window = script = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(script, 540, 300);
  gtk_container_border_width(GTK_CONTAINER(script), 2);
  gtk_window_set_title(GTK_WINDOW(script), sula_NAME ": Hooks & NCs");
  gtk_window_set_policy(GTK_WINDOW(script), FALSE, TRUE, FALSE);
  gtk_widget_set_name(script, "event tool");
  gtk_signal_connect(GTK_OBJECT(script), "destroy",
                     GTK_SIGNAL_FUNC(script_form_reset),
                     (gpointer) 0);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(script), vbox);

  notebook = gtk_notebook_new();
  gtk_widget_show(notebook);
  gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);

  wid = gtk_label_new("Events");
  gtk_widget_show(wid);
  hbox4 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox4);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), hbox4, wid);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_box_pack_start(GTK_BOX(hbox4), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  wid = gtk_clist_new_with_titles(6, titles);
  gtk_object_set_data(GTK_OBJECT(script), "clist", wid);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
  gtk_clist_set_column_auto_resize(GTK_CLIST(wid), 0, TRUE);
  gtk_clist_set_column_auto_resize(GTK_CLIST(wid), 1, TRUE);
  gtk_clist_set_column_auto_resize(GTK_CLIST(wid), 2, TRUE);
  gtk_clist_set_column_width(GTK_CLIST(wid), 3, 30);
  gtk_clist_set_column_auto_resize(GTK_CLIST(wid), 4, TRUE);
  gtk_clist_column_titles_show(GTK_CLIST(wid));
  gtk_clist_set_selection_mode(GTK_CLIST(wid), GTK_SELECTION_MULTIPLE);
  gtk_widget_show(wid);

  right_vbox= gtk_vbox_new(FALSE, 0);
  gtk_widget_show(right_vbox);
  gtk_box_pack_start(GTK_BOX(hbox4), right_vbox, FALSE, FALSE, 0);

  vbuttonbox = gtk_vbutton_box_new();
  gtk_widget_show(vbuttonbox);
  gtk_box_pack_start(GTK_BOX(right_vbox), vbuttonbox, FALSE, FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(vbuttonbox), 2);
  gtk_button_box_set_child_size(GTK_BUTTON_BOX(vbuttonbox), 75, 27);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(vbuttonbox),
                            GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(vbuttonbox), 0);

  wid = gtk_button_new_with_label("Pause");
  gtk_tooltips_set_tip(tooltips, wid, "deactivate selected hooks", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 27);

  wid = gtk_button_new_with_label("Resume");
  gtk_tooltips_set_tip(tooltips, wid, "reactivate selected hooks", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 26);

  wid = gtk_button_new_with_label("Remove");
  gtk_tooltips_set_tip(tooltips, wid, "remove selected hooks", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 28);

  wid = gtk_button_new_with_label("Update");
  gtk_tooltips_set_tip(tooltips, wid, "force display update", 0);
  gtk_object_set_data(GTK_OBJECT(script), "update", wid);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 8);

  wid = gtk_button_new_with_label("Done");
  gtk_tooltips_set_tip(tooltips, wid, "hide this window", 0);
  gtk_signal_connect_object(GTK_OBJECT(wid), "clicked",
                      GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(script));
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);

  wid = create_pixmap_from_data(script, spx2_mini_xpm);
  gtk_box_pack_end(GTK_BOX(right_vbox), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);

  wid = gtk_label_new("NC");
  gtk_widget_show(wid);
  hbox5 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox5);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), hbox5, wid);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_box_pack_start(GTK_BOX(hbox5), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  wid = gtk_clist_new_with_titles(3, titles1);
  gtk_object_set_data(GTK_OBJECT(script), "clist2", wid);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
  gtk_clist_set_column_width(GTK_CLIST(wid), 0, 80);
  gtk_clist_set_column_width(GTK_CLIST(wid), 1, 40);
  gtk_clist_set_column_width(GTK_CLIST(wid), 2, 120);
  gtk_clist_column_titles_show(GTK_CLIST(wid));
  gtk_clist_set_selection_mode(GTK_CLIST(wid), GTK_SELECTION_MULTIPLE);
  gtk_widget_show(wid);

  right_vbox= gtk_vbox_new(FALSE, 0);
  gtk_widget_show(right_vbox);
  gtk_box_pack_start(GTK_BOX(hbox5), right_vbox, FALSE, FALSE, 0);

  vbuttonbox = gtk_vbutton_box_new();
  gtk_widget_show(vbuttonbox);
  gtk_box_pack_start(GTK_BOX(right_vbox), vbuttonbox, FALSE, FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(vbuttonbox), 2);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(vbuttonbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_child_size(GTK_BUTTON_BOX(vbuttonbox), 75, 27);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(vbuttonbox), 0);
  wid = gtk_button_new_with_label("Run");
  gtk_tooltips_set_tip(tooltips, wid,
                       "create named connection to a program", 0);
  gtk_object_set_data(GTK_OBJECT(script), "run", wid);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 10);

  wid = gtk_button_new_with_label("Pause");
  gtk_tooltips_set_tip(tooltips, wid, "deactivate selected connections", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 11);
  wid = gtk_button_new_with_label("Stop");
  gtk_tooltips_set_tip(tooltips, wid,
                       "send stop signal to selected conections", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 17);
  wid = gtk_button_new_with_label("Resume");
  gtk_tooltips_set_tip(tooltips, wid,
                       "reactivate the selected stopped connections", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 18);
  wid = gtk_button_new_with_label("Kill");
  gtk_tooltips_set_tip(tooltips, wid, "kill the selected connections", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 12);
  script_form->update = wid = gtk_button_new_with_label("Update");
  gtk_tooltips_set_tip(tooltips, wid, "force display update", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(script_cb),
                     (gpointer) 8);

  wid = gtk_button_new_with_label("Done");
  gtk_tooltips_set_tip(tooltips, wid, "hide this window", 0);
  gtk_container_add(GTK_CONTAINER(vbuttonbox), wid);
  gtk_signal_connect_object(GTK_OBJECT(wid), "clicked",
                      GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(script));
  gtk_widget_show(wid);

  wid = create_pixmap_from_data(script, spx2_mini_xpm);
  gtk_box_pack_end(GTK_BOX(right_vbox), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);
  
  style = gtk_style_copy(GTK_WIDGET(script)->style);
  style->fg[GTK_STATE_NORMAL] = SPX_WHITE();
  style->bg[GTK_STATE_NORMAL] = SPX_BLACK();

  eventbox = gtk_event_box_new();
  gtk_box_pack_start(GTK_BOX(vbox), eventbox, FALSE, TRUE, 0);
  gtk_widget_set_style(eventbox, style);
  gtk_container_border_width(GTK_CONTAINER(eventbox), 2);
  gtk_widget_show(eventbox);
  script_form->status = wid = gtk_label_new("ready");
  style = gtk_style_copy(GTK_WIDGET(eventbox)->style);
  gdk_font_unref(style->font);
  style->font = spx_idx2font(STYLE_ITALIC);
  gtk_widget_set_style(wid, style);
  //gtk_label_set_justify(GTK_LABEL(wid), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_container_add(GTK_CONTAINER(eventbox), wid);
  gtk_widget_show(wid);

  return script_form;
}
static gint ignore_form_reset(GtkWidget * wid, gpointer junk)
{
  free(ignore_form);
  ignore_form = NULL;
  return FALSE;
}

void ignore_form_select_cb(GtkWidget * widget,
                           gint row,
                           gint column,
                           GdkEventButton * event,
                           gpointer data)
{
  switch ((long) data)
   {
     case 0:                   //selection

       {
         char *mask;
         Ignore *p;
         gint row;
         GList *pclist = GTK_CLIST(ignore_form->clist)->selection;

         if (pclist)            // must be true

         {
           extern Ignore *get_ignore(const char *mask);

           row = GPOINTER_TO_INT(pclist->data);
           gtk_clist_get_text(GTK_CLIST(ignore_form->clist), row, 0, &mask);
           p = get_ignore(mask);
           if (p)
           {
             SET_BUTTON(ignore_form->msg, p->what & IG_PRIVMSG);
             SET_BUTTON(ignore_form->pubmsg, p->what & IG_PUBMSG);
             SET_BUTTON(ignore_form->notice, p->what & IG_PRIVNOTICE);
             SET_BUTTON(ignore_form->pubnotice, p->what & IG_PUBNOTICE);
             SET_BUTTON(ignore_form->invites, p->what & IG_INVITE);
             SET_BUTTON(ignore_form->dcc, p->what & IG_DCC);
             SET_BUTTON(ignore_form->note, p->what & IG_NOTE);
             SET_BUTTON(ignore_form->ctcp, p->what & IG_CTCP);
             SET_BUTTON(ignore_form->misc, p->what & IG_MISC);
           }
         }
       }
       break;
     case 1:
       SET_BUTTON(ignore_form->msg, 0);
       SET_BUTTON(ignore_form->pubmsg, 0);
       SET_BUTTON(ignore_form->notice, 0);
       SET_BUTTON(ignore_form->pubnotice, 0);
       SET_BUTTON(ignore_form->invites, 0);
       SET_BUTTON(ignore_form->dcc, 0);
       SET_BUTTON(ignore_form->note, 0);
       SET_BUTTON(ignore_form->ctcp, 0);
       SET_BUTTON(ignore_form->misc, 0);
       break;
   }
}

GtkWidget *create_ignore(void)
{
  GtkWidget *ignore;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *scrolledwindow;
  GtkWidget *wid;
  GtkWidget *frame;
  GtkWidget *vbox2;
  GtkWidget *buttonbox;
  char *titles[] = {"Mask", "Time left"};

  if (ignore_form)
  {
    if (GTK_WIDGET_VISIBLE(ignore_form->window))
      gtk_widget_hide(ignore_form->window);
    else
      gtk_widget_show(ignore_form->window);
    return NULL;
  }
  ignore_form = calloc(1, sizeof(Ignore_form));
  ignore_form->window = ignore = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data(GTK_OBJECT(ignore), "ignore", ignore);
  gtk_widget_set_usize(ignore, 600, -2);
  gtk_window_set_title(GTK_WINDOW(ignore), sula_NAME ": Ignore list");
  gtk_window_set_policy(GTK_WINDOW(ignore), FALSE, TRUE, FALSE);
  gtk_widget_set_name(ignore, "ignore tool");
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(ignore), vbox);
  gtk_signal_connect(GTK_OBJECT(ignore), "destroy",
                     GTK_SIGNAL_FUNC(ignore_form_reset),
                     (gpointer) 0);

  ignore_form->status = wid = gtk_label_new("ready");
  //gtk_label_set_justify(GTK_LABEL(wid), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, TRUE, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_widget_show(wid);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_box_pack_start(GTK_BOX(hbox), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  ignore_form->clist = wid = gtk_clist_new_with_titles(2, titles);
  gtk_clist_set_selection_mode(GTK_CLIST(wid), GTK_SELECTION_MULTIPLE);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
  gtk_clist_set_column_width(GTK_CLIST(wid), 0, 280);
  gtk_clist_set_column_width(GTK_CLIST(wid), 1, 64);
  gtk_clist_column_titles_show(GTK_CLIST(wid));
  gtk_signal_connect(GTK_OBJECT(wid), "select_row",
                     GTK_SIGNAL_FUNC(ignore_form_select_cb),
                     (gpointer) 0);
  gtk_signal_connect(GTK_OBJECT(wid), "unselect_row",
                     GTK_SIGNAL_FUNC(ignore_form_select_cb),
                     (gpointer) 1);
  gtk_widget_show(wid);

  frame = gtk_frame_new("event");
  gtk_widget_show(frame);
  gtk_box_pack_start(GTK_BOX(hbox), frame, FALSE, FALSE, 0);
  gtk_frame_set_label_align(GTK_FRAME(frame), 0.01, 0.5);

  vbox2 = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(frame), vbox2);
  gtk_widget_show(vbox2);

  buttonbox = gtk_vbutton_box_new();
  gtk_widget_show(buttonbox);
  gtk_box_pack_start(GTK_BOX(vbox2), buttonbox, FALSE, FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(buttonbox), 2);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(buttonbox), 1);

  ignore_form->msg = wid = gtk_check_button_new_with_label("private messages");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  ignore_form->notice = wid = gtk_check_button_new_with_label("private notices");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  ignore_form->pubmsg = wid = gtk_check_button_new_with_label("public messages");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  ignore_form->pubnotice = wid = gtk_check_button_new_with_label("public notices");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  ignore_form->invites = wid = gtk_check_button_new_with_label("invitations");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  ignore_form->ctcp = wid = gtk_check_button_new_with_label("CTCP");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  ignore_form->dcc = wid = gtk_check_button_new_with_label("DCC");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  ignore_form->misc = wid = gtk_check_button_new_with_label("Miscellaneous");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  ignore_form->note = wid = gtk_check_button_new_with_label("Notes");
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  wid = gtk_button_new_with_label("Apply");
  gtk_tooltips_set_tip(tooltips, wid, "apply above settings to seleted masks", 0);
  gtk_widget_show(wid);
  gtk_box_pack_end(GTK_BOX(vbox2), wid, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ignore_form_cb),
                     (gpointer) 8);

  buttonbox = gtk_hbutton_box_new();
  gtk_widget_show(buttonbox);
  gtk_box_pack_start(GTK_BOX(vbox), buttonbox, FALSE, FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(buttonbox), 2);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(buttonbox), 0);
  gtk_button_box_set_child_ipadding(GTK_BUTTON_BOX(buttonbox), 0, 0);

  wid = gtk_button_new_with_label("Remove");
  gtk_tooltips_set_tip(tooltips, wid, "unignore selected entries", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ignore_form_cb),
                     (gpointer) 1);

  wid = gtk_button_new_with_label("Edit");
  gtk_tooltips_set_tip(tooltips, wid, "edit first selected entry", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ignore_form_cb),
                     (gpointer) 2);

  wid = gtk_button_new_with_label("New");
  gtk_tooltips_set_tip(tooltips, wid, "create a new ignore entry", 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ignore_form_cb),
                     (gpointer) 3);

  wid = gtk_button_new_with_label("Save");
  gtk_tooltips_set_tip(tooltips, wid, "save entries to a file", 0);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ignore_form_cb),
                     (gpointer) 4);
  gtk_widget_show(wid);

  wid = gtk_button_new_with_label("Load");
  gtk_tooltips_set_tip(tooltips, wid, "add entries from a file", 0);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ignore_form_cb),
                     (gpointer) 5);
  gtk_widget_show(wid);

  ignore_form->update = wid = gtk_button_new_with_label("Update");
  gtk_tooltips_set_tip(tooltips, wid, "force display update", 0);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ignore_form_cb),
                     (gpointer) 6);
  gtk_widget_show(wid);

  wid = gtk_button_new_with_label("Done");
  gtk_tooltips_set_tip(tooltips, wid, "destroy this window", 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ignore_form_cb),
                     (gpointer) 7);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(buttonbox), wid);

  return ignore;
}

GtkWidget *create_edit_ignore(void)
{
  GtkWidget *edit_ignore;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *table;
  GList *combo_str = NULL;
  GtkWidget *hbox;
  GtkWidget *wid;

  edit_ignore = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(edit_ignore), sula_NAME ": Edit ignore mask");
  gtk_window_position(GTK_WINDOW(edit_ignore), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy(GTK_WINDOW(edit_ignore), FALSE, TRUE, FALSE);
  gtk_widget_set_name(edit_ignore, "ignore add");

  frame = gtk_frame_new(NULL);
  gtk_widget_show(frame);
  gtk_container_add(GTK_CONTAINER(edit_ignore), frame);
  gtk_container_border_width(GTK_CONTAINER(frame), 2);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_container_border_width(GTK_CONTAINER(vbox), 17);

  table = gtk_table_new(2, 3, FALSE);
  gtk_widget_show(table);
  gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);
  gtk_table_set_row_spacings(GTK_TABLE(table), 4);
  gtk_table_set_col_spacings(GTK_TABLE(table), 2);

  wid = gtk_label_new("for");
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 1, 2,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_label_set_justify(GTK_LABEL(wid), GTK_JUSTIFY_LEFT);

  wid = gtk_label_new("ignore");
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 0, 1, 0, 1,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_label_set_justify(GTK_LABEL(wid), GTK_JUSTIFY_LEFT);

  wid = gtk_entry_new();
  gtk_object_set_data(GTK_OBJECT(edit_ignore), "mask", wid);
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 3, 0, 1,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);

  wid = gtk_entry_new();
  gtk_object_set_data(GTK_OBJECT(edit_ignore), "period", wid);
  gtk_widget_show(wid);
  gtk_table_attach(GTK_TABLE(table), wid, 1, 2, 1, 2,
                   (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_entry_set_text(GTK_ENTRY(wid), "0");

  wid = gtk_combo_new();
  gtk_object_set_data(GTK_OBJECT(edit_ignore), "combo", wid);
  gtk_table_attach(GTK_TABLE(table), wid, 2, 3, 1, 2,
                   (GtkAttachOptions) 0, (GtkAttachOptions) 0, 1, 0);
  gtk_widget_set_usize(GTK_COMBO(wid)->entry, 64, -2);
  gtk_widget_set_usize(wid, 80, -2);
  combo_str = g_list_append(combo_str, "minutes");
  combo_str = g_list_append(combo_str, "hours");
  combo_str = g_list_append(combo_str, "seconds");
  gtk_combo_set_popdown_strings(GTK_COMBO(wid), combo_str);
  g_list_free(combo_str);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(wid)->entry), FALSE);
  gtk_widget_show(wid);

  hbox = gtk_hbox_new(TRUE, 5);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(hbox), 6);

  wid = gtk_button_new_with_label("Ok!");
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ig_edit_cb),
                     (gpointer) 0);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS(wid, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(wid);
  gtk_object_set_user_data(GTK_OBJECT(wid), edit_ignore);
  gtk_widget_show(wid);

  wid = gtk_button_new_with_label("Dismiss");
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(ig_edit_cb),
                     (gpointer) 1);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, TRUE, 0);
  gtk_object_set_user_data(GTK_OBJECT(wid), edit_ignore);
  gtk_widget_show(wid);

  wid = gtk_label_new("");
  gtk_object_set_data(GTK_OBJECT(edit_ignore), "status", wid);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, FALSE, 0);

  return edit_ignore;
}
