/*
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix)
*/
#include "spx.h"
#include <unistd.h>
#include <string.h>

#include <assert.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include "gui_gtk.h"

#include "etc.h"
#include "selection_dialog.h"
//#include "skriptx.h"
#include "userpup.h"
#include "editor2.xpm"
#include "exit2.xpm"
#include "script2.xpm"
#include "server2.xpm"
#include "setup2.xpm"
#include "userguide2.xpm"
#include "win2.xpm"
#include "spx2-mini.xpm"

GtkTooltips *tooltips;
extern gint browser_raw_cb(GtkWidget *, GdkEventButton *, gpointer);
extern void editor_cb(GtkWidget *, gpointer);

gint dont_close(gpointer data)
{
  return TRUE;
}
void set_entry_focus(GtkObject * entry)
{
  gtk_widget_grab_focus(GTK_WIDGET(entry));
}
GtkWidget *create_pixmap_from_data(GtkWidget * window, gchar ** data)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkWidget *id;

  pixmap = gdk_pixmap_colormap_create_from_xpm_d
     (NULL, gtk_widget_get_colormap(window), &mask,
      NULL, data);
  if (pixmap == NULL)
    return NULL;
  id = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
  return id;
}
GtkWidget *create_pixmap_from_path(GtkWidget * widget, gchar * path)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkWidget *id;

  pixmap = gdk_pixmap_colormap_create_from_xpm(NULL,
                                            gtk_widget_get_colormap(widget),
                                               &mask,
                                               NULL, path);
  if (pixmap == NULL)
    return NULL;
  id = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
  return id;
}

int set_bg_pixamp(GtkWidget * wid, const char *pix)
{
  GdkPixmap *pixmap = NULL;
  GtkStyle *style = gtk_style_copy(wid->style);

  if (pix && *pix)
  {
    struct stat ss;

    if (!stat(pix, &ss))
        if (!S_ISREG(ss.st_mode))
          return -1;
    pixmap =
       gdk_pixmap_colormap_create_from_xpm(NULL,
                                           gtk_widget_get_colormap(wid),
                                           NULL,
                                           &style->bg[GTK_STATE_NORMAL],
                                           pix);
    if (!pixmap)
      return -1;
  }
  if (style->bg_pixmap[GTK_STATE_NORMAL])
    gdk_pixmap_unref(style->bg_pixmap[GTK_STATE_NORMAL]);
  style->bg_pixmap[GTK_STATE_NORMAL] = pixmap;
  gtk_widget_set_style(wid, style);
  return 0;
}

int set_text_colour(GtkWidget * wid, const char *name,
                           int bg)
{
  
  GdkColor col;
  GtkStyle *style;
  
  if (!gdk_color_parse(name, &col))
    return -1;
  style = gtk_style_copy(wid->style);
  if (bg)
    style->base[GTK_STATE_NORMAL] = col;
  else
    style->text[GTK_STATE_NORMAL] = col;
  gtk_widget_set_style(wid, style);
  return 0;
}

static gint main_window_raw_cb(GtkWidget * widget,
                               GdkEventKey * event,
                               gpointer junk)
{
  switch (event->type)
   {
     case GDK_KEY_PRESS:
       {
         switch (event->keyval)
          {
            case GDK_Up:
              TRIGGER_OBJECT(main_window->FwdHist);
              return TRUE;
            case GDK_Down:
              TRIGGER_OBJECT(main_window->HistRew);
              return TRUE;
            default:
              return FALSE;
            case GDK_Page_Down:
              {
              GtkAdjustment *adj= gtk_scrolled_window_get_vadjustment(
              GTK_SCROLLED_WINDOW(
               gtk_object_get_data(GTK_OBJECT(main_window->main_window),
                                  "sw" )));
              
              page_down(adj);
              }
              break;
            case GDK_Page_Up:
              {
              GtkAdjustment *adj= gtk_scrolled_window_get_vadjustment(
              GTK_SCROLLED_WINDOW(
               gtk_object_get_data(GTK_OBJECT(main_window->main_window),
                                  "sw" )));
              
              page_up(adj);
              }
              break;
          }
       }
     default:
       break;
   }
  return FALSE;
}
static GtkItemFactory *make_item_factory(GtkWidget *console)
{
  GtkItemFactoryEntry menu_items[] =
  {
    #if 0
    {"/File", NULL, NULL, 0, "<Branch>"},
    {"/File/Shutdown client", 0, menu_cb, 105, NULL},
    #endif
    {"/SkriptX", 0, 0, 0, "<Branch>"},	/* 400 */
    
  };
  GtkItemFactory *ifactory;

  ifactory = gtk_item_factory_new(GTK_TYPE_MENU,
    "<main>", 0);
  gtk_item_factory_create_items(ifactory,
                         sizeof(menu_items) / sizeof(menu_items[0]),
                                menu_items, NULL);
  gtk_object_set_data(GTK_OBJECT(console), "pup", ifactory);
  return ifactory;
}

SPX_main_window *create_control_window(void)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *toolbar;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *scrolledwindow;
  GtkWidget *wid;
  GtkWidget *ev_box;
  SPX_main_window *mw;
  GtkItemFactory *ifactory;

  if (main_window)
    return NULL;
  tooltips = gtk_tooltips_new();
  initialize_user_pup();

  mw = calloc(1, sizeof(SPX_main_window));
  mw->main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(mw->main_window, 565, 250);
  gtk_window_set_title(GTK_WINDOW(mw->main_window),
                       sula_NAME " " sula_VERSION ": Console");
  gtk_signal_connect(GTK_OBJECT(mw->main_window), "destroy",
                     GTK_SIGNAL_FUNC(gtk_exit), NULL);
  gtk_widget_set_name(mw->main_window, "console");
  gtk_window_set_policy(GTK_WINDOW(mw->main_window), TRUE, TRUE, FALSE);
  gtk_signal_connect(GTK_OBJECT(mw->main_window),
                     "event",
                     GTK_SIGNAL_FUNC(main_window_raw_cb),
                     NULL);
  gtk_container_border_width(GTK_CONTAINER(mw->main_window), 1);
  ifactory = make_item_factory(mw->main_window);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(mw->main_window), vbox);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
  //gtk_container_add(GTK_CONTAINER(mw->main_window), hbox);

  toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show(toolbar);
  gtk_box_pack_start(GTK_BOX(hbox), toolbar, FALSE, FALSE, 2);

  tmp_toolbar_icon = create_pixmap_from_data(mw->main_window, server2_xpm);
  mw->servers = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_tooltips_set_tip(tooltips, wid, "server tool", NULL);
  gtk_widget_show(wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 1);

  tmp_toolbar_icon = create_pixmap_from_data(mw->main_window, win2_xpm);
  mw->newwin = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_tooltips_set_tip(tooltips, wid, "new channel window", NULL);
  gtk_widget_show(wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 2);

  tmp_toolbar_icon = create_pixmap_from_data(mw->main_window, editor2_xpm);
  mw->editor = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_tooltips_set_tip(tooltips, wid, "code editor", NULL);
  gtk_widget_show(wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 3);

  tmp_toolbar_icon = create_pixmap_from_data(mw->main_window, script2_xpm);
  mw->script = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_tooltips_set_tip(tooltips, wid, "Hooks / named conections", NULL);
  gtk_widget_show(wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 4);

  tmp_toolbar_icon = create_pixmap_from_data(mw->main_window, setup2_xpm);
  mw->setup = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                0, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_tooltips_set_tip(tooltips, wid, "SET tool", 0);
  gtk_widget_show(wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 5);

  tmp_toolbar_icon = create_pixmap_from_data(mw->main_window, userguide2_xpm);
  mw->uguide = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_tooltips_set_tip(tooltips, wid, "user guide", 0);
  gtk_widget_show(wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 6);

  tmp_toolbar_icon = create_pixmap_from_data(mw->main_window, exit2_xpm);
  mw->quit = wid =
     gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                NULL,
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_tooltips_set_tip(tooltips, wid, "shutdown client", NULL);
  gtk_widget_show(wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 7);

  ev_box = gtk_event_box_new();
  gtk_box_pack_end(GTK_BOX(hbox), ev_box, FALSE, FALSE, 2);
  gtk_widget_show(ev_box);
  gtk_object_set_data(GTK_OBJECT(mw->main_window),"cl", ev_box);
  mw->clock = wid = gtk_label_new("");
  gtk_container_add(GTK_CONTAINER(ev_box), wid);
  gtk_widget_show(wid);
  
  wid = create_pixmap_from_data(mw->main_window, spx2_mini_xpm);
  gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_widget_show(wid);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_object_set_data(GTK_OBJECT(mw->main_window), "sw", scrolledwindow);

  gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                 GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  
  mw->main_input =  gtk_entry_new();
  mw->browser = gtk_text_new(NULL, NULL);
  gtk_widget_show(mw->browser);
  gtk_text_set_word_wrap(GTK_TEXT(mw->browser), TRUE);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), mw->browser);
  gtk_signal_connect_object(GTK_OBJECT(mw->browser),
                            "button_release_event",
                            GTK_SIGNAL_FUNC(set_entry_focus),
                            GTK_OBJECT(mw->main_input));
  gtk_object_set_user_data(GTK_OBJECT(mw->browser), (gpointer) (-1));
  gtk_signal_connect(GTK_OBJECT(mw->browser),
                       "event",    //"button_press_event",
                        GTK_SIGNAL_FUNC(browser_raw_cb),
                       (gpointer) ifactory);
  hbox = gtk_hbox_new(FALSE, 3);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  
  mw->verbose_ret= wid = gtk_check_button_new();
  gtk_widget_set_usize(wid, 12, -1);
  SET_BUTTON(wid, sflags & s_VERBOSE_RETURN);
  gtk_tooltips_set_tip(tooltips, wid, "verbose return", NULL);
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "toggled",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 8);
  gtk_signal_connect_object(GTK_OBJECT(wid),
                            "button_release_event",
                            GTK_SIGNAL_FUNC(set_entry_focus),
                            GTK_OBJECT(mw->main_input));
  gtk_widget_show(wid);
  wid= mw->main_input;
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(hbox), wid, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "activate",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 0);
  gtk_widget_grab_focus(wid);

  mw->FwdHist = wid = gtk_button_new();
  gtk_object_set_user_data(GTK_OBJECT(wid), mainhistCur);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 30);
  gtk_widget_hide(wid);
  mw->HistRew = wid = gtk_button_new();
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(main_cb),
                     (gpointer) 31);
  gtk_widget_hide(wid);
  return mw;
}

static gint editor_raw_cb(GtkWidget * editor,
                          GdkEventKey * event,
                          gpointer junk)
{
  if (event->type == GDK_KEY_PRESS)
  {
    switch (event->keyval)
     {
       case GDK_F1:
         {
           GtkWidget *wid = gtk_object_get_data(GTK_OBJECT(editor), "F1");

           TRIGGER_OBJECT(wid);
           return TRUE;
         }
       case GDK_F2:
         {
           GtkWidget *wid = gtk_object_get_data(GTK_OBJECT(editor), "F2");

           TRIGGER_OBJECT(wid);
           return TRUE;
         }
     }
  }
  return FALSE;
}

GtkWidget *create_editor(void)
{
  GtkWidget *editor;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *wid,
      *text;
  GtkWidget *hbuttonbox,
      *scrolledwindow;
  
  editor = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(editor, 468, 350);
  gtk_window_set_title(GTK_WINDOW(editor), sula_NAME ": Code editor");
  gtk_window_set_policy(GTK_WINDOW(editor), FALSE, TRUE, FALSE);
  gtk_widget_set_name(editor, "code editor");
  gtk_signal_connect(GTK_OBJECT(editor), "delete_event",
                     GTK_SIGNAL_FUNC(dont_close),
                     NULL);
  gtk_signal_connect(GTK_OBJECT(editor), "event",
                     GTK_SIGNAL_FUNC(editor_raw_cb),
                     NULL);

  frame = gtk_frame_new(NULL);
  gtk_widget_show(frame);
  gtk_container_add(GTK_CONTAINER(editor), frame);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(frame), vbox);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_border_width(GTK_CONTAINER(scrolledwindow), 2);

  text = wid = gtk_text_new(NULL, NULL);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
  gtk_text_set_editable(GTK_TEXT(wid), TRUE);
  gtk_text_set_word_wrap(GTK_TEXT(wid), TRUE);
  gtk_widget_realize(wid);
  gtk_widget_grab_focus(wid);

  hbuttonbox = gtk_hbutton_box_new();
  gtk_widget_show(hbuttonbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbuttonbox, FALSE, TRUE, 0);
  gtk_container_border_width(GTK_CONTAINER(hbuttonbox), 3);

  wid = gtk_button_new_with_label("F1 Execute");
  gtk_tooltips_set_tip(tooltips, wid, "parse code", 0);
  gtk_object_set_user_data(GTK_OBJECT(wid), text);
  gtk_object_set_data(GTK_OBJECT(editor), "F1", wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(editor_cb),
                     (gpointer) 0);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);

  wid = gtk_button_new_with_label("F2 Clear");
  gtk_tooltips_set_tip(tooltips, wid, "clear window", 0);
  gtk_object_set_user_data(GTK_OBJECT(wid), text);
  gtk_object_set_data(GTK_OBJECT(editor), "F2", wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(editor_cb),
                     (gpointer) 1);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);

  wid = gtk_button_new_with_label("Dismiss");
  gtk_tooltips_set_tip(tooltips, wid, "hide editor", 0);
  gtk_object_set_user_data(GTK_OBJECT(wid), editor);
  gtk_signal_connect_object(GTK_OBJECT(wid), "clicked",
                      GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(editor));
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);

  wid = gtk_button_new_with_label("Save");
  gtk_tooltips_set_tip(tooltips, wid, "save to file", 0);
  gtk_object_set_user_data(GTK_OBJECT(wid), text);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(editor_cb),
                     (gpointer) 3);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);

  wid = gtk_button_new_with_label("Load");
  gtk_tooltips_set_tip(tooltips, wid, "insert file", 0);
  gtk_object_set_user_data(GTK_OBJECT(wid), text);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(editor_cb),
                     (gpointer) 4);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);

  return editor;
}


static gint form_reset2(GtkWidget * wid, gpointer form)
{
  //(GtkWidget *)form = NULL;
  free(setup_tool);
  setup_tool = NULL;
  return FALSE;
}

extern void set_cb(SPX_OBJ(ob), SPX_DATA(data));
extern void selection_made(GtkWidget *, gint, gint, GdkEventButton *,
                           gpointer);
Setup_tool *create_setup_tool(void)
{
  GtkWidget *vbox0;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *scrolledwindow;
  GtkObject *wid_adj;
  GtkWidget *wid;
  char *titles[] = {"Variable", "Current value"};

  if (setup_tool)
  {
    if (GTK_WIDGET_VISIBLE(setup_tool->setup))
      gtk_widget_hide(setup_tool->setup);
    else
      gtk_widget_show(setup_tool->setup);
    return NULL;
  }
  setup_tool = calloc(1, sizeof(Setup_tool));
  setup_tool->setup = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(setup_tool->setup, 450, 350);
  gtk_window_set_title(GTK_WINDOW(setup_tool->setup),
                       sula_NAME " :Setup options [test]");
  gtk_window_set_policy(GTK_WINDOW(setup_tool->setup), TRUE, TRUE, FALSE);
  gtk_signal_connect(GTK_OBJECT(setup_tool->setup), "destroy",
                     GTK_SIGNAL_FUNC(form_reset2),
                     NULL);
  gtk_widget_set_name(setup_tool->setup, "setup tool");

  vbox0 = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox0);
  gtk_container_add(GTK_CONTAINER(setup_tool->setup), vbox0);

  setup_tool->notebook = wid = gtk_notebook_new();
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox0), wid, TRUE, TRUE, 0);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  wid = gtk_label_new("String");
  gtk_widget_show(wid);
  gtk_notebook_append_page(GTK_NOTEBOOK(setup_tool->notebook), vbox, wid);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  setup_tool->s_clist = wid = gtk_clist_new_with_titles(2, titles);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
  gtk_clist_set_column_width(GTK_CLIST(wid), 0, 120);
  gtk_clist_set_column_width(GTK_CLIST(wid), 1, 400);
  gtk_clist_column_titles_show(GTK_CLIST(wid));
  gtk_signal_connect(GTK_OBJECT(wid), "select_row",
                     GTK_SIGNAL_FUNC(selection_made),
                     (gpointer) 11);

  setup_tool->s_entry = wid = gtk_entry_new();
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "activate",
                     GTK_SIGNAL_FUNC(set_cb),
                     (gpointer) 10);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox);
  wid = gtk_label_new("Flags");
  gtk_widget_show(wid);
  gtk_notebook_append_page(GTK_NOTEBOOK(setup_tool->notebook), hbox, wid);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_box_pack_start(GTK_BOX(hbox), scrolledwindow, TRUE, TRUE, 0);

  setup_tool->f_clist = wid = gtk_clist_new_with_titles(2, titles);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_clist_set_column_width(GTK_CLIST(wid), 0, 200);
  gtk_clist_column_titles_show(GTK_CLIST(wid));
  gtk_signal_connect(GTK_OBJECT(wid), "select_row",
                     GTK_SIGNAL_FUNC(selection_made),
                     (gpointer) 21);

  setup_tool->state = wid = gtk_check_button_new_with_label("on/off");
  gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(set_cb),
                     (gpointer) 20);

  gtk_widget_show(wid);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  wid = gtk_label_new("Numeric");
  gtk_widget_show(wid);
  gtk_notebook_append_page(GTK_NOTEBOOK(setup_tool->notebook), vbox, wid);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  setup_tool->n_clist = wid = gtk_clist_new_with_titles(2, titles);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), wid);
  gtk_clist_set_column_width(GTK_CLIST(wid), 0, 120);
  //gtk_clist_set_column_width(GTK_CLIST(setup_tool->n_clist), 1, 30);
  gtk_clist_column_titles_show(GTK_CLIST(wid));
  gtk_signal_connect(GTK_OBJECT(wid), "select_row",
                     GTK_SIGNAL_FUNC(selection_made),
                     (gpointer) 31);

  wid_adj = gtk_adjustment_new(1, 0, 4096, 1, 10, 10);
  setup_tool->n_entry = wid =
     gtk_spin_button_new(GTK_ADJUSTMENT(wid_adj), 1, 0);
  gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(wid), GTK_UPDATE_IF_VALID);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(wid), TRUE);
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(wid_adj), "value_changed",
                     GTK_SIGNAL_FUNC(set_cb),
                     (gpointer) 30);

  wid = gtk_label_new("ready");
  gtk_widget_show(wid);
  gtk_box_pack_start(GTK_BOX(vbox0), wid, FALSE, FALSE, 0);
  gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
  gtk_misc_set_padding(GTK_MISC(wid), 0, 2);

  return setup_tool;
}

