/*
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix)
*/

/* 
   gui_gtk_cb.c - callbacks for console

   Copyright (C) 1999 Tano Fotang

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free 
   Software Foundation; either version 2 of the License , or (at your option) 
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. See the file LICENCE for details.

   You should have received a copy of the GNU General Public License along
   with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


*/

#include "spx.h"
#include "gui_gtk.h"
#include "cmd.h"
#include "nicks.h"
#include "server.h"
#include "etc.h"
#include "hooks.h"
#include "config.h"

#include "network.xpm"
#include "closed.xpm"
#include "online.xpm"
#include "offline.xpm"
#include "waiting.xpm"

#include <stdio.h>
#include <gtk_tb.h>

#include "../../src/_sula-common.c"
extern GtkWidget *create_editor(void);
extern GtkWidget *create_userguide(void);
extern Script_control *create_script(void);
Setup_tool *setup_tool = NULL;
extern void do_setup(void);     /* setup tool */
static GdkPixmap *pixmap_closed, *pixmap_waiting,
   *pixmap_network, *pixmap_connected, *pixmap_disconnected;
static GdkBitmap *mask_closed, *mask_connected, *mask_waiting,

   *mask_network, *mask_disconnected;
extern void redraw_server_entry(int group);

extern int new_group(const char *name);	/*new server group! */

void main_cb(GtkWidget * widget, gpointer data)
{
  switch ((long) data)
  {
     case 0:
       main_input_cb(widget, data);
       break;
     case 30:
     case 31:
       main_History_cb(widget, data);
       break;

     case 1:
       {
         if (create_server_tool())
         {
           pixmap_closed = gdk_pixmap_colormap_create_from_xpm_d
              (NULL, gtk_widget_get_colormap(server_tool->window),
               &mask_closed, NULL, closed_xpm);
           pixmap_network =
              gdk_pixmap_colormap_create_from_xpm_d(NULL,
                                                    gtk_widget_get_colormap
                                                    (server_tool->window),
                                                    &mask_network, NULL,
                                                    network_xpm);
           pixmap_connected =
              gdk_pixmap_colormap_create_from_xpm_d(NULL,
                                                    gtk_widget_get_colormap
                                                    (server_tool->window),
                                                    &mask_connected, NULL,
                                                    online_xpm);
           pixmap_disconnected =
              gdk_pixmap_colormap_create_from_xpm_d(NULL,
                                                    gtk_widget_get_colormap
                                                    (server_tool->window),
                                                    &mask_disconnected, NULL,
                                                    offline_xpm);
           pixmap_waiting =
              gdk_pixmap_colormap_create_from_xpm_d(NULL,
                                                    gtk_widget_get_colormap
                                                    (server_tool->window),
                                                    &mask_waiting, NULL,
                                                    waiting_xpm);

           redraw_server_entry(-1);
           gtk_widget_show(server_tool->window);
         }
       }
       break;
     case 2:
       {
         Winstruct *win = new_chan_win();
         char *title = 0;

         show_chanwin(win, &title, 1, 1);
         break;
       }
     case 3:
       {
         static GtkWidget *editor = NULL;

         if (editor)
         {
           if (!GTK_WIDGET_VISIBLE(editor))
             gtk_widget_show_all(editor);
           else
             gtk_widget_hide(editor);
           return;
         }
         editor = create_editor();
         if (editor)
           gtk_widget_show_all(editor);
         break;
       }
     case 4:
       {
         Script_control *s = create_script();

         if (!s)
           break;
         list_hooks(1);
         list_hooks(0);
         gtk_widget_show(script_form->window);
       }
       break;
     case 5:
       do_setup();
       break;
     case 6:
       {
         GtkWidget *wid = create_userguide();

         if (wid)
           gtk_widget_show(wid);
       }

       break;

     case 7:
       confirm2(servFdTree ? "Quit IRC and\nShut down client?" :
                "Shut down client?", sula_NAME ": Confirm exit", 7, quit_main,
                0);
       break;
     case 8:
       if (BUTTON_IS_ON(main_window->verbose_ret))
         sflags |= s_VERBOSE_RETURN;
       else
         sflags &= ~s_VERBOSE_RETURN;
       break;
     default:
       break;
  }

}
static void load_file_into_editor(const char *fname, void *widget)
{
  if (fname && *fname)
    if (_spx_load_file(GTK_WIDGET(widget), fname, 0))
    {
      error(ERR_SYS, "Error loading \"%s\" into editor", fname);
      if (gflags & BEEP_ERR)
        spx_bell(0);
    }
}
static void save_code_to_file(const char *fname, void *widget)
{
  if (fname && *fname)
  {
    FILE *fp = fopen(fname, "w");

    if (fp == NULL)
    {
      error(ERR_SYS, "Error saving editor to \"%s\"", fname);
      if (gflags & BEEP_ERR)
        spx_bell(0);
      return;
    }
    else
    {
      gchar *buf = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);

      fputs(buf, fp);
      fclose(fp);
      free(buf);
    }
  }
}

void editor_cb(GtkWidget * widget, gpointer data)
{
  switch ((long) data)
  {
     case 0:
       {
         GtkWidget *text = gtk_object_get_user_data(GTK_OBJECT(widget));
         char *buf = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);

         gtk_widget_grab_focus(text);
         if (!*buf)
           break;
#ifdef _GUILE
         parse_scheme(buf, -1);
#else
         spx_writeln(main_window->browser, buf);
#endif
         free(buf);
         break;
       }
     case 1:
       {
         GtkWidget *text = gtk_object_get_user_data(GTK_OBJECT(widget));

         TEXT_CLEAR(text);
         gtk_widget_grab_focus(text);
         break;
       }
     case 2:
       {
         GtkWidget *wid = gtk_object_get_user_data(GTK_OBJECT(widget));

         gtk_widget_hide(wid);
         break;
       }
     case 4:
       {
         GtkWidget *text = gtk_object_get_user_data(GTK_OBJECT(widget));

         gtk_widget_grab_focus(text);
         get_filename2(sula_NAME " : Insert a file",
                       NULL, load_file_into_editor, text);
       }
       break;
     case 3:
       {
         GtkWidget *text = gtk_object_get_user_data(GTK_OBJECT(widget));

         gtk_widget_grab_focus(text);
         get_filename2(sula_NAME " : Save to file",
                       NULL, save_code_to_file, text);
       }
       break;
  }
}

static void set_cell_colour(GtkCTreeNode *node, int column, GdkColor colour)
{
GtkStyle *style;
      
      style = gtk_ctree_node_get_row_style(GTK_CTREE(server_tool->browser),
                                          node);
      if(style==NULL)
      {
        style = gtk_style_copy(server_tool->browser->style);
        if(style==NULL)
           style = gtk_style_copy(server_tool->window->style);
      }
      style->fg[GTK_STATE_NORMAL] = colour;
      gtk_ctree_node_set_cell_style(GTK_CTREE(server_tool->browser),
                                   node, column, style);

}
static void loadservers(Server * p, GtkCTreeNode * parent, int *pos)
{
  char *s[6];
  char n8[8];

  if (p)
  {
    GtkCTreeNode *sibling;

    loadservers(p->left, parent, pos);

    s[0] = p->name;
    sprintf(n8, "%hu", p->port);
    s[1] = n8;
    s[2] = p->nick;
    s[3] = aNickList[p->iNick].label ? aNickList[p->iNick].label : "?";
    s[4] = p->email;
    s[5] = p->ircname ? p->ircname : "?";
    if (p->fd < 0)
      sibling = gtk_ctree_insert_node(GTK_CTREE(server_tool->browser),
                                      parent, NULL, s, 5,
                                      pixmap_disconnected, mask_disconnected,
                                      NULL, NULL, TRUE, FALSE);
    else if (p->connecting == 1)
    {
      sibling = gtk_ctree_insert_node(GTK_CTREE(server_tool->browser),
                                      parent, NULL, s, 5,
                                      pixmap_waiting, mask_waiting,
                                      NULL, NULL, TRUE, FALSE);
      set_cell_colour(sibling, 0, SPX_MAGENTA());
    }
    else
    {
      sibling = gtk_ctree_insert_node(GTK_CTREE(server_tool->browser),
                                      parent, NULL, s, 5,
                                      pixmap_connected, mask_connected,
                                      NULL, NULL, TRUE, FALSE);
      set_cell_colour(sibling, 0, SPX_GREEN());
    }
    loadservers(p->right, parent, pos);
  }
}
static GtkCTreeNode *root = NULL;
static void make_group(int i, GtkCTreeNode * sibling, gboolean expand)
{
  if (aServerGroup[i].name)
  {
    GtkCTreeNode *parent;
    gchar *text[6];
    int count = 0;

    text[0] = aServerGroup[i].name;
    text[1] = text[2] = text[3] = text[4] = text[5] = "";

    parent = gtk_ctree_insert_node(GTK_CTREE(server_tool->browser),
                                   root, sibling, text, 5,
                                   pixmap_closed, mask_closed,
                                   pixmap_network, mask_network,
                                   FALSE, expand);
    loadservers(aServerGroup[i].s, parent, &count);
    gtk_ctree_node_set_row_data(GTK_CTREE(server_tool->browser),
                                parent, (gpointer) (1 + i));
  }
}

static GtkCTreeNode *get_entry(char **name, u_short * p, int *g)
{
  GtkCList *clist = GTK_CLIST(server_tool->browser);

  if (clist->selection && GTK_CTREE_ROW(clist->selection->data)->is_leaf)
  {
    GtkCTreeNode *node = clist->selection->data;
    GtkCTreeNode *parent = GTK_CTREE_ROW(node)->parent;
    char *group;
    char *port;

    if (g)
    {
      gtk_ctree_get_node_info(GTK_CTREE(server_tool->browser),
                              parent, &group, NULL, NULL, NULL, NULL, NULL,
                              NULL, NULL);
      *g = new_group(group);
    }
    if (name)
      *name = GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[0])->text;
    if (p)
    {
      port = GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[1])->text;
      *p = (u_short) atoi(port);
    }
    return node;
  }
  return NULL;
}

static int find_a_group(void)
{
  GtkCList *clist = GTK_CLIST(server_tool->browser);
  char *name;

  name = DEFAULT_GRP;
  if (clist->selection)
  {
    GtkCTreeNode *node = clist->selection->data;

    if (GTK_CTREE_ROW(node)->is_leaf)
      node = GTK_CTREE_ROW(node)->parent;
    if (node != root)
      name = GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[0])->text;
  }
  return new_group(name);
}
static void edit_server(int edit_entry)
{
  GtkCTreeNode *node = NULL;
  char *name;
  u_short port;
  int i;
  int g;

  if (edit_entry)
  {
    node = get_entry(&name, &port, &g);
    if (!node)
    {
      fit_object_label(server_tool->status, "Nothing to edit");
      if (gflags & BEEP_ERR)
        spx_bell(0);
      return;
    }
  }
  if (create_add_form())
  {
    GList *list = NULL;

    if (edit_entry)
    {
      Server *s;

      SET_WINDOW_TITLE(form_add_server->window,
                       sula_NAME ": Edit server entry");
      s = search_server_tree_byname(g, name, port);
      if (!s)
        fit_object_label(server_tool->status, "a bug");
      else
      {
        char tt[8];

        sprintf(tt, "%hu", port);
        spx_set_input(form_add_server->servername, s->name);
        spx_set_input(form_add_server->port, tt);
        spx_set_input(form_add_server->nick, s->nick);
        spx_set_input(form_add_server->email, s->email);
        if (s->password)
          spx_set_input(form_add_server->password, s->password);
        spx_set_input(form_add_server->ircname, s->ircname);
      }
    }
    else
    {
      g = find_a_group();
      spx_set_input(GTK_COMBO(form_add_server->group)->entry, DEFAULT_GRP);
      SET_WINDOW_TITLE(form_add_server->window,
                       sula_NAME ": Add server entry");
    }
    for (i = 0; i < iServerGroupCount; i++)
      if (aServerGroup[i].name)
        list = g_list_append(list, aServerGroup[i].name);
    if (list)
    {
      gtk_combo_set_popdown_strings(GTK_COMBO(form_add_server->group), list);
      spx_set_input(GTK_COMBO(form_add_server->group)->entry,
                    aServerGroup[g].name);
    }
    else
      gtk_list_clear_items(GTK_LIST(GTK_COMBO(form_add_server->group)->list),
                           0, -1);
    list = NULL;
    i = 0;
    while (i < iNickListCount)
    {
      if (aNickList[i].label)
        list = g_list_append(list, aNickList[i].label);
      i++;
    }
    if (list)
    {
      gtk_combo_set_popdown_strings(GTK_COMBO(form_add_server->nicklist),
                                    list);
      spx_set_input(GTK_COMBO(form_add_server->nicklist)->entry,
                    aNickList[0].label);
    }
    else
      gtk_list_clear_items(GTK_LIST
                           (GTK_COMBO(form_add_server->nicklist)->list), 0,
                           -1);
    gtk_widget_show(form_add_server->window);
  }
}

void add_server_cb(GtkWidget * wid, gpointer data)
{
  if ((long) data == 1)
    gtk_widget_destroy(form_add_server->window);
  else
  {
    Server *p, *p2;
    char *buf, no_nick_given = 0, no_name_given = 0, no_email_addr = 0;

    p = (Server *) alloca(sizeof(Server));
    buf = spx_get_input(GTK_COMBO(form_add_server->nicklist)->entry);
    if (*buf == 0 || (p->iNick = get_list_bylabel(buf)) < 0)
      p->iNick = iNickListCount > 0 ? 0 : -1;

    p->name = spx_get_input(form_add_server->servername);
    if (*p->name && isspace(*p->name))
    {
      unspace(p->name);
      spx_set_input(form_add_server->servername, p->name);
    }
    if (*p->name == 0)
    {
      spx_bell(0);
      fit_object_label(server_tool->status, "missing server name");
      return;
    }
    p->nick = spx_get_input(form_add_server->nick);
    if (*p->nick && isspace(*p->nick))
    {
      unspace(p->nick);
      spx_set_input(form_add_server->nick, p->nick);
    }
    if (*p->nick == 0)
    {
      no_nick_given = 1;
      p->nick = p->iNick > -1 ? aNickList[p->iNick].current->nick : Name;
    }
    if (p->iNick > -1)
      aNickList[p->iNick].current = add_nick_to_list(p->iNick, p->nick);
    p->email = spx_get_input(form_add_server->email);
    if (*p->email && isspace(*p->email))
    {
      unspace(p->email);
      spx_set_input(form_add_server->email, p->email);
    }
    if (!*p->email)
    {
      p->email = alloca(sizeof(char) * (strlen(Name) + strlen(host) + 3));

      sprintf(p->email, "%s@%s", Name, host);
      no_email_addr = 1;
    }
    p->ircname = (char *) spx_get_input(form_add_server->ircname);
    if (*p->ircname == 0)
    {
      p->ircname = sula_NAME " " sula_VERSION;
      no_name_given = 1;
    }
    p->password = spx_get_input(form_add_server->password);
    if (*p->password == 0)
      p->password = NULL;
    buf = (char *) spx_get_input(form_add_server->port);
    if (!*buf)
      p->port = DEFAULT_PORT;
    else
    {
      int ll = strlen(buf);
      int j;

      while ((j = atoi(buf)) > USHRT_MAX)
        *(buf + --ll) = '\0';
      if ((p->port = j) == 0)
        p->port = DEFAULT_PORT;
      spx_set_input(form_add_server->port, buf);
    }
    buf = (char *) spx_get_input(GTK_COMBO(form_add_server->group)->entry);
    if (*buf && isspace(*buf))
    {
      unspace(buf);
      spx_set_input(GTK_COMBO(form_add_server->group)->entry, buf);
    }
    p->g = new_group(*buf ? buf : DEFAULT_GRP);
    p->state = -1;
    p->fd = -1;
    p->alias = NULL;
    p->notify = NULL;
    if (search_server_tree_byname(p->g, p->name, p->port))
      if (!remove_server_from_tree(p->g, p->name, p->port))
      {
        fit_object_label(server_tool->status,
                         "Can't save changes: disconnect first");
        spx_bell(0);
        return;
      }
    insert_server(&(aServerGroup[p->g].s), p, BY_NAME);
    p2 = search_server_tree_byname(p->g, p->name, p->port);
    assert(p2);
    if (no_nick_given)
      spx_set_input(form_add_server->nick, p2->nick);
    if (no_email_addr)
      spx_set_input(form_add_server->email, p2->email);
    if (no_name_given)
      spx_set_input(form_add_server->ircname, p2->ircname);
    redraw_server_entry(p2->g);
  }
}

static void file_okay(int status, const char *fname)
{
  if(server_tool)
  {
    char *buf;

    if (status)
    {
      char *err=strerror(errno);
      
      buf = malloc(sizeof(char) * (strlen(fname) + strlen(err)+20));
      sprintf(buf, "Error: %s: %s", fname, err);
    }
    else
    {
      buf = malloc(sizeof(char) * (strlen(fname) + 20));
      sprintf(buf, "'%s': success", fname);
    }
    fit_object_label(server_tool->status, buf);
    free(buf);
  }
}

static void do_save_servers(const char *fname, void *junk)
{
  if (fname && *fname)
    file_okay(save_servers(fname), fname);
}
static void load_server_file(const char *fname, void *junk)
{
  if (fname && *fname)
    file_okay(load_serverlist(fname), fname);
}
void serverlist_cb(GtkButton * button, gpointer data)
{

  switch ((long) data)
  {
     case 0:
       {
         Server s;

         memset(&s, 0, sizeof(Server));
         if (get_entry(&s.name, &s.port, &s.g))
         {
           char *buf;
           int ret;
           buf = alloca(sizeof(char) * (strlen(s.name) + 50));

           sprintf(buf, "Connecting to %s [%hu]", s.name, s.port);
           fit_object_label(server_tool->status, buf);
           ret = connect_to_server(&s, NULL, NULL, 0);
           if (ret == -1)
           {
             sprintf(buf, "Already connected to %s [%hu]", s.name, s.port);
             fit_object_label(server_tool->status, buf);
           }
         }
         else
         {
           fit_object_label(server_tool->status, "No selection");
           if (gflags & BEEP_ERR)
             spx_bell(0);
         }
       }
       break;
     case 1:
       {
         char *servname;
         u_short port;
         int g;

         if (get_entry(&servname, &port, &g))
           close_server_connectionbyname(g, servname, port);
         else
         {
           fit_object_label(server_tool->status, "No selection");
           if (gflags & BEEP_ERR)
             spx_bell(0);
         }
       }
       break;

     case 2:
       {
         if (!form_add_server)
           edit_server(0);
         break;
       }
     case 3:
       if (!form_add_server)
         edit_server(1);
       break;
     case 4:
       {
         char *servname;
         u_short port;
         int g;
         GtkCTreeNode *node = get_entry(&servname, &port, &g);

         if (node)
         {
           if (!remove_server_from_tree(g, servname, port))
             fit_object_label(server_tool->status,
                              "Cannot remove: has window");
           else
             gtk_ctree_remove_node(GTK_CTREE(server_tool->browser), node);
           //TRIGGER_OBJECT(server_tool->update);
         }
         else
         {
           fit_object_label(server_tool->status, "Remove what?");
           if (gflags & BEEP_ERR)
             spx_bell(0);
         }
       }
       break;
     case 5:
       {
         redraw_server_entry(-1);
         break;
       }
     case 6:
     case 7:
       {
         char *buf = malloc(sizeof(char) *
                   (strlen(prog_home) + strlen(P_SERVERS) + 2));

         sprintf(buf, "%s/%s", prog_home, P_SERVERS);
         if((long)data==6)
         get_filename2(sula_NAME " : Save server list",
                       buf, do_save_servers, 0);
         else
         get_filename2(sula_NAME " : Load server list",
                       buf, load_server_file, 0);
         free(buf);
       }
       break;
     case 8:
       {
         gtk_widget_hide(server_tool->window);
         break;
       }
  }
}

void redraw_server_entry(int g)
{
  if (!server_tool)
    return;
  if (g == -1)
  {
    gchar *text[6];
    GtkStyle *style;
    int i;

    text[0] = "Networks and servers";
    text[1] = text[2] = text[3] = text[4] = text[5] = "";

    gtk_clist_freeze(GTK_CLIST(server_tool->browser));
    gtk_clist_clear(GTK_CLIST(server_tool->browser));
    root = gtk_ctree_insert_node(GTK_CTREE(server_tool->browser),
                                 NULL, NULL, text, 5,
                                 pixmap_closed, mask_closed,
                                 pixmap_network, mask_network, FALSE, TRUE);
    style = gtk_style_copy(server_tool->browser->style);
    gdk_font_unref(style->font);
    style->font = spx_idx2font(STYLE_BOLD);
    gtk_ctree_node_set_row_style(GTK_CTREE(server_tool->browser),
                                 root, style);
    for (i = 0; i < iServerGroupCount; i++)
      make_group(i, NULL, FALSE);
    gtk_clist_thaw(GTK_CLIST(server_tool->browser));
  }
  else if (VALID_GROUP(g))
  {
    GtkCTreeNode *parent, *sibling=NULL;
    gboolean is_open=0;

    parent = gtk_ctree_find_by_row_data(GTK_CTREE(server_tool->browser),
                                        root, (gpointer) (g + 1));
    assert(parent != root);
    gtk_clist_freeze(GTK_CLIST(server_tool->browser));
    if(parent)
    {
      sibling = GTK_CTREE_ROW(parent)->sibling;
      is_open = GTK_CTREE_ROW(parent)->expanded;
      gtk_ctree_remove_node(GTK_CTREE(server_tool->browser), parent);
    }
    make_group(g, sibling, is_open);
    gtk_clist_thaw(GTK_CLIST(server_tool->browser));
  }
}

