/*
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix)
*/
/*
  filename, colourname and fontname selection dialogs
  Copyright (C) 1999 Tano Fotang

  This is distributed under the GNU General Public License,
  either version 2, or any later version. The license is included
  herein by reference.

  fotang@yahoo.com, Jul99
*/

#include <gtk/gtk.h>
#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include <math.h>
#include "selection_dialog.h"
#include <string.h>


        /*
           void get_colourname(const char *title,
                        const char *deflt,
                        void (*cb) (const char *, void *),
                        void *user_data,
                        void *data2);
           void get_filename(ditto)
           void get_fontname(ditto)

           title: title of the selection dialog
           default: default value
           cb:
               a function to call with the result. prototype:
               void cb(const char *name, void *user_data);

           user_data:
                data to pass to cb.
           data2:
                 a pointer to malloc'ed integer space.
              cb will only be called if *data2 > 0.
              after cb has been called the follwoing happens:
              
              *data2 is reduced by 1 if it *data2 > 0 (always true here).
              
              If *data<0, 1 is added to it. If *data2
              is then == 0, data2 is free'd.
              See reset_r() below.

         */

static gint reset_r(GtkWidget * wid, gpointer r)
{
  if (*((int *) r) > 0)
  {
    (*((int *) r))--;
  }
  else if (*((int *) r) < 0)
  {
    (*((int *) r))++;
    if (*((int *) r) == 0)
      free((int *) r);
  }
  return FALSE;
}

static void col_sel_cb(GtkWidget * wid, gpointer r)
{
  GtkWidget *cs = gtk_object_get_data(GTK_OBJECT(wid), "s");

  if (*((int *) r) > 0)
  {
    void (*cb) (const char *, void *);
    void *arg;
    GtkColorSelection *colorsel;
    gdouble colour[3];
    char *buf=calloc(64, sizeof(char));/* you must allocate! */
    char *p;

    colorsel = GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(cs)->colorsel);
    gtk_color_selection_get_color(colorsel, colour);
    strcpy(buf, "rgb:");
    p=buf+4;
    sprintf(p, "%x", (int)(65535*colour[0]));
    while(*p) p++;
    *p++='/';
    sprintf(p, "%x", (int)(65535*colour[1]));
    while(*p) p++;
    *p++='/';
    sprintf(p, "%x", (int)(65535*colour[2]));
    cb = gtk_object_get_user_data(GTK_OBJECT(wid));
    arg = gtk_object_get_data(GTK_OBJECT(wid), "e");
    (*cb) (buf, arg);
    free(buf);
  }
  gtk_widget_destroy(cs);
}

void get_colourname(const char *title, const char *deflt,
                    void (*cb) (const char *, void *),
                    void *arg, void *remind)
{
  GtkWidget *colourw;

  colourw = gtk_color_selection_dialog_new(title);
  gtk_signal_connect(GTK_OBJECT(colourw), "destroy",
                     GTK_SIGNAL_FUNC(reset_r),
                     (gpointer) remind);
  (*((int *) remind))++;
  gtk_color_selection_set_update_policy(
         GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(colourw)->colorsel),
                                         GTK_UPDATE_CONTINUOUS);

  gtk_window_set_position(GTK_WINDOW(colourw), GTK_WIN_POS_MOUSE);

  gtk_object_set_user_data(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colourw)->ok_button),
                           cb);
  gtk_object_set_data(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colourw)->ok_button),
                      "e", arg);
  gtk_object_set_data(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colourw)->ok_button),
                      "s", colourw);
  if (deflt)
  {
    
    gdouble col[3];
    int got_error=0;

    if(!strncasecmp(deflt, "rgbi:", 5))
    {
       got_error=(sscanf(deflt+5,"%lf/%lf/%lf",
        &(col[0]), &(col[1]), &(col[2]))!=3);
    }
    else{
      GdkColor c;
      got_error=(gdk_color_parse(deflt, &c)==0);
      if(!got_error){
      col[0] = c.red / 65535.0;
      col[1] = c.green / 65535.0;
      col[2] = c.blue / 65535.0;
      }
    }
    if(!got_error)
      gtk_color_selection_set_color(
         GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(colourw)->colorsel),
                                     col);
  }

  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colourw)->ok_button),
                     "clicked",
                     GTK_SIGNAL_FUNC(col_sel_cb), (gpointer) remind);
  gtk_signal_connect_object(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colourw)->cancel_button),
                            "clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(colourw));

  gtk_widget_show(colourw);
}
static void font_sel_cb(GtkWidget * wid, gpointer r)
{
  GtkWidget *fs = gtk_object_get_data(GTK_OBJECT(wid), "s");

  if (*((int *) r) > 0)
  {
    gchar *fn = gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(fs));
    void (*cb) (const char *, void *);
    void *arg;

    cb = gtk_object_get_user_data(GTK_OBJECT(wid));
    arg = gtk_object_get_data(GTK_OBJECT(wid), "e");
    assert(cb);
    (*cb) (fn, arg);
    free(fn);
  }
  gtk_widget_destroy(fs);
}
void get_fontname(const char *title, const char *deflt,
                  void (*cb) (const char *, void *),
                  void *arg,
                  void *remind)
{
  GtkWidget *fontw;

  fontw = gtk_font_selection_dialog_new(title);
  gtk_signal_connect(GTK_OBJECT(fontw), "destroy",
                     GTK_SIGNAL_FUNC(reset_r),
                     (gpointer) remind);
  (*((int *) remind))++;
  gtk_window_set_position(GTK_WINDOW(fontw), GTK_WIN_POS_MOUSE);
  gtk_object_set_user_data(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontw)->ok_button),
                           cb);
  gtk_object_set_data(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontw)->ok_button),
                      "e", arg);
  gtk_object_set_data(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontw)->ok_button),
                      "s", fontw);
  gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontw)->ok_button),
                     "clicked",
                     GTK_SIGNAL_FUNC(font_sel_cb), (gpointer) remind);
  gtk_signal_connect_object(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontw)->cancel_button),
                            "clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(fontw));
  if (deflt)
    gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(fontw),
                                            deflt);
  gtk_widget_show(fontw);
}

static void file_sel_cb2(GtkWidget * wid, gpointer r)
{
  GtkWidget *fs = gtk_object_get_data(GTK_OBJECT(wid), "s");

  if (*((int *) r) > 0)
  {

    char *fn = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
    void (*cb) (const char *, void *);
    void *arg;

    cb = gtk_object_get_user_data(GTK_OBJECT(wid));
    arg = gtk_object_get_data(GTK_OBJECT(wid), "e");
    (*cb) (fn, arg);
  }
  gtk_widget_destroy(fs);
}

void get_filename(const char *title, const char *deflt,
                  void (*cb) (const char *, void *),
                  void *arg,
                  void *remind)
{
  GtkWidget *filew;

  filew = gtk_file_selection_new(title);
  gtk_signal_connect(GTK_OBJECT(filew), "destroy",
                     GTK_SIGNAL_FUNC(reset_r),
                     (gpointer) remind);
  (*((int *) remind))++;
  gtk_window_set_position(GTK_WINDOW(filew), GTK_WIN_POS_MOUSE);
  gtk_object_set_user_data(GTK_OBJECT(GTK_FILE_SELECTION(filew)->ok_button),
                           cb);
  gtk_object_set_data(GTK_OBJECT(GTK_FILE_SELECTION(filew)->ok_button),
                      "e", arg);
  gtk_object_set_data(GTK_OBJECT(GTK_FILE_SELECTION(filew)->ok_button),
                      "s", filew);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filew)->ok_button),
                     "clicked",
                     GTK_SIGNAL_FUNC(file_sel_cb2), (gpointer) remind);
  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(filew)->cancel_button),
                            "clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(filew));
  if (deflt)
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(filew), deflt);
  gtk_widget_show(filew);
}

