/*
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix)
*/
#if _GUILE
/*
1. Beware of memory leaks.
2. Keep small and simple.

This is free software. See the GNU GPL version 2+ for
distribution and modification conditions.

Tano Fotang, fotang@yahoo.com.
8/1999.
*/
#include "spx.h"
#include "selection_dialog.h"
#include "cmd.h"
#include "skriptx.h"
#include "spx_people.xpm"
long sx_submit_data = -1;
Win_pup *win_pup = NULL;
int win_pup_count = 0;

#define WIN_PUP_ALLOC 10
#define _SKX_ITEM "wp"
typedef struct
{
  int flag;
#define is_FREE       (1<<0)
#define is_TEXT       (1<<1)
#define is_CLIST      (1<<2)
  GtkWidget *text;
  char *title;
  int ncol;                     //no. of columns for CLIST*/
  int proc;                     /* cancel button */
  char *cancel_label;
  int nparams;                  /* number of parameters */
  _Param *param;                /* array of size nparams */
}
UserText;
static UserText *usertext = NULL;
static int usertext_count = 0;
static void do_win_pup(Win_pup * wp, void *data, char *path);

#define USERTEXT_ALLOC 5
extern int set_bg_pixamp(GtkWidget * wid, const char *pix);
extern int set_text_colour(GtkWidget * wid, const char *, int bg);

static _Param *make_params(char **titles[], int *count, SCM params);
static void delete_param(_Param * param, int count);

#define valid_idx(_id) \
((_id)<usertext_count && (_id)>-1 && !(usertext[_id].flag&is_FREE))

#define valid_utext_idx(_id) \
((_id)<usertext_count && (_id)>-1 && (usertext[_id].flag&(is_TEXT)))

#define valid_clist_idx(_id) \
((_id)<usertext_count && (_id)>-1 && (usertext[_id].flag&(is_CLIST)))

static char **SCM_list2pchar(SCM list, int *len)
{
/* convert a SCM list into a NULL terminated array of strings.
max array length is *len, unless *len<0.
Return array length in *len */
  int i = gh_length(list);
  char **s;
  int n;

  if (*len < 0)
    *len = i;
  s = my_malloc(sizeof(char *) * (*len + 1));

  i = 0;
  while (i < *len && !gh_null_p(list))
  {
    s[i] = gh_scm2newstr(gh_car(list), &n);
    if (n == 0)
      s[i] = calloc(1, 1);
    i++;
    list = gh_cdr(list);
  }
  if (i < *len)
  {
    while (i < *len)
      s[i++] = calloc(1, 1);
  }
  s[i] = NULL;
  return s;
}
static SCM clist_selected_rows2scm_list(GtkCList * wid, int len)
{
  GList *p = GTK_CLIST(wid)->selection;
  SCM tmp_list = gh_list(SCM_UNDEFINED);

  gint row;

  while (p)
  {
    SCM tmp_list2 = gh_list(SCM_UNDEFINED);
    int j;

    row = GPOINTER_TO_INT(p->data);
    for (j = 0; j < len; j++)
    {
      char *s;

      gtk_clist_get_text(GTK_CLIST(wid), row, j, &s);
      tmp_list2 = gh_cons(gh_str02scm(s), tmp_list2);
    }
    tmp_list = gh_cons(gh_reverse(tmp_list2), tmp_list);
    p = p->next;
  }
  return gh_null_p(tmp_list) ? tmp_list : gh_reverse(tmp_list);
}
static SCM clist_get_selected_rows(GtkCList * wid)
{
  GList *p = GTK_CLIST(wid)->selection;
  SCM tmp_list = gh_list(SCM_UNDEFINED);
  int row;

  while (p)
  {
    row = GPOINTER_TO_INT(p->data);
    tmp_list = gh_cons(gh_int2scm(row), tmp_list);
    p = p->next;
  }
  return gh_reverse(tmp_list);
}

static void usertext_alloc()
{
  int i;

  if (usertext == NULL)
    usertext = my_malloc(sizeof(UserText) * USERTEXT_ALLOC);
  else
    usertext =
       my_realloc(usertext,
                  (usertext_count + USERTEXT_ALLOC) * sizeof(UserText));
  for (i = usertext_count; i < usertext_count + USERTEXT_ALLOC; i++)
    usertext[i].flag = is_FREE;
  usertext_count += USERTEXT_ALLOC;
}

static SCM gs_sx_text_retrieve(SCM _i)
{
  int i = gh_scm2long(_i);
  SCM res;
  char *buf = NULL;

  if (valid_utext_idx(i))
    buf = gtk_editable_get_chars(GTK_EDITABLE(usertext[i].text), 0, -1);
  res = gh_str02scm(buf);
  free(buf);
  return res;
}

static SCM sx_clist_get_selection(SCM _i, SCM row_number)
{
  int i = gh_scm2long(_i);

  if (valid_clist_idx(i))
  {
    if (gh_equal_p(SCM_BOOL_T, row_number))
      return clist_get_selected_rows(GTK_CLIST(usertext[i].text));
    else
      return clist_selected_rows2scm_list(GTK_CLIST(usertext[i].text),
                                          usertext[i].ncol);
  }
  return SCM_BOOL_F;
}
static SCM sx_userwin_set_attr(SCM _i, SCM what, SCM _str)
{
  int i = gh_scm2long(_i);

  if (valid_idx(i))
  {
    int n;
    int res = 0;
    char *val = NULL;
    GtkWidget *wid;
    char *attr = gh_scm2newstr(what, &n);

    val = gh_scm2newstr(_str, &n);
    if (!strcmp(attr, "label"))
    {
      wid = gtk_object_get_data(GTK_OBJECT(usertext[i].text), "label");
      fit_object_label(wid, val);
      gtk_widget_show(wid);
    }
    else if (!strcmp(attr, "title"))
    {
      wid = gtk_object_get_data(GTK_OBJECT(usertext[i].text), "window");
      SET_WINDOW_TITLE(wid, val);
      if (usertext[i].title)
        free(usertext[i].title);
      usertext[i].title = strdup(val);
    }
    else if (!strcmp(attr, "bg-pixmap"))
      res = set_bg_pixamp(usertext[i].text, val);
    else if (valid_utext_idx(i) && !strcmp(attr, "bg-colour"))
      res = set_text_colour(usertext[i].text, val, 1);
    else if (valid_utext_idx(i) && !strcmp(attr, "fg-colour"))
      res = set_text_colour(usertext[i].text, val, 0);
    else
      res = 1;
    free(attr);
    if (n)
      free(val);
    return res ? SCM_BOOL_F : SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}
static GtkStyle *make_style(int i, int row, int column, SCM value, int is_row)
{
  int n;
  int bg, fg;
  GdkFont *font;
  GtkStyle *style = NULL, *cst = 0;
  char *str;

  if (!valid_clist_idx(i))
    return NULL;
  str = gh_scm2newstr(value, &n);
  if (n == 0)
    return NULL;
  spx_str2col_font(str, &bg, &fg, &font);
  if (is_row)
    cst = gtk_clist_get_row_style(GTK_CLIST(usertext[i].text), row);
  else
  {
    cst = gtk_clist_get_cell_style(GTK_CLIST(usertext[i].text), row, column);
    if (!cst)
      cst = gtk_clist_get_row_style(GTK_CLIST(usertext[i].text), row);
  }
  if (cst)
    style = gtk_style_copy(cst);
  else
    style = gtk_style_copy(GTK_WIDGET(usertext[i].text)->style);
  if (font)
  {
    gdk_font_unref(style->font);
    style->font = font;
  }
  if (bg > -1)
    style->base[GTK_STATE_NORMAL] = spx_get_colour(bg);
  if (fg > -1)
    style->fg[GTK_STATE_NORMAL] = spx_get_colour(fg);
  return style;
}
static SCM sx_clist_set_cell_style(SCM _i, SCM _row, SCM _column, SCM value)
{

  int row = gh_scm2long(_row);
  int column = gh_scm2long(_column);
  int i = gh_scm2long(_i);
  GtkStyle *style = make_style(i, row, column, value, 0);

  if (style)
  {
    gtk_clist_set_cell_style(GTK_CLIST(usertext[i].text), row, column, style);
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}
static SCM sx_clist_set_row_style(SCM _i, SCM _row, SCM value)
{

  int row = gh_scm2long(_row);
  int i = gh_scm2long(_i);
  GtkStyle *style = make_style(i, row, 0, value, 1);

  if (style)
  {
    gtk_clist_set_row_style(GTK_CLIST(usertext[i].text), row, style);
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}

static SCM gs_sx_clist_set_title(SCM _i, SCM _col, SCM _str)
{
  int i = gh_scm2long(_i);

  if (valid_clist_idx(i))
  {
    int col = gh_scm2long(_col);
    int n;
    char *lab = gh_scm2newstr(_str, &n);

    gtk_clist_set_column_title(GTK_CLIST(usertext[i].text), col, lab);
    free(lab);
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}
static SCM sx_set_column_width(SCM _i, SCM _col, SCM _width)
{
  int i = gh_scm2long(_i);

  if (valid_clist_idx(i))
  {
    int col = gh_scm2long(_col);
    int width = gh_scm2long(_width);

    if (width < 0)
      gtk_clist_set_column_auto_resize(GTK_CLIST(usertext[i].text), col,
                                       TRUE);
    else
      gtk_clist_set_column_width(GTK_CLIST(usertext[i].text), col, width);
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}

static SCM gs_sx_clist_hide_titles(SCM _i, SCM yes)
{
  int i = gh_scm2long(_i);

  if (valid_clist_idx(i))
  {
    if (gh_equal_p(yes, SCM_BOOL_T))
      gtk_clist_column_titles_hide(GTK_CLIST(usertext[i].text));
    else
    {
      gtk_clist_column_titles_show(GTK_CLIST(usertext[i].text));
      //gtk_clist_column_titles_passive(GTK_CLIST(usertext[i].text));
    }
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}

static void delete_seleted(GtkCList * clist)
{
  GList *p = clist->selection;

  while (p)
  {
    gint row = GPOINTER_TO_INT(p->data);

    gtk_clist_remove(clist, row);
    p = clist->selection;
  }

}

static SCM gs_sx_clist_delete_rows(SCM _i, SCM rows)
{
  int i = gh_scm2long(_i);

  if (valid_clist_idx(i))
  {
    if (gh_null_p(rows))
      delete_seleted(GTK_CLIST(usertext[i].text));
    else
      while (!gh_null_p(rows))
      {
        int row = gh_scm2int(gh_car(rows));

        gtk_clist_remove(GTK_CLIST(usertext[i].text), row);
        rows = gh_cdr(rows);
      }
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}

static SCM sx_userwin_add_line(SCM _i, SCM _line, SCM _istext)
{
  int i = gh_scm2long(_i);

  int istext = gh_equal_p(SCM_BOOL_T, _istext);

  if (istext && valid_utext_idx(i))
  {
    int n;
    char *s = gh_scm2newstr(_line, &n);

    spx_write(usertext[i].text, s);
    free(s);
    return SCM_BOOL_T;
  }
  else if (!istext && valid_clist_idx(i))
  {
    SCM list = _line;

    while (!gh_null_p(list))
    {
      int n = usertext[i].ncol;
      char **s = SCM_list2pchar(gh_car(list), &n);

      list = gh_cdr(list);
      gtk_clist_append(GTK_CLIST(usertext[i].text), s);
      while (*s)
        free(*s++);
    }
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}
static SCM gs_sx_text_add_file(SCM _i, SCM _str)
{
  int i = gh_scm2long(_i);

  if (valid_utext_idx(i))
  {
    int n;
    char *s = gh_scm2newstr(_str, &n);

    n = spx_load_file(usertext[i].text, s);
    free(s);
    return n ? SCM_BOOL_F : SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}

static SCM sx_userwin_destroy(SCM _i)
{
  int i = gh_scm2long(_i);

  if (valid_idx(i))
  {
    GtkWidget *butn =

       gtk_object_get_data(GTK_OBJECT(usertext[i].text), "done");

    TRIGGER_OBJECT(butn);
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}
static SCM gs_sx_userwin_clear(SCM _i)
{
  int i = gh_scm2long(_i);

  if (!valid_idx(i))
    return SCM_BOOL_F;
  if (valid_utext_idx(i))
  {
    TEXT_CLEAR(usertext[i].text);
    return SCM_BOOL_T;
  }
  else if (valid_clist_idx(i))
  {
    gtk_clist_clear(GTK_CLIST(usertext[i].text));
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}
static gint usertext_destroy(GtkWidget * wid, gpointer n)
{
  int i = (int) n;

  if (valid_idx(i))
  {
    usertext[i].flag = is_FREE;
    if (usertext[i].cancel_label)
      free(usertext[i].cancel_label);
    if (usertext[i].title)
      free(usertext[i].title);
    delete_param(usertext[i].param, usertext[i].nparams);
    if (usertext[i].proc != -1)
    {
      Scm_cmd_arg args;

      args.func = usertext[i].proc;
      args.args = gh_list(gh_long2scm(i), SCM_UNDEFINED);
      gh_catch(SCM_BOOL_T, &call_scm_command, &args,
               (scm_catch_handler_t) & exception_handler,
               "Processing SkriptX UserText");
      remove_func(usertext[i].proc);
    }
  }
  return FALSE;
}
static void skx_text_button_cb(GtkWidget * wid, GtkWidget * dialog)
{
  int u = (int) gtk_object_get_data(GTK_OBJECT(dialog), "ut");

  //SCM *data = (SCM *) gtk_object_get_user_data(GTK_OBJECT(wid));
  int i = (int) gtk_object_get_data(GTK_OBJECT(wid), "id");

  assert(valid_idx(u));
  assert(i > -1 && usertext[u].nparams);
  if (usertext[u].param[i].val.cbs.scm != -1)
  {
    Scm_cmd_arg args;
    char *s = malloc(sizeof(char) * 27);

    sprintf(s, "In cb for textbox %d", u);
    args.func = usertext[u].param[i].val.cbs.scm;
    args.args =
       gh_list(gh_long2scm(u), usertext[u].param[i].val.cbs.data,
               SCM_UNDEFINED);
    gh_catch(SCM_BOOL_T, &call_scm_command, &args,
             (scm_catch_handler_t) & exception_handler, s);
    free(s);
  }
}

static GtkWidget *create_user_win(int u, int istext, int ncols)
{
  GtkWidget *utext;
  GtkWidget *vbox;
  GtkWidget *wid, *label;
  GtkWidget *scrolledwindow;
  GtkWidget *hbuttonbox;
  UserText *ut = usertext + u;
  int i;

  utext = gtk_dialog_new();
  if (usertext[u].title == NULL)
  {
    char buf[40];

    sprintf(buf, "[%d] SkriptX %s TextBox", u, istext ? "Text" : "Clist");
    gtk_window_set_title(GTK_WINDOW(utext), buf);
  }
  else
    gtk_window_set_title(GTK_WINDOW(utext), usertext[u].title);
  gtk_window_set_policy(GTK_WINDOW(utext), TRUE, TRUE, FALSE);
  gtk_signal_connect(GTK_OBJECT(utext), "destroy",
                     GTK_SIGNAL_FUNC(usertext_destroy), (gpointer) u);
  gtk_object_set_data(GTK_OBJECT(utext), "ut", (gpointer) u);
  gtk_widget_set_name(utext, "SkriptX dialog");

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(utext)->vbox), vbox, TRUE, TRUE, 0);

  label = gtk_label_new("");
  gtk_widget_hide(label);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  if (istext)
    ut->text = gtk_text_new(NULL, NULL);
  else
  {
    ut->text = gtk_clist_new(ncols);
    //gtk_clist_column_titles_passive(GTK_CLIST(ut->text));
  }
  gtk_object_set_data(GTK_OBJECT(ut->text), "label", label);
  gtk_object_set_data(GTK_OBJECT(ut->text), "window", utext);
  gtk_widget_show(ut->text);
  gtk_container_add(GTK_CONTAINER(scrolledwindow), ut->text);

  hbuttonbox = gtk_hbutton_box_new();
  gtk_widget_show(hbuttonbox);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(utext)->action_area),
                     hbuttonbox, TRUE, TRUE, 0);

  for (i = 0; i < usertext[u].nparams; i++)
  {
    switch (usertext[u].param[i].type)
    {
       case SX_BUTTON:
         {
           wid = gtk_button_new_with_label(usertext[u].param[i].prompt);
           gtk_object_set_data(GTK_OBJECT(wid), "id", (gpointer) i);
           gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
           gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                              GTK_SIGNAL_FUNC(skx_text_button_cb), utext);
           gtk_widget_show(wid);
           break;
         }
       case SX_PIXMAP:
         {

           wid =
              create_pixmap_from_path(utext, usertext[u].param[i].val.sval);
           if (!wid)
             wid = create_pixmap_from_data(utext, spx_people_xpm);
           gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, FALSE, 0);
           gtk_widget_show(wid);
           break;
         }
       case SX_LABEL:
         wid = gtk_label_new(usertext[u].param[i].val.sval);
         gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
         gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, FALSE, 0);
         gtk_widget_show(wid);
         break;
       case SX_BROWSE:
       case SX_FILELOAD:
         {
           GtkWidget *sw = gtk_scrolled_window_new(NULL, NULL);

           gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                          GTK_POLICY_AUTOMATIC,
                                          GTK_POLICY_AUTOMATIC);

           gtk_widget_show(sw);
           wid = gtk_text_new(NULL, NULL);
           gtk_widget_set_usize(wid, usertext[u].param[i].w,
                                usertext[u].param[i].h);
           gtk_container_add(GTK_CONTAINER(sw), wid);
           gtk_text_set_editable(GTK_TEXT(wid), FALSE);
           if (usertext[u].param[i].type == SX_BROWSE)
             spx_write(wid, usertext[u].param[i].val.sval);
           else if (spx_load_file(wid, usertext[u].param[i].val.sval))
           {
             char *buf = malloc(sizeof(char) *
                                (strlen(usertext[u].param[i].val.sval) +

                                 255));

             sprintf(buf, "@C1Error reading @b@$%s@!$@!b: @i@.%s",
                     usertext[u].param[i].val.sval, strerror(errno));
             spx_write(wid, buf);
             free(buf);
           }
           gtk_widget_show(wid);
           break;
         }

       default:
         break;
    }
  }

  wid = gtk_button_new_with_label(usertext[u].cancel_label ?
                                  usertext[u].cancel_label : "Dismiss");
  gtk_object_set_data(GTK_OBJECT(ut->text), "done", wid);
  gtk_widget_show(wid);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
  /*gtk_box_pack_start(GTK_BOX(GTK_DIALOG(utext)->action_area), wid, TRUE, TRUE,
     0); */
  gtk_signal_connect_object(GTK_OBJECT(wid), "clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(utext));
  return utext;
}

static SCM gs_sx_win_new(SCM _istext, SCM _w, SCM _h, SCM coloumns,
                         SCM mode, SCM _args)
{
  int i;
  int w = (int) gh_scm2long(_w);
  int h = (int) gh_scm2long(_h);
  SCM proc = SCM_BOOL_F;

  if (!gh_null_p(_args))
  {
    SCM val = gh_car(_args);

    if (gh_procedure_p(val) || gh_equal_p(SCM_BOOL_F, val))
    {
      proc = val;
      _args = gh_cdr(_args);
    }
  }
  if (usertext)
    usertext_alloc();
  do
  {
    for (i = 0; i < usertext_count; i++)
      if (usertext[i].flag & is_FREE)
      {
        GtkWidget *wid;
        char **s[4];

        usertext[i].flag = ~is_FREE;

        s[0] = &usertext[i].title;
        s[1] = s[2] = NULL;     /* descr and ok_label not required */
        s[3] = &usertext[i].cancel_label;
        usertext[i].param = make_params(s, &usertext[i].nparams, _args);
        if (gh_equal_p(_istext, SCM_BOOL_T))
          usertext[i].flag = is_TEXT & ~is_FREE;
        else
          usertext[i].flag = is_CLIST & ~is_FREE;
        if (gh_equal_p(_istext, SCM_BOOL_T))
          wid = create_user_win(i, 1, 0);
        else
        {
          usertext[i].ncol = (int) gh_scm2long(coloumns);
          if (usertext[i].ncol < 1)
            usertext[i].ncol = 1;
          wid = create_user_win(i, 0, usertext[i].ncol);
          gtk_clist_set_selection_mode(GTK_CLIST(usertext[i].text),
                                       !gh_equal_p(mode, SCM_BOOL_F) ?
                                       GTK_SELECTION_MULTIPLE :
                                       GTK_SELECTION_SINGLE);
        }
        usertext[i].proc = define_func(proc);
        gtk_widget_set_usize(usertext[i].text, w, h);
        gtk_widget_show(wid);
        return gh_long2scm(i);
      }
    usertext_alloc();
  }
  while (1);
  return SCM_BOOL_F;            /* not reached */
}

/*****                                ****
 *****          eof sx-tb             ****
 *****                                ****/

static void delete_param(_Param * param, int count)
{
  int i;

  if (!param)
    return;
  for (i = 0; i < count; i++)
  {
    if (param[i].prompt)
      free(param[i].prompt);
    if (param[i].prev_value)
      free(param[i].prev_value);
    switch (param[i].type)
    {
       case SX_BUTTON:
         {
           remove_func(param[i].val.cbs.scm);
           break;
         }
       case SX_STRING:
       case SX_NUMBER:
       case SX_FLOAT:
       case SX_FILE:
       case SX_FONT:
       case SX_COLOUR:
       case SX_TEXT:
       case SX_LABEL:
       case SX_PIXMAP:
       case SX_BROWSE:
       case SX_FILELOAD:
         if (param[i].val.sval)
           free(param[i].val.sval);
         break;
       case SX_SLIST:
       case SX_MLIST:
       case SX_CLIST:
         {
           char **s;

           if (param[i].type == SX_CLIST)
             s = param[i].val.clist.title;
           else
             s = param[i].val.vval;

           while (*s)
           {
             free(*s);
             s++;
           }
           break;
         }
       default:
         break;
    }
  }
  free(param);
  param = NULL;
}
static void remove_wp(Win_pup * _wp)
{
  if ((_wp)->flag & SKX_MENU)
  {
    free((_wp)->proc.sx->path);
    free((_wp)->proc.sx->cmd);
    free((_wp)->proc.sx);
  }
  else
  {
    remove_func((_wp)->proc.scm[0]);
    remove_func((_wp)->proc.scm[1]);
  }
  if ((_wp)->window_title)
    free((_wp)->window_title);
  if ((_wp)->descr)
    free((_wp)->descr);
  if (_wp->ok_label)
    free(_wp->ok_label);
  if (_wp->cancel_label)
    free(_wp->cancel_label);
  if ((_wp)->param)
    delete_param((_wp)->param, (_wp)->nparams);
  (_wp)->flag = SKX_ISFREE;
}
static void delete_win_pup(Win_pup * wp)
{
  if (wp->flag & SKX_MENU)
  {
    GtkItemFactory *factory;

    if (wp->flag & SKX_CONSOLE)
    {
      factory = gtk_object_get_data(GTK_OBJECT(main_window->main_window),
                                    "pup");
      gtk_item_factory_delete_item(factory, wp->proc.sx->path);
    }
    else
    {
      int j;

      for (j = 0; j < win_count; j++)
        if (winstruct[j].chanwin)
        {
          factory =
             gtk_object_get_data(GTK_OBJECT(winstruct[j].chanwin->chanwin),
                                 "popup");
          gtk_item_factory_delete_item(factory, wp->proc.sx->path);
        }
    }
  }
  remove_wp(wp);
}

static void clear_win_pups(int on_console)
{
  register int i;

  for (i = 0; i < win_pup_count; i++)
    if ((win_pup[i].flag & SKX_MENU) &&
        ((on_console && (win_pup[i].flag & SKX_CONSOLE)) ||
         (!on_console && (win_pup[i].flag & SKX_CONSOLE) == 0)))
    {
      delete_win_pup(&win_pup[i]);
    }
}
static void remove_pup_entry(const char *path, int on_console)
{
  int i;

  for (i = 0; i < win_pup_count; i++)
    if ((win_pup[i].flag & SKX_MENU) &&
        !strcmp(win_pup[i].proc.sx->path, path) &&
        ((on_console && (win_pup[i].flag & SKX_CONSOLE)) ||
         (!on_console && (win_pup[i].flag & SKX_CONSOLE) == 0)))
    {
      delete_win_pup(&win_pup[i]);
      return;
    }
  if (on_console)
    gtk_widget_destroy(gtk_item_factory_get_item
                       (gtk_object_get_data
                        (GTK_OBJECT(main_window->main_window), "pup"), path));
  else
    for (i = 0; i < win_count; i++)
      if (winstruct[i].chanwin)
        gtk_widget_destroy(gtk_item_factory_get_item
                           (gtk_object_get_data
                            (GTK_OBJECT(winstruct[i].chanwin->chanwin),
                             "popup"), path));
}
static SCM gs_sx_remove_path(SCM _console, SCM _path)
{
  int n;
  char *path, *path0;

  path = gh_scm2newstr(_path, &n);
  if (n == 0)
    return SCM_BOOL_F;
  path0 = malloc(sizeof(char) * (n + 20));

  n = 0;
  while (*(path + n) == '/')
    n++;
  if (*(path + n) != 0)
  {
    sprintf(path0, "/SkriptX/%s", path + n);
    remove_pup_entry(path0, gh_equal_p(_console, SCM_BOOL_T));
    return SCM_BOOL_T;
  }
  else
  {
    free(path);
    free(path0);
  }
  return SCM_BOOL_F;
}
static SCM gs_sx_clear_menu(SCM _console)
{
  clear_win_pups(gh_equal_p(_console, SCM_BOOL_T));
  return SCM_BOOL_T;
}
static void win_pup_alloc()
{
  register int i;

  if (win_pup == NULL)
    win_pup = my_malloc(sizeof(Win_pup) * WIN_PUP_ALLOC);
  else
    win_pup =
       my_realloc(win_pup, (win_pup_count + WIN_PUP_ALLOC) * sizeof(Win_pup));
  for (i = win_pup_count; i < win_pup_count + WIN_PUP_ALLOC; i++)
  {
    memset(&win_pup[i], 0, sizeof(Win_pup));
    win_pup[i].flag = SKX_ISFREE;
  }
  win_pup_count += WIN_PUP_ALLOC;
}

static void skript_menu_cb(gpointer data, guint action, GtkWidget * widget)
{
/* callback for sx-submit menu items */
  if (action == 400)
  {
    Win_pup *wp = win_pup + (int) data;
    char *path = gtk_item_factory_path_from_widget(widget);

    assert(path);
    assert(wp->flag & SKX_MENU);
    if (wp->nparams || wp->descr)
      do_win_pup(wp, 0, path);
    else
    {
      char *buf = malloc(sizeof(char) * (strlen(wp->proc.sx->cmd)
                                         + 20 + strlen(path)));

      sprintf(buf, "(%s %ld \"%s\")", wp->proc.sx->cmd, sx_submit_data, path);
      new_process_cmd(buf, sx_submit_data);
      free(buf);
    }
    return;
  }
  assert(0);
}
static void create_factory_item(int i, GtkItemFactory * factory)
{
  GtkItemFactoryEntry *f;

  f = g_malloc(sizeof(GtkItemFactoryEntry));
  f->path = win_pup[i].proc.sx->path;
  f->accelerator = 0;
  f->callback = skript_menu_cb;
  f->callback_action = 400;
  f->item_type = 0;
  gtk_item_factory_create_item(factory, f, (gpointer) i, 1);
}
static int add_win_pup(Win_pup * wp)
{
  register int i;

  if (win_pup && (wp->flag & SKX_MENU))
    for (i = 0; i < win_pup_count; i++)
      if ((win_pup[i].flag & SKX_MENU) &&
          !strcmp(win_pup[i].proc.sx->path, wp->proc.sx->path)
          &&
        ((wp->flag&SKX_CONSOLE && (win_pup[i].flag & SKX_CONSOLE)) ||
         (!(wp->flag&SKX_CONSOLE) && (win_pup[i].flag & SKX_CONSOLE) == 0)))
      {
        delete_win_pup(win_pup + i);
        break;
      }
  if (!win_pup)
    win_pup_alloc();

  do
  {
    for (i = 0; i < win_pup_count; i++)
      if (win_pup[i].flag & SKX_ISFREE)
      {
        memcpy(win_pup + i, wp, sizeof(Win_pup));
        win_pup[i].flag &= ~SKX_ISFREE;
        if (win_pup[i].flag & SKX_MENU)
        {
          if (win_pup[i].flag & SKX_CONSOLE)
          {
            create_factory_item(i,
            gtk_object_get_data(GTK_OBJECT
                                   (main_window->main_window), "pup"));
          }
          else
          {
            register int j;
            for (j = 0; j < win_count; j++)
              if (winstruct[j].chanwin)
                create_factory_item(i,
                    gtk_object_get_data ( GTK_OBJECT
                                         (winstruct[j].chanwin->chanwin),
                                                        "popup"));
          }
        }
        return i;
      }
    win_pup_alloc();
  }
  while (1);
}

static _Param *make_params(char **titles[], int *count, SCM params)
{
  int paramcount = 0;
  _Param *pars = NULL;
  char *title = 0, *descr = 0;
  char *ok_label = NULL;
  char *cancel_label = NULL;

  *count = 0;
  while (!gh_null_p(params))
  {
    int type = gh_scm2int(gh_car(params));
    int n;

    params = gh_cdr(params);
    switch (type)
    {
       case SX_OK:
       case SX_CANCEL:
       case SX_TITLE:
       case SX_DESCR:
         {
           char **v;

           if (type == SX_OK)
             v = &ok_label;
           else if (type == SX_CANCEL)
             v = &cancel_label;
           else if (type == SX_TITLE)
             v = &title;
           else
             v = &descr;
           if (*v)
             free(*v);
           *v = gh_scm2newstr(gh_car(params), &n);
           //if(n==0) let it be
           params = gh_cdr(params);
           continue;
         }
       case SX_PIXMAP:
       case SX_LABEL:
         {
           char *val = gh_scm2newstr(gh_car(params), &n);

           params = gh_cdr(params);
           if (n)
           {
             pars = my_realloc(pars, (paramcount + 1) * sizeof(_Param));
             pars[paramcount].val.sval = val;
             pars[paramcount].type = type;
             pars[paramcount].prev_value = NULL;
             pars[paramcount].prompt = NULL;
             paramcount++;
           }
           continue;
         }
       case SX_BUTTON:
         {
           _Param p;

           p.prev_value = NULL;
           p.type = type;
           if (gh_null_p(params))
           {
             delete_param(pars, paramcount);
             return NULL;
           }
           p.prompt = gh_scm2newstr(gh_car(params), &n);
           if (n == 0)
             p.prompt = NULL;
           params = gh_cdr(params);
           if (gh_null_p(params))
           {
             delete_param(pars, paramcount);
             return NULL;
           }
           p.val.cbs.scm = define_func(gh_car(params));
           params = gh_cdr(params);
           if (gh_null_p(params))
           {
             delete_param(pars, paramcount);
             return NULL;
           }
           p.val.cbs.data = gh_car(params);
           params = gh_cdr(params);
           if (gh_null_p(params))
           {
             delete_param(pars, paramcount);
             return NULL;
           }
           p.val.cbs.box = gh_scm2long(gh_car(params));
           params = gh_cdr(params);
           pars = my_realloc(pars, (paramcount + 1) * sizeof(_Param));
           memcpy(pars + paramcount, &p, sizeof(_Param));
           paramcount++;
           continue;
           break;
         }
         // case SX_BOX:
         // case SX_CLIST:
       case SX_BROWSE:
       case SX_FILELOAD:
         {
           _Param p;
           char *val = gh_scm2newstr(gh_car(params), &n);

           params = gh_cdr(params);
           if (n == 0 || gh_null_p(params))
           {
             delete_param(pars, paramcount);
             return NULL;
           }
           p.type = type;
           p.w = gh_scm2long(gh_car(params));
           params = gh_cdr(params);
           if (gh_null_p(params))
           {
             delete_param(pars, paramcount);
             return NULL;
           }
           p.h = gh_scm2long(gh_car(params));
           params = gh_cdr(params);
           p.val.sval = val;
           p.prompt = NULL;
           p.prev_value = NULL;
           pars = my_realloc(pars, (paramcount + 1) * sizeof(_Param));
           memcpy(pars + paramcount, &p, sizeof(_Param));
           paramcount++;
           continue;
         }
       default:
         {
           _Param p;
           char skip_this = 0;

           p.type = type;
           if (gh_null_p(params))
           {
             delete_param(pars, paramcount);
             return NULL;
           }
           p.prompt = gh_scm2newstr(gh_car(params), &n);
           if (n == 0)
             p.prompt = NULL;
           params = gh_cdr(params);
           if (gh_null_p(params))
           {
             delete_param(pars, paramcount);
             return NULL;
           }
           if (type == SX_TOGGLE)
             p.val.ival = gh_scm2bool(gh_car(params));
           else if (type == SX_NUMBER)
           {
             long x = gh_scm2long(gh_car(params));
             p.val.sval = malloc(20 * sizeof(char));

             snprintf(p.val.sval, 19, "%ld", x);
           }
           else if (type == SX_FLOAT)
           {
             double x = gh_scm2double(gh_car(params));
             p.val.sval = malloc(65 * sizeof(char));

             snprintf(p.val.sval, 64, "%lf", x);
           }
           else if (type == SX_STRING || type == SX_FILE || type == SX_FONT
                    || type == SX_COLOUR)
           {
             p.val.sval = gh_scm2newstr(gh_car(params), &n);
             if (n == 0)
               p.val.sval = NULL;
           }
           else if (type == SX_TEXT || type == SX_CLIST || type == SX_SLIST
                    || type == SX_MLIST)
           {
             if (type == SX_TEXT)
             {
               p.val.sval = gh_scm2newstr(gh_car(params), &n);
               if (n == 0)
                 p.val.sval = NULL;
             }
             else
             {
               int i = -1;

               if (type == SX_CLIST)
               {
                 p.val.clist.multiple =
                    !gh_equal_p(SCM_BOOL_F, gh_car(params));
                 params = gh_cdr(params);
                 if (gh_null_p(params))
                 {
                   delete_param(pars, paramcount);
                   return NULL;
                 }
                 p.val.clist.title = SCM_list2pchar(gh_car(params), &i);
                 p.val.clist.len = i;
                 if (i == 0)
                   skip_this = 1;	/* ignore this item */
                 params = gh_cdr(params);
                 if (gh_null_p(params))
                 {
                   delete_param(pars, paramcount);
                   return NULL;
                 }
                 p.val.clist.val = gh_car(params);
               }
               else
                 p.val.vval = SCM_list2pchar(gh_car(params), &i);
             }
             params = gh_cdr(params);
             if (gh_null_p(params))
             {
               delete_param(pars, paramcount);
               return NULL;
             }
             p.w = gh_scm2long(gh_car(params));
             params = gh_cdr(params);
             if (gh_null_p(params))
             {
               delete_param(pars, paramcount);
               return NULL;
             }
             p.h = gh_scm2long(gh_car(params));
           }
           else
           {
             fprintf(stderr,
                     "[%s %d] SkriptX: unknown type %d. bye.\n",
                     __FILE__, __LINE__, type);
             delete_param(pars, paramcount);
             return NULL;
           }
           params = gh_cdr(params);
           if (skip_this)
             continue;
           p.prev_value = NULL;
           pars = my_realloc(pars, (paramcount + 1) * sizeof(_Param));
           memcpy(pars + paramcount, &p, sizeof(_Param));
           paramcount++;
           break;
         }
    }
  }
  if (titles)
  {
    if (titles[0])
      *titles[0] = title ? strdup(title) : NULL;
    if (titles[1])
      *titles[1] = descr ? strdup(descr) : NULL;
    if (titles[2])
      *titles[2] = ok_label ? strdup(ok_label) : NULL;
    if (titles[3])
      *titles[3] = cancel_label ? strdup(cancel_label) : NULL;
  }
  *count = paramcount;
  return pars;
}

static int make_item(int is_menu, SCM _path, SCM _proc, SCM params,
                     int _console)
{
  Win_pup *wp = calloc(1, sizeof(Win_pup));
  int n;
  char **s[4];

  if (is_menu)
  {
    char *path;

    wp->flag = SKX_MENU;
    if (_console)
      wp->flag |= SKX_CONSOLE;
    wp->proc.sx = calloc(1, sizeof(_Misc));
    path = gh_scm2newstr(_path, &n);
    if (n == 0)
    {
      remove_wp(wp);
      return -1;
    }
    wp->proc.sx->path = malloc(sizeof(char) * (n + 20));

    n = 0;
    while (*(path + n) == '/')
      n++;
    if (*(path + n) == 0)
    {
      remove_wp(wp);
      return -1;
    }
    sprintf(wp->proc.sx->path, "/SkriptX/%s", path + n);
    free(path);
    wp->proc.sx->cmd = gh_scm2newstr(_proc, &n);
    if (n == 0)
    {
      remove_wp(wp);
      return -1;
    }
  }
  else
  {
    wp->flag = SKX_DIALOG;
    gh_defer_ints();
    wp->proc.scm[0] = define_func(_path);	/*ok */
    wp->proc.scm[1] = define_func(_proc);	/*cancel */
    gh_allow_ints();
  }
  s[0] = &wp->window_title;
  s[1] = &wp->descr;
  s[2] = &wp->ok_label;
  s[3] = &wp->cancel_label;
  wp->param = make_params(s, &wp->nparams, params);
  return (add_win_pup(wp));
}

static SCM gs_skriptx_menu(SCM _console, SCM _path, SCM _proc, SCM params)
{
  //_path and _proc must be given; params is optionalion_area), wid, TRUE, TRUE,
  int res =

     make_item(1, _path, _proc, params, gh_equal_p(_console, SCM_BOOL_T));

  return res == -1 ? SCM_BOOL_F : SCM_BOOL_T;
}
static SCM gs_skriptx_dialog(SCM _data, SCM _ok_proc, SCM _cancel_proc,
                             SCM params)
{
//_data, _proc (ok button), _proc2 (cancel button) must be given; params is optional// data will be returned in reply
  int n = make_item(0, _ok_proc, _cancel_proc, params, 0);

  if (n == -1)
    return SCM_BOOL_F;
  else
  {
    SCM *d = my_malloc(sizeof(SCM));

    memcpy(d, &_data, sizeof(SCM));
    do_win_pup(win_pup + n, d, 0);
  }
  return SCM_BOOL_T;
}

static void call_dialog_cb(Win_pup * wp, Scm_cmd_arg * args)
{
  char *s;

  if (wp->window_title)
  {
    s = my_malloc(sizeof(char) * (40 + strlen(wp->window_title)));

    sprintf(s, "In SkripX dialog [%s]", wp->window_title);
  }
  else if (wp->descr)
  {
    s = my_malloc(sizeof(char) * (40 + strlen(wp->descr)));

    sprintf(s, "In SkripX dialog [%s]", wp->descr);
  }
  else
    s = strdup("Processing SkriptX dialog");
  gh_catch(SCM_BOOL_T, &call_scm_command, args,
           (scm_catch_handler_t) & exception_handler, s);
  free(s);

}
static void escape_str(char **tmp, int *len, const char *s)
{
  char *bb = my_malloc(sizeof(char) * (2 * strlen(s) + 1));
  register char *pp = bb, *qq = (char *) s;

  while ((*pp = *qq))
  {
    if (*pp == '"')
    {
      *pp++ = '\\';
      *pp = '"';
    }
    pp++;
    qq++;
  }
  *len += strlen(bb) + 4;
  *tmp = realloc(*tmp, (sizeof(char) * *len));

  strcat(*tmp, bb);
  free(bb);
}
static void pup_dialog_cb(GtkWidget * button, GtkWidget * dialog)
{
  Win_pup *wp = win_pup + (int) gtk_object_get_data(GTK_OBJECT(dialog),

                                                    _SKX_ITEM);
  char *s;
  GtkWidget *wid;
  int i;
  char buf[10];

  if (wp->flag & SKX_MENU)
  {

    int w = (int) gtk_object_get_user_data(GTK_OBJECT(dialog));
    char *path = gtk_object_get_data(GTK_OBJECT(dialog), "path");

    char *tmp = 0;

    int len;

    len = 15 + strlen(wp->proc.sx->cmd) + strlen(path);
    tmp = malloc(sizeof(char) * len);

    sprintf(tmp, "(%s %d \"%s\" ", wp->proc.sx->cmd, w, path);
    for (i = 0; i < wp->nparams; i++)
    {
      sprintf(buf, "%d", i);
      wid = gtk_object_get_data(GTK_OBJECT(dialog), buf);
      strcat(tmp, " ");
      switch (wp->param[i].type)
      {
         case SX_STRING:
         case SX_NUMBER:
         case SX_FLOAT:
         case SX_FILE:
         case SX_FONT:
         case SX_COLOUR:
         case SX_TEXT:
           if (wp->param[i].type == SX_TEXT)
             s = gtk_editable_get_chars(GTK_EDITABLE(wid), 0, -1);
           else
             s = spx_get_input(wid);
           if ((*s == 0) && wp->param[i].type == SX_NUMBER)
             s = "0";
           if (wp->param[i].prev_value)
             free(wp->param[i].prev_value);
           wp->param[i].prev_value = strdup(s);
           if (wp->param[i].type == SX_NUMBER)
           {
             strcat(tmp, s);
             len += strlen(s) + 3;
             tmp = realloc(tmp, (sizeof(char) * len));
           }
           else
           {
             strcat(tmp, "\"");
             escape_str(&tmp, &len, s);
             strcat(tmp, "\"");
           }
           if (wp->param[i].type == SX_TEXT)
             free(s);

           break;
         case SX_TOGGLE:
           len += 3;
           tmp = realloc(tmp, (sizeof(char) * len));

           if (BUTTON_IS_ON(wid))
             strcat(tmp, "#t");
           else
             strcat(tmp, "#f");
           break;
         case SX_MLIST:
           {
             GtkObject *item;
             GList *p = GTK_LIST(wid)->selection;

             len += 3;
             tmp = realloc(tmp, (sizeof(char) * len));

             strcat(tmp, "'(");
             while (p)
             {
               item = GTK_OBJECT(p->data);
               s = gtk_object_get_user_data(item);
               strcat(tmp, "\"");
               escape_str(&tmp, &len, s);
               strcat(tmp, "\" ");
               p = p->next;
             }
             strcat(tmp, ")");
             break;
           }
           break;
         case SX_CLIST:
           {
             GList *p = GTK_CLIST(wid)->selection;

             len += 10;
             tmp = realloc(tmp, (sizeof(char) * len));

             strcat(tmp, "(list");
             while (p)
             {
               int j;
               gint row = GPOINTER_TO_INT(p->data);

               //char *s[];

               //s=malloc(sizeof(char*)*wp->param[i].val.clist.len);
               strcat(tmp, " '(");

               for (j = 0; j < wp->param[i].val.clist.len; j++)
               {
                 char *s;

                 gtk_clist_get_text(GTK_CLIST(wid), row, j, &s);
                 fputs(".", stderr);
                 len += 4;
                 strcat(tmp, "\"");
                 escape_str(&tmp, &len, s);
                 strcat(tmp, "\" ");
               }
               strcat(tmp, ")");
               p = p->next;
             }
             strcat(tmp, ")");
             break;
           }
         default:
           break;
      }
    }
    strcat(tmp, ")");
    new_process_cmd(tmp, w);
    free(tmp);
  }
  else
  {
    SCM *data = (SCM *) gtk_object_get_user_data(GTK_OBJECT(dialog));

    if (wp->proc.scm[0] != -1)
    {
      Scm_cmd_arg args;
      SCM list;
      char reverse_it = 0;

      args.func = wp->proc.scm[0];
      list = gh_list(*data, SCM_UNDEFINED);

      for (i = 0; i < wp->nparams; i++)
      {
        sprintf(buf, "%d", i);
        wid = gtk_object_get_data(GTK_OBJECT(dialog), buf);
        switch (wp->param[i].type)
        {
           case SX_STRING:
           case SX_FILE:
           case SX_FONT:
           case SX_COLOUR:
           case SX_TEXT:
             reverse_it = 1;
             if (wp->param[i].type == SX_TEXT)
               s = gtk_editable_get_chars(GTK_EDITABLE(wid), 0, -1);
             else
               s = spx_get_input(wid);
             if (wp->param[i].prev_value)
               free(wp->param[i].prev_value);
             wp->param[i].prev_value = strdup(s);
             list = gh_cons(gh_str02scm(s), list);
             if (wp->param[i].type == SX_TEXT)
               free(s);
             break;
           case SX_FLOAT:
           case SX_NUMBER:
             reverse_it = 1;
             s = spx_get_input(wid);
             if (*s == 0)
               s = "0";
             if (wp->param[i].prev_value)
               free(wp->param[i].prev_value);
             wp->param[i].prev_value = strdup(s);
             list = gh_cons(wp->param[i].type == SX_FLOAT ?
                            gh_double2scm(atof(s)) :
                            gh_long2scm(atoi(s)), list);
             break;
           case SX_TOGGLE:
             reverse_it = 1;
             list = gh_cons(gh_bool2scm(BUTTON_IS_ON(wid)), list);
             break;
           case SX_SLIST:
           case SX_MLIST:
             {
               GtkObject *item;
               GList *p = GTK_LIST(wid)->selection;
               SCM tmp_list = gh_list(SCM_UNDEFINED);

               while (p)
               {
                 item = GTK_OBJECT(p->data);
                 s = gtk_object_get_user_data(item);
                 tmp_list = gh_cons(gh_str02scm(s), tmp_list);
                 p = p->next;
               }
               list = gh_cons(gh_reverse(tmp_list), list);
               reverse_it = 1;
               break;
             }
           case SX_CLIST:
             {
               list =
                  gh_cons(clist_selected_rows2scm_list
                          (GTK_CLIST(wid), wp->param[i].val.clist.len), list);
               reverse_it = 1;
               break;
             }

           default:
             break;
        }
      }
      args.args = reverse_it ? gh_reverse(list) : list;
      call_dialog_cb(wp, &args);
    }
    free(data);
    remove_wp(wp);
  }
  gtk_widget_destroy(dialog);
}

static void winpup_insert_result(const char *name, void *entry)
{
  if (name && *name)
    spx_set_input(GTK_WIDGET(entry), name);
}
static void winpup_insert_colour_result(const char *name, void *entry)
{
  if (name && *name)
  {
    GdkColor col;

    if (gdk_color_parse(name, &col))
    {
      GtkStyle *style = gtk_style_copy(GTK_WIDGET(entry)->style);

      style->base[GTK_STATE_NORMAL] = col;
      gtk_widget_set_style(GTK_WIDGET(entry), style);
    }
    spx_set_input(GTK_WIDGET(entry), name);
  }
}
static void winput_filesel_cb(GtkWidget * butn, GtkWidget * entry)
{
  get_filename(sula_NAME ": File selection",
               spx_get_input(entry),
               winpup_insert_result,
               entry, gtk_object_get_data(GTK_OBJECT(butn), "r"));
}
static void winput_fontsel_cb(GtkWidget * butn, GtkWidget * entry)
{
  get_fontname(sula_NAME ": Choose font",
               spx_get_input(entry),
               winpup_insert_result,
               entry, gtk_object_get_data(GTK_OBJECT(butn), "r"));
}
static void winput_coloursel_cb(GtkWidget * butn, GtkWidget * entry)
{
  get_colourname(sula_NAME ": Pick colour",
                 spx_get_input(entry),
                 winpup_insert_colour_result,
                 entry, gtk_object_get_data(GTK_OBJECT(butn), "r"));
}
static gint quit_winpup(GtkWidget * wid, gpointer r)
{
  if (*((int *) r))
  {
    assert(*((int *) r) > 0);
    *((int *) r) = 0 - (*((int *) r));
  }
  else
    free((int *) r);

  return FALSE;
}
static void skx_cancel_cb(GtkWidget * wid, GtkWidget * dialog)
{
  Win_pup *wp = win_pup + (int) gtk_object_get_data(GTK_OBJECT(dialog),

                                                    _SKX_ITEM);
  SCM *data = (SCM *) gtk_object_get_user_data(GTK_OBJECT(dialog));

  assert(wp->flag & SKX_DIALOG);

  if (wp->proc.scm[1] != -1)
  {
    Scm_cmd_arg args;

    args.func = wp->proc.scm[1];
    args.args = gh_list(*data, SCM_UNDEFINED);
    call_dialog_cb(wp, &args);
  }
  free(data);

#warning FIXME: should not remove sx-dialog from within the cancel_cb. that is done here.
  remove_wp(wp);
  gtk_widget_destroy(GTK_WIDGET(dialog));
}

#define DO_SX_BUTTON 1          /* display SX_BUTTON from sx-dialog-new and in sx-submit.
                                   I dont see why anyone would want use it. */

#if DO_SX_BUTTON
static void skx_button_cb(GtkWidget * wid, GtkWidget * dialog)
{
  Win_pup *wp = win_pup + (int) gtk_object_get_data(GTK_OBJECT(dialog),
                                                    _SKX_ITEM);

  int i = (int) gtk_object_get_data(GTK_OBJECT(wid), "id");

  assert(wp->flag & SKX_DIALOG);
  assert(i > -1 && i < wp->nparams);
  if (wp->param[i].val.cbs.scm != -1)
  {
    Scm_cmd_arg args;

    args.func = wp->param[i].val.cbs.scm;
    args.args = gh_list(wp->param[i].val.cbs.data, SCM_UNDEFINED);
    call_dialog_cb(wp, &args);
  }
}
#endif
static void do_win_pup(Win_pup * wp, void *data, char *path)
{
/* 
Create sx-dialog and sx-submit items.
create a window with all the defined widgets on them */
  GtkWidget *table;
  GtkWidget *hbuttonbox;
  GtkWidget *wid;
  GtkWidget *pup_dialog;
  int i;
  char buf[10];
  int *reminder = malloc(sizeof(int));
  char is_input = 0;

  *reminder = 0;
  pup_dialog = gtk_dialog_new();

  if (wp->flag & SKX_MENU)
  {
    gtk_window_set_title(GTK_WINDOW(pup_dialog),
                         wp->window_title ? wp->window_title :
                         wp->proc.sx->path);
    gtk_window_position(GTK_WINDOW(pup_dialog), GTK_WIN_POS_MOUSE);
    gtk_object_set_user_data(GTK_OBJECT(pup_dialog),
                             (gpointer) (long) sx_submit_data);
    gtk_object_set_data(GTK_OBJECT(pup_dialog), "path", (gpointer) path);
  }
  else
  {
    gtk_window_set_title(GTK_WINDOW(pup_dialog),
                         wp->window_title ? wp->window_title :
                         sula_NAME ": SkriptX Dialogue");
    /*gtk_window_position(GTK_WINDOW(pup_dialog), GTK_WIN_POS_NONE); */
    gtk_object_set_user_data(GTK_OBJECT(pup_dialog), (gpointer) data);
  }
  gtk_object_set_data(GTK_OBJECT(pup_dialog), _SKX_ITEM,
                      (gpointer) (long) (wp - win_pup));

  gtk_window_set_policy(GTK_WINDOW(pup_dialog), FALSE, TRUE, FALSE);
  gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(pup_dialog)->vbox), 4);
  gtk_widget_set_name(pup_dialog, "SkriptX dialog");
  gtk_signal_connect(GTK_OBJECT(pup_dialog), "destroy",
                     GTK_SIGNAL_FUNC(quit_winpup), (gpointer) reminder);

  hbuttonbox = gtk_hbutton_box_new();
  gtk_widget_show(hbuttonbox);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(pup_dialog)->action_area),
                     hbuttonbox, TRUE, TRUE, 0);

  wid = gtk_button_new_with_label(wp->ok_label ? wp->ok_label : "OK");
  gtk_object_set_data(GTK_OBJECT(wid), "r", reminder);
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
  gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                     GTK_SIGNAL_FUNC(pup_dialog_cb), pup_dialog);
  GTK_WIDGET_SET_FLAGS(wid, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(wid);
  gtk_widget_show(wid);

  table = gtk_table_new(wp->nparams, 3, FALSE);
  gtk_container_border_width(GTK_CONTAINER(table), 2);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(pup_dialog)->vbox),
                     table, TRUE, TRUE, 0);
  gtk_table_set_row_spacings(GTK_TABLE(table), 1);
  gtk_widget_show(table);
  for (i = 0; i < wp->nparams; i++)
  {
    if (wp->param[i].type != SX_BUTTON && wp->param[i].prompt)
    {
      wid = gtk_label_new(wp->param[i].prompt);
      gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
      gtk_widget_show(wid);
      gtk_table_attach(GTK_TABLE(table), wid, 0, 1, i, i + 1,
                       (GtkAttachOptions) GTK_SHRINK,
                       (GtkAttachOptions) 0, 2, 0);
    }
    wid = NULL;
    sprintf(buf, "%d", i);
    switch (wp->param[i].type)
    {
       case SX_STRING:
       case SX_NUMBER:
       case SX_FLOAT:
         is_input = 1;
         wid = gtk_entry_new();
         gtk_object_set_data(GTK_OBJECT(pup_dialog), buf, wid);
         if (wp->param[i].prev_value)
           spx_set_input(wid, wp->param[i].prev_value);
         else if (wp->param[i].val.sval)
           spx_set_input(wid, wp->param[i].val.sval);
         gtk_widget_show(wid);
         gtk_table_attach(GTK_TABLE(table), wid, 1, 2, i, i + 1,
                          (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
                          (GtkAttachOptions) 0, 2, 0);
         break;
       case SX_TOGGLE:
         wid = gtk_check_button_new();
         gtk_object_set_data(GTK_OBJECT(pup_dialog), buf, wid);
         SET_BUTTON(wid, wp->param[i].val.ival);
         gtk_widget_show(wid);
         gtk_table_attach(GTK_TABLE(table), wid, 1, 2, i, i + 1,
                          (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
                          (GtkAttachOptions) 0, 2, 0);
         break;
       case SX_FILE:
       case SX_COLOUR:
       case SX_FONT:
         {
           GtkWidget *butn;

           is_input = 1;
           wid = gtk_entry_new();
           gtk_object_set_data(GTK_OBJECT(pup_dialog), buf, wid);
           if (wp->param[i].prev_value)
             spx_set_input(wid, wp->param[i].prev_value);
           else if (wp->param[i].val.sval)
             spx_set_input(wid, wp->param[i].val.sval);
           gtk_widget_show(wid);
           gtk_table_attach(GTK_TABLE(table), wid, 1, 2, i, i + 1,
                            (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
                            (GtkAttachOptions) 0, 2, 0);
           butn = gtk_button_new_with_label("...");
           gtk_object_set_data(GTK_OBJECT(butn), "r", reminder);
           gtk_table_attach(GTK_TABLE(table), butn, 2, 3, i, i + 1,
                            (GtkAttachOptions) 0, (GtkAttachOptions) 0, 2, 0);
           gtk_widget_show(butn);
           if (wp->param[i].type == SX_FILE)
           {
             gtk_signal_connect(GTK_OBJECT(butn), "clicked",
                                GTK_SIGNAL_FUNC(winput_filesel_cb), wid);
             gtk_tooltips_set_tip(tooltips, butn, "file selector", 0);
           }
           else if (wp->param[i].type == SX_COLOUR)
           {
             char *pccol =
                wp->param[i].prev_value ? wp->param[i].
                prev_value : wp->param[i].val.sval;

             if (pccol)
             {
               GdkColor col;

               if (gdk_color_parse(pccol, &col))
               {
                 GtkStyle *style = gtk_style_copy(GTK_WIDGET(wid)->style);

                 //if (gdk_color_alloc(gdk_colormap_get_system(), &col))
                 style->base[GTK_STATE_NORMAL] = col;
                 gtk_widget_set_style(GTK_WIDGET(wid), style);
               }
             }
             gtk_signal_connect(GTK_OBJECT(butn), "clicked",
                                GTK_SIGNAL_FUNC(winput_coloursel_cb), wid);
             gtk_tooltips_set_tip(tooltips, butn, "colour selector", 0);
           }
           else
           {
             gtk_signal_connect(GTK_OBJECT(butn), "clicked",
                                GTK_SIGNAL_FUNC(winput_fontsel_cb), wid);
             gtk_tooltips_set_tip(tooltips, butn, "font selector", 0);
           }
         }
         break;
       case SX_PIXMAP:
         {
           wid = create_pixmap_from_path(pup_dialog, wp->param[i].val.sval);
           if (!wid)
             wid = create_pixmap_from_data(pup_dialog, spx_people_xpm);
           gtk_table_attach(GTK_TABLE(table), wid,
                            0, 3, i, i + 1,
                            (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
                            (GtkAttachOptions) GTK_EXPAND, 2, 0);
           gtk_widget_show(wid);
           break;
         }
       case SX_LABEL:
         wid = gtk_label_new(wp->param[i].val.sval);
         gtk_misc_set_alignment(GTK_MISC(wid), 0.0, 0.5);
         gtk_widget_show(wid);
         gtk_table_attach(GTK_TABLE(table), wid,
                          wp->param[i].prompt ? 1 : 0, 3, i, i + 1,
                          (GtkAttachOptions) 0, (GtkAttachOptions) 0, 2, 0);
         break;
       case SX_TEXT:
       case SX_BROWSE:
       case SX_FILELOAD:
         {
           GtkWidget *sw = gtk_scrolled_window_new(NULL, NULL);

           gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                          GTK_POLICY_AUTOMATIC,
                                          GTK_POLICY_AUTOMATIC);
           gtk_table_attach(GTK_TABLE(table), sw,
                            wp->param[i].prompt ? 1 : 0, 3, i, i + 1,
                            (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
                            (GtkAttachOptions) GTK_FILL | GTK_EXPAND, 2, 0);
           gtk_widget_show(sw);
           wid = gtk_text_new(NULL, NULL);
           gtk_object_set_data(GTK_OBJECT(pup_dialog), buf, wid);
           gtk_widget_set_usize(wid, wp->param[i].w, wp->param[i].h);
           gtk_container_add(GTK_CONTAINER(sw), wid);
           if (wp->param[i].type == SX_TEXT)
           {
             is_input = 1;
             gtk_text_set_editable(GTK_TEXT(wid), TRUE);
             if (wp->param[i].val.sval)
               gtk_text_insert(GTK_TEXT(wid), NULL, NULL,
                               NULL, wp->param[i].val.sval, -1);
           }
           else
           {
             gtk_text_set_editable(GTK_TEXT(wid), FALSE);
             if (wp->param[i].type == SX_BROWSE)
               spx_write(wid, wp->param[i].val.sval);
             else if (spx_load_file(wid, wp->param[i].val.sval))
             {
               char *buf =
                  malloc(sizeof(char) *

                         (strlen(wp->param[i].val.sval) + 255));

               sprintf(buf, "@C1Error reading @b@$%s@!$@!b: @i@.%s",
                       wp->param[i].val.sval, strerror(errno));
               spx_write(wid, buf);
               free(buf);
             }
           }
           gtk_widget_show(wid);
           break;
         }
       case SX_SLIST:
       case SX_MLIST:
         {
           GtkWidget *sw = gtk_scrolled_window_new(NULL, NULL);
           char **p = wp->param[i].val.vval;

           is_input = 1;
           gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                          GTK_POLICY_AUTOMATIC,
                                          GTK_POLICY_AUTOMATIC);
           gtk_table_attach(GTK_TABLE(table), sw,
                            wp->param[i].prompt ? 1 : 0, 3, i, i + 1,
                            (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
                            (GtkAttachOptions) GTK_FILL | GTK_EXPAND, 2, 0);
           gtk_widget_show(sw);
           wid = gtk_list_new();
           gtk_object_set_data(GTK_OBJECT(pup_dialog), buf, wid);
           gtk_list_set_selection_mode(GTK_LIST(wid),
                                       wp->param[i].type ==
                                       SX_MLIST ? GTK_SELECTION_MULTIPLE :
                                       GTK_SELECTION_SINGLE);
           gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw),
                                                 wid);
           while (*p)
           {
             GtkWidget *item = gtk_list_item_new_with_label(*p);

             gtk_object_set_user_data(GTK_OBJECT(item), *p);
             gtk_container_add(GTK_CONTAINER(wid), item);
             gtk_widget_show(item);
             p++;
           }
           gtk_widget_show(wid);
           break;
         }

       case SX_CLIST:
         {
           GtkWidget *sw = gtk_scrolled_window_new(NULL, NULL);
           char **p;
           SCM list;

           p = wp->param[i].val.clist.title;

           is_input = 1;
           gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                          GTK_POLICY_AUTOMATIC,
                                          GTK_POLICY_AUTOMATIC);
           gtk_table_attach(GTK_TABLE(table), sw,
                            wp->param[i].prompt ? 1 : 0, 3, i, i + 1,
                            (GtkAttachOptions) GTK_FILL | GTK_EXPAND,
                            (GtkAttachOptions) GTK_FILL | GTK_EXPAND, 2, 0);
           gtk_widget_show(sw);

           if (wp->param[i].val.clist.len == 1 && *p && **p == 0)
             wid = gtk_clist_new(wp->param[i].val.clist.len);
           else
           {
             wid = gtk_clist_new_with_titles(wp->param[i].val.clist.len, p);
             gtk_clist_column_titles_show(GTK_CLIST(wid));
           }
           gtk_clist_set_shadow_type(GTK_CLIST(wid), GTK_SHADOW_NONE);
           gtk_clist_set_selection_mode(GTK_CLIST(wid),
                                        wp->param[i].val.clist.multiple ?
                                        GTK_SELECTION_MULTIPLE :
                                        GTK_SELECTION_SINGLE);

           list = wp->param[i].val.clist.val;
           while (!gh_null_p(list))
           {
             int n = wp->param[i].val.clist.len;
             char **s = SCM_list2pchar(gh_car(list), &n);

             //gtk_clist_set_row_data(GTK_CLIST(wid), row++, 
             list = gh_cdr(list);
             gtk_clist_append(GTK_CLIST(wid), s);
             while (*s)
               free(*s++);
           }
           gtk_object_set_data(GTK_OBJECT(pup_dialog), buf, wid);
           gtk_widget_set_usize(wid, wp->param[i].w, wp->param[i].h);
           gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw),
                                                 wid);
           gtk_widget_show(wid);
           break;
         }
#if DO_SX_BUTTON
       case SX_BUTTON:
         {
           wid = gtk_button_new_with_label(wp->param[i].prompt);
           gtk_object_set_data(GTK_OBJECT(wid), "id", (gpointer) i);
           //gtk_object_set_user_data(GTK_OBJECT(wid), (gpointer)&wp->param[i].val.cbs);
           gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
           gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                              GTK_SIGNAL_FUNC(skx_button_cb), pup_dialog);
           gtk_widget_show(wid);
           break;
         }
#endif
       default:
         break;
    }
  }

  wid =
     gtk_button_new_with_label(wp->cancel_label ? wp->
                               cancel_label : "Cancel");
  gtk_widget_show(wid);
  if (wp->flag & SKX_MENU)
    gtk_signal_connect_object(GTK_OBJECT(wid), "clicked",
                              GTK_SIGNAL_FUNC(gtk_widget_destroy),
                              GTK_OBJECT(pup_dialog));
  else
  {
    gtk_signal_connect(GTK_OBJECT(wid), "clicked",
                       GTK_SIGNAL_FUNC(skx_cancel_cb), pup_dialog);

    if (wp->proc.scm[1] == -1 && !is_input)
      gtk_widget_hide(wid);
  }
  gtk_container_add(GTK_CONTAINER(hbuttonbox), wid);
  gtk_widget_show(pup_dialog);
}

void sx_populate_factory(GtkItemFactory * ifactory)
{
  int i;

  for (i = 0; i < win_pup_count; i++)
    if ((win_pup[i].flag & SKX_MENU) && !(win_pup[i].flag & SKX_CONSOLE))
    {
      GtkItemFactoryEntry *f;

      f = g_malloc(sizeof(GtkItemFactoryEntry));
      f->path = win_pup[i].proc.sx->path;
      f->accelerator = 0;
      f->callback = skript_menu_cb;
      f->callback_action = 400;
      f->item_type = 0;
      gtk_item_factory_create_item(ifactory, f, (gpointer) i, 1);
    }
}
void initialize_skriptx(void)
{
  gh_define("SX_TOGGLE", gh_long2scm(SX_TOGGLE));
  gh_define("SX_NUMBER", gh_long2scm(SX_NUMBER));
  gh_define("SX_STRING", gh_long2scm(SX_STRING));
  gh_define("SX_FLOAT", gh_long2scm(SX_FLOAT));
  gh_define("SX_TEXT", gh_long2scm(SX_TEXT));
  gh_define("SX_TITLE", gh_long2scm(SX_TITLE));
  gh_define("SX_FILE", gh_long2scm(SX_FILE));
  gh_define("SX_FONT", gh_long2scm(SX_FONT));
  gh_define("SX_COLOUR", gh_long2scm(SX_COLOUR));
  gh_define("SX_DESCR", gh_long2scm(SX_DESCR));
  /* gh_define("SX_AUTHOR", gh_long2scm(SX_AUTHOR));
     gh_define("SX_ADDRESS", gh_long2scm(SX_ADDRESS));
     gh_define("SX_DATE", gh_long2scm(SX_DATE));
   */
  gh_define("SX_OK", gh_long2scm(SX_OK));
  gh_define("SX_CANCEL", gh_long2scm(SX_CANCEL));
  gh_define("SX_LABEL", gh_long2scm(SX_LABEL));
  gh_define("SX_PIXMAP", gh_long2scm(SX_PIXMAP));
  gh_define("SX_FILELOAD", gh_long2scm(SX_FILELOAD));
  gh_define("SX_BROWSE", gh_long2scm(SX_BROWSE));
  gh_define("SX_BUTTON", gh_long2scm(SX_BUTTON));
  gh_define("SX_CLIST", gh_long2scm(SX_CLIST));
  gh_define("SX_SLIST", gh_long2scm(SX_SLIST));
  gh_define("SX_MLIST", gh_long2scm(SX_MLIST));
  gh_define("SX_HBOX", gh_long2scm(SX_HBOX));

  gh_new_procedure("sx-submit-new", gs_skriptx_menu, 3, 0, 1);
  gh_new_procedure("sx-menuitem-remove", gs_sx_remove_path, 2, 0, 0);
  gh_new_procedure("sx-menu-clear", gs_sx_clear_menu, 1, 0, 0);

  gh_new_procedure("sx-dialog-new", gs_skriptx_dialog, 3, 0, 1);

  gh_new_procedure("sx-tb-new", gs_sx_win_new, 5, 0, 1);
  gh_new_procedure("sx-tb-add-line", sx_userwin_add_line, 3, 0, 0);
  gh_new_procedure("sx-tb-set!", sx_userwin_set_attr, 3, 0, 0);
  gh_new_procedure("sx-tb-clear", gs_sx_userwin_clear, 1, 0, 0);
  gh_new_procedure("sx-tb-destroy", sx_userwin_destroy, 1, 0, 0);
  gh_new_procedure("sx-clist-title!", gs_sx_clist_set_title, 3, 0, 0);	/*id col str */
  gh_new_procedure("sx-clist-titles-hide/show", gs_sx_clist_hide_titles, 2, 0, 0);	/*id str #t|#f */
  gh_new_procedure("sx-clist-get-selection", sx_clist_get_selection, 2, 0, 0);	/*id row_numbers|texts */
  gh_new_procedure("sx-clist-delete-rows", gs_sx_clist_delete_rows, 1, 0, 1);	/*with no args deletes al selected rows */
  gh_new_procedure("sx-clist-column-width!", sx_set_column_width, 3, 0, 0);
  gh_new_procedure("sx-clist-cell-style!", sx_clist_set_cell_style, 4, 0, 0);
  gh_new_procedure("sx-clist-row-style!", sx_clist_set_row_style, 3, 0, 0);
  gh_new_procedure("sx-text-retrieve", gs_sx_text_retrieve, 1, 0, 0);
  gh_new_procedure("sx-text-add-file", gs_sx_text_add_file, 2, 0, 0);
}

#endif /* if _GUILE */
