/*
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix)
*/
/*
  Popups for channel user list
  Copyright (C) 1999 Tano Fotang

  This is distributed under the GNU General Public License,
  either version 2, or any later version. The license is included
  herein by reference.

*/

#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <string.h>
#include "spx.h"
#include "userpup.h"

Pup_cmd *pup_cmd = NULL;
GtkWidget *user_popup_list = NULL;
GtkWidget *chanusers_pup_menu;
Winstruct *chanusers_pup_window = NULL;
extern void chanusers_pup_cb(GtkWidget * menuitem, gpointer);
static void pup_left_rotate(pPup_cmd * pp)
{
  pPup_cmd p = *pp,
       r;

  *pp = r = p->right;
  p->right = r->left;
  r->left = p;
  p->bf--;
  if (r->bf > 0)
    p->bf -= r->bf;
  r->bf--;
  if (p->bf < 0)
    r->bf += p->bf;
}

static void pup_right_rotate(pPup_cmd * pp)
{
  pPup_cmd p = *pp,
       l;

  *pp = l = p->left;
  p->left = l->right;
  l->right = p;
  p->bf++;
  if (l->bf < 0)
    p->bf -= l->bf;
  l->bf++;
  if (p->bf > 0)
    l->bf += p->bf;
}
int add_users_pup(pPup_cmd * pp,
                  const char *title,
                  const char *proc,
                  int type)
{
  int dH = 0;
  pPup_cmd p = *pp;

  if (p == NULL)
  {

    *pp = p = my_malloc(sizeof(Pup_cmd));
    p->title = strdup(title);
    p->cmd = strdup(proc);
    p->type = type;
    p->bf = 0;
    p->left = p->right = NULL;
    dH = 1;

    update_pup_list(1);
  }
  else
  {
    int tt = strcmp(title, p->title);

    if (tt > 0)
    {
      if (add_users_pup(&p->right, title, proc, type))
      {
        p->bf++;
        if (p->bf == 1)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            pup_right_rotate(&p->right);
          pup_left_rotate(pp);
        }
      }
    }
    else if (tt < 0)
    {
      if (add_users_pup(&p->left, title, proc, type))
      {
        p->bf--;
        if (p->bf == -1)
          dH = 1;
        else if (p->bf == -2)
        {
          if (p->left->bf == 1)
            pup_left_rotate(&p->left);
          pup_right_rotate(pp);
        }
      }
    }
    else
    {
      /*  struct TPup_cmd *left = p->left;
         struct TPup_cmd *right = p->right;
         short bf = p->bf; */

      free(p->cmd);
      p->cmd = strdup(proc);
      p->type = type;
      update_pup_list(0);
      /*
         memcpy(
         p->right = right;
         p->left = left;
         p->bf = bf; */
    }
  }
  return dH;
}
Pup_cmd *find_pup(Pup_cmd * p, const char *name)
{
  int c;

  while (p)
  {
    c = strcmp(name, p->title);
    if (c == 0)
      return p;
    else if (c < 0)
      p = p->left;
    else
      p = p->right;
  }
  return NULL;
}
static int remove_pup_entry(pPup_cmd * pp,
                            const char *title)
{
  pPup_cmd p = *pp,
      *q;
  int dH = 0;
  int tt;

  if (!p)
    return 0;
  if ((tt = strcmp(title, p->title)) < 0)
  {
    if (remove_pup_entry(&p->left, title))
    {
      p->bf++;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == 2)
      {
        if (p->right->bf == -1)
          pup_right_rotate(&p->right);
        pup_left_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else if ((tt > 0))
  {
    if (remove_pup_entry(&p->right, title))
    {
      p->bf--;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == -2)
      {
        if (p->left->bf == 1)
          pup_left_rotate(&p->left);
        pup_right_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else
  {
    if (p->right == NULL)
    {
      *pp = p->left;
      free(p->title);
      free(p->cmd);
      free(p);
      p = NULL;
      return 1;
    }
    else if (p->left == NULL)
    {
      *pp = p->right;
      free(p->title);
      free(p->cmd);
      free(p);
      p = NULL;
      return 1;
    }
    else
    {
      Pup_cmd *foo = my_malloc(sizeof(Pup_cmd));
      struct TPup_cmd *left,
          *right;

      memcpy((void *) foo, p, sizeof(Pup_cmd));

      q = &p->left;
      while ((*q)->right != NULL)
        q = &(*q)->right;

      left = p->left;
      right = p->right;
      memcpy((void *) p, (*q), sizeof(Pup_cmd));
      p->left = left;
      p->right = right;

      left = (*q)->left;
      right = (*q)->right;
      memcpy((void *) (*q), foo, sizeof(Pup_cmd));
      (*q)->left = left;
      (*q)->right = right;

      if (remove_pup_entry(&p->left, foo->title))
      {
        p->bf++;
        if (p->bf == 0)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            pup_right_rotate(&p->right);
          pup_left_rotate(pp);
          dH = 1;
        }
      }
      free(foo);
    }
  }
  return dH;
}
static void display_pup_tree(Pup_cmd * p,
                             GtkCList * clist,
                             int *row,
                             int redraw_menu)
{
  if (p)
  {
    display_pup_tree(p->left, clist, row, redraw_menu);
    if (clist)
    {
      char *s[3];

      s[0] = p->title;
      s[1] = p->cmd;
      s[2] = p->type & PUP_CMD_SCM ? "SCM" : "IN";
      gtk_clist_append(clist, s);
      gtk_clist_set_row_data(clist, *row,
                             (gpointer) (int) p->type);
      (*row)++;
    }
    if (redraw_menu)
    {
      GtkWidget *menuitem = gtk_menu_item_new_with_label(p->title);

      gtk_menu_append(GTK_MENU(chanusers_pup_menu), menuitem);
      gtk_object_set_user_data(GTK_OBJECT(menuitem),
                               (gpointer) p->title);
      gtk_widget_show(menuitem);
      gtk_signal_connect(GTK_OBJECT(menuitem),
                         "activate",
                         GTK_SIGNAL_FUNC(chanusers_pup_cb),
                         NULL);
    }
    display_pup_tree(p->right, clist, row, redraw_menu);
  }
}
void update_pup_list(int redraw_menu)
{
  GtkWidget *clist = NULL;
  int row = 0;

  if (redraw_menu)
  {
    initialize_user_pup();
  }
  if (user_popup_list)
  {
    clist = gtk_object_get_data(GTK_OBJECT(user_popup_list), "clist");

    gtk_clist_freeze(GTK_CLIST(clist));
    gtk_clist_clear(GTK_CLIST(clist));
  }
  display_pup_tree(pup_cmd, clist ? GTK_CLIST(clist) : NULL, &row, redraw_menu);
  if (user_popup_list && clist)
    gtk_clist_thaw(GTK_CLIST(clist));
}

void remove_pup(const char *title, char update)
{
  remove_pup_entry(&pup_cmd, title);
  if (update)
    update_pup_list(1);
}

void clear_pups(Pup_cmd * p)
{
  if (p)
  {
    clear_pups(p->left);
    remove_pup_entry(&p, p->title);
    clear_pups(p->right);
  }
  update_pup_list(1);
}
static void pup_save(Pup_cmd * p, FILE * fp)
{
  if (p)
  {
    pup_save(p->left, fp);
    fprintf(fp, "(gs-pup-add \"%s\" \"%s\" %s)\n",
            p->title,
            p->cmd,
            p->type & PUP_CMD_SCM ? "" : "#t");
    pup_save(p->right, fp);
  }
}
void save_pups(const char *fname, void *junk)
{
  if (fname && *fname)
  {
    FILE *fp = fopen(fname, "w");

    if (fp == NULL)
    {
      error(ERR_SYS, "Error saving pups to \"%s\"", fname);
      if (gflags & BEEP_ERR)
        spx_bell(0);
      return;
    }
    else
    {
      time_t t = time(NULL);

      fprintf(fp, ";; Channel user popup menu\n;; %s\n", ctime(&t));
      pup_save(pup_cmd, fp);
      fclose(fp);
    }
  }
}
