/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/



/* cmd.h        - header file for commands

   Copyright (C) 1997-1999 Tano Fotang

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation.
   See the file COPYING for more info.

 */

#ifndef _sula_cmds_h
#define _sula_cmds_h
#include "spx.h"
extern char cmdchar;		/* command char , default '/' */
extern char *line_break;		/* start of multiple-line text. defaullt:\t */
#define MAXARGC	       		50	/* max # of args for cmds: argc */
#define	MAXCMDLEN	30	/* max cmd length; doesent seem 2b used anywhere.. */
typedef struct
{
   int w;
   char *args;			/* cmd arguments */
}
CmdStruct;
typedef struct TCmd
{
   char *name;
   char *help;			/* not applicable in aliases */
   int type;
/* command types */
#define  CMD_BI		( 1<<00 )	/* built-in cmd */
#define  CMD_SCM	( 1<<01 )	/* Scheme defined cmd */
#define  CMD_FD		( 1<<02 )	/* command defined by external script */
#define  CMD_ALIAS	( 1<<03)	/* command is an alias; scm only */

#define  CMD_CTCP	( 1<<11 )

   union
   {
      void (*in) (CmdStruct *);	/*IN_NORMAL */
      int sp;
      char *text;		/* alias substitution text */
#if _GUILE
      int scm;			/* index to scm_func */
#endif
   }
   cmd;
   short bf;
   struct TCmd *left;
   struct TCmd *right;
}
Cmd;
typedef Cmd *pCmd;
extern Cmd *bi_cmdTree, *fd_cmdTree, *scm_cmdTree, *alias_cmdTree;
extern short count_bi_cmds, count_fd_cmds, count_scm_cmds, count_alias;
extern Cmd *ctcp_cmdTree;
extern short count_ctcp_cmds;
extern Cmd *_find_cmd(const char *name, int type, int how);

#define find_ctcp_cmd(name,fullname)  _find_cmd((name),\
	(CMD_CTCP),(fullname))
#define find_builtin_cmd(name, fullname) _find_cmd((name),(CMD_BI),(fullname))
#define find_scm_cmd(name, fullname) _find_cmd((name),(CMD_SCM),(fullname))
#define find_alias(name, fullname) _find_cmd((name),(CMD_ALIAS),(fullname))
#define find_fd_cmd(name, fullname) _find_cmd((name),(CMD_FD),(fullname))
#define find_cmd(name,fullname)  _find_cmd((name),\
	(CMD_BI|CMD_SCM|CMD_ALIAS|CMD_FD),(fullname))
extern int _remove_cmd(const char *name, int type);

/*#define remove_cmd(name) _remove_cmd((name),\
   (CMD_BI|CMD_SCM|CMD_ALIAS|CMD_FD))
 */
#define remove_alias(name)  _remove_cmd((name), (CMD_ALIAS))
#define remove_scm_cmd(name) _remove_cmd((name), (CMD_SCM))
#define remove_fd_cmd(name) _remove_cmd((name), (CMD_FD))
#define remove_ctcp_cmd(name) _remove_cmd((name),(CMD_CTCP))
extern int _insert_cmd(pCmd * pp, Cmd * c, short *count);

#define insert_bi_cmd(c) _insert_cmd(&bi_cmdTree,(c),&count_bi_cmds)
#define insert_alias(c) _insert_cmd(&alias_cmdTree,(c),&count_alias)
#define insert_scm_cmd(c) _insert_cmd(&scm_cmdTree,(c),&count_scm_cmds)
#define insert_fd_cmd(c) _insert_cmd(&fd_cmdTree,(c),&count_fd_cmds)
#define insert_ctcp_cmd(c) _insert_cmd(&ctcp_cmdTree,(c),&count_ctcp_cmds)

extern char *expand_quote(const char *fmt, const char *str, int w);


typedef struct TCmdOnCon
{
   int type;			/* SERV_CMD:sendto_server, CLI_CMD:process cmd */
#define SERV_CMD	(1<<0)
#define CLI_CMD		(1<<1)
   char *cmd;
   char *server;
   u_short port;
   struct TCmdOnCon *next;
}
CmdOnCon;			/* do cmd upon connecting */
extern CmdOnCon *cmdonconStart, *cmdonconEnd;
extern void add_cmdoncon(int type, char *cmd, char *serv, u_short port);

extern void send_blocktxt(int, const char *, int);
extern int new_process_cmd(char *, int);

#define process_cmd(str, win) \
	new_process_cmd((str),\
	(win)!=NULL? (win)-winstruct : -1)
extern int parse_scheme(const char *, int);
extern int parse_input(int, const char *, int);
extern int load_ctcp_cmds(void);

extern int show_std_help(const char *, const char *, SPX_chanwin *);

extern int on_channel(const Server *, const char *);
extern void jjoin(Winstruct * win);
extern void ClearWinChanList(Winstruct * win);

extern void log_set(int, void *);

#endif
