/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


#ifndef _glirc_dcc_h
#define _glirc_dcc_h

typedef struct{			/* file transfers inprogress */
	int		fp;			/* local file */
/*	int		w;			*//* file transfer display*/
	char		*name;
	char		resume;	/* !0 ->have sent resume request*/
	off_t		size;	/* <0 if not given*/
	u_long		checksum;
	off_t		offset;
	off_t		read;			/* progress (read or sent)*/
	struct timeval	lasttime;		/* when the last read(if GETting)/write(SEND) occured */
	struct timeval	starttime;	
} DCCFile;

typedef struct{
	char		*server;	/* ??? */
	Winstruct	*win;		/* window where chat will be; NULL->create one */
}DCCChatSent;

typedef struct TDCC{
	char type;
	#define DCC_FILE	(1<<0)
	#define DCC_CHAT	(1<<1)
	#define DCC_SENT	(1<<2)
	#define DCC_RECV	(1<<3)
	#define DCC_ACTIVE	(1<<4)
  #define DCC_FWD     (1<<5) /* forwarded */
	int		id;/*remove*/
	int		fd;/*if active*/
	char *nick;	/*other side*/
	char *peer; /* sending/receiving to/from. user@host.domain */
	union{
	   DCCFile *file;
	   DCCChatSent *chat;
	}dcc;
	short w;      /* server window */
	time_t			starttime; /* or time req. was sent/recvd*/	
	unsigned short		rport;/*remote*/
	unsigned short		lport;/*local*/
	unsigned long		inetaddr; //host=inet_ntoa(inetaddr);
	struct TDCC *next;
}DCC;

extern DCC	*dccStart, *dccEnd;

extern 	int ctcp_cmd(void);
typedef struct TKey{
	char *who;
	char *key;
	char flag;	/* decrypt or not */
	struct TKey *next;
} Key;
extern Key *keys;
extern void do_encrypt(int ,char **, int w);
extern char *ctcp_quote_it(char *,int len);
extern void ctcp_unquote_it(char *,int *len);
extern void encrypt_str(char *,int,char *);
#define ENCRYPT 0
#define DECRYPT 1
extern char *have_key(char *who, int action);

extern int remove_dccchat(int   id, char *reason) ;
extern int dcc_sendchatreq(Winstruct *win, Winstruct *w, const char *nick);
extern void remove_dcc(DCC*);

int sendto_dcc_chat(Winstruct *, DCCChat *, const char *);
extern DCCChatWin *search_dccwinsbyid(int id);

extern int addto_sentfileoffer(const char *nick,char *fname, off_t, int w);

extern void offer(int, char **, int);


extern int		chat_id;
extern int		dcc_get_id;
extern int		dcc_file_id;


extern unsigned short		dcc_timeout;
extern char		*chat_quit_text;
extern char		*userinfo;	/* ctcp */
extern char		*finger_reply;	/* finger reply */
extern unsigned	int	max_sendbuf;	/* dcc send file; buffer suze*/


#endif

