/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/



#ifndef _sula_hooks_h
#define _sula_hooks_h

#define invalid_server_numeric(n) ((n)<1)

//compile with -DREGEX_HOOKS=0 to disable regex hooks
#ifndef REGEX_HOOKS
#define REGEX_HOOKS 1
#endif
#if REGEX_HOOKS
#include <sys/types.h>
#include <regex.h>
#endif

#define CTCP_more 1		/*define CTCP_CLIENTINFO, CTCP_FINGER etc. 
				   These are really not necessary, as on could also use
           CTCP_ALL.
            CTCP_REPLY, and CTCP_UNKNOWN are always defined*/

typedef enum msgnr
{
/*keep sorted by symbol name */
   ACTION = 0,
   CTCP_ALL,
#if CTCP_more
   CTCP_CLIENTINFO,
   CTCP_FINGER,
   CTCP_HELP,
   CTCP_PING,
   CTCP_REPLY,
   CTCP_SED,
   CTCP_SOURCE,
   CTCP_TIME,
   CTCP_UNKNOWN,
   CTCP_USERINFO,
   CTCP_VERSION,
#else
   CTCP_REPLY,
   CTCP_UNKNOWN,
#endif

   DCC_CHAT_DONE,		/* after closing connection */
   DCC_CHAT_LOST,		/* p->nick, p->read, p->rem_host, p->email */
   DCC_CHAT_MSG,
   DCC_CHAT_REQUEST,		/* received a req to chat */
   DCC_CHAT_START,		/* upon successfully conencting */
   DCC_GET_DONE,		/* finished getting file. p->host, p->email, p->filename, p->size, p->read */
   DCC_GET_REQUEST,		/* before sending out a dcc file request */
   DCC_GET_START,		/* established connection to get a file */
   DCC_SEND_DONE,		/* finished sending file. p->host, p->filename, p->size, p->read */
   DCC_SEND_REQUEST,		/* someone sendin us a file */
   DCC_SEND_START,		/* established connection to send . "w nick remote_addr emailadrr" */
   ERROR,			/* server reports error */
   EXIT,			/* just before client shutdown */
   FLOOD_PRIVATE,
   FLOOD_PUBLIC,
   INPUT,			/* anything the user types */
   INVITE,
   IRC_LINE_OUT,		/* about to display a line to screen.
   				 The line came from IRC */
   JOIN,
   JUNK,
   KICK,
   MODE,
   NC,				/* arg:name lineRead */
   NC_LOST,			/* args:name text */
   NC_RAW,			/* name text */
   NICK,
   NOTE,

   NOTIFY_SIGNOFF,
   NOTIFY_SIGNON,
   PART,
   PING,			/* received a server ping */
   PONG,			/* received a server pong */
   PRIVATE_MSG,
   PRIVATE_NOTICE,
   PUBLIC_MSG,
   PUBLIC_NOTICE,
   QUIT,			/* someone signed off */
   RAW_IRC,
   RAW_NON_NUMERIC,
   RAW_NUMERIC,
/* after sending out */
   SEND_ACTION,
   SEND_CHATMSG,
   SEND_DCC_CHAT,
   SEND_ENCRYPTED,
   SEND_PRIVATE_MSG,
   SEND_PRIVATE_NOTICE,
   SEND_PUBLIC_MSG,
   SEND_PUBLIC_NOTICE,
/* before sending */
   SEND_TO_SERVER,

   SERVER_FAILED,		/* SERVER cmd didnt connect */
   SERVER_LOST,			/* server closed connection */
   SERVER_NOTICE,		/* server notices */

   SIGNOFF,			/* BEFORE signoff:when user wishes to signoff irc, e.g. following Quit command */
   SILENCE,
   TOPIC,
   UPDATE_STATUS,		/* prior to updating window status line */
   UPDATE_STATUS_DONE,		/* after updating window status line;arg:new status text */
   WALLOPS,
   WINDOW_CREATE,		/* new window created --untested! */
   WINDOW_DESTROY,		/* about to kill a channel window */
   INVALID
}
MsgNr;
typedef struct TOn
{
   int id;			/* unique hook id; needed only for the event GUI */
   int ser_number;		/* for CMD_IN no duplicates allowed */
   char *pattern;		/* pattern to match */
   int flag;			/* combination of the values below */
#define HK_IN		(1<<0)
#define HK_FD		(1<<1)
#define HK_SCM		(1<<2)

#define HK_NOISY	(1<<3)	/* */
#define HK_SUSPENDED	(1<<4)	/* valid for both; hook suspended */
#define HK_EXCLUSIVE	(1<<5)	/* valid only for CMD_FD: send matches to me alone */
//#define 	(1<<6)
#define HK_PREEMPTIVE	(1<<7)	/* a premptive hook */
#define HK_REGEX	(1<<8)	/* hook uses regular expression */
#define HK_ICASE	(1<<9)	/* ingore case in this hook */

#define HK_DIRTY	(1<<10)
#define HK_RESET	(0)
#if REGEX_HOOKS
   regex_t *preg;
#endif
   union
   {
      int sp;
      char *cmd;		/* sula cmd;expand cmd and process */
      int scm;			/* index into scheme functionarray */
   }
   cmd;
   struct TOn *next;
}
On;

typedef struct TWant
{
   MsgNr type;
   On *start;
   On *end;
}
Want;

/* this should the number of msg types, hooks.c */
extern int MAX_ON;
extern Want *want;			/*[MAX_ON]; */

typedef struct TNumHook
{
   int numeric;
   On *start;
   On *end;
   short bf;
   struct TNumHook *left;
   struct TNumHook *right;
}
NumHook;
typedef NumHook *pNumHook;
extern NumHook *numTree;

extern NumHook *find_numhook(int);

extern MsgNr get_type(const char *);	/*to be removed */
extern void *lookup_type(const char *, int *);
/*extern int do_internal_hook(On *, const char *msg, int, char);*/
extern int check_msg_hook(MsgNr, int, const char *,...);
extern int check_numeric(int, Winstruct *, const char *);
extern void event_setup(void);
extern void delete_hook(char *, char preempt, char update_display);
extern void collect_stale_hooks(void);
#define del_hook(_s) delete_hook((_s),0,1)	/* del_hook(#pubmsg 100 pattern) */
extern void hook_list(SPX_OBJ(b), int script, int do_list);

#define list_hooks(_n) hook_list(NULL,1,(_n))
extern void add_hook2(MsgNr, On *, void *blabla);
extern void add_numhook2(int, On *, void *blabla);

#define add_numhook(_n,_on)    add_numhook2((_n),(_on),0)
#define add_hook(_n,_on)	     add_hook2((_n),(_on),0)

#endif
