/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/* script.h	-
   distributed as part of sula

    (c) Tano Fotang 1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License , or
    (at your option) any later version.

    see the file COPYING for further information.

*/

#ifndef _sula_nc_h_
#define _sula_nc_h_


/*status*/
#define	NC_STOPPED	( 1<<0 )	/* SIGSTOP */
#define NC_SUSPENDED	( 1<<1 )	/* we suspended it*/
#define NC_SLEEPING	( 1<<2 )	/* it doesnt want any more for now */
#define NC_RESET	(0) /*~(NC_SLEEPING|NC_SUSPENDED|NC_STOPPED))*/
/* obsolete */
#define	SCR_STOPPED	 NC_STOPPED
#define SCR_SUSPENDED	NC_SUSPENDED
#define SCR_SLEEPING	NC_SLEEPING
#define SCR_RESET	NC_RESET
	
typedef struct TspCmd{
	char *name;
	int type; //CMD_CTCP,CMD_NORMAL
	struct TspCmd	*next;
}spCmd;
typedef struct{
	int	pid;		/* pid of child*/
	char	*sys_cmd;	/* program name */
}ProcInfo;

typedef struct TS_Pipe{ 	
	int fd;
	char *name;
	#define CON_SCRIPT	1
	#define CON_SERVER	2
	#define CON_DCC		3
	int type;
	union{
	   struct{	
		char *name;	/* to */
		u_short	port;
		char	*args;	/* args to command that created connection,e.g. -u user -p passwd */
	  	struct in_addr sin_addr;/* peer. filled after connecting.*/
	  }server;
	  struct{
	  	char *nick;
		struct in_addr sin_addr;/* filled after connecting.or is the dcc peer */
	  }dcc;
	  ProcInfo *proc;
	}to;
	spCmd	*cmd;		/*cmds defined by script, NULL terminated*/
	int	status;		/*process stopped..; still unable to catch SIGCONT*/
} S_Pipe;
extern S_Pipe	*s_pipe;
extern short	sp_count;
 
extern int add_to_sp(S_Pipe *);
extern void launch_prog(const char *,const char *);
extern S_Pipe *make_connection(const char *,const char *,u_short,const char *);
extern void do_script(void); /* set up GUI */
/* Events */
extern int write_to_sp(int sp, const char *buf);
extern size_t nc_read_bufsize;


#endif
