/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/



#ifndef _sula_notify_h
#define _sula_notify_h

#include "spx.h"

#define MAX_NOTIFY_SERVERS 32 // number of servers for a notify group
typedef struct TNotifyNick{
  char *nick;
  #define NOTIFY_ISONLINE	(1<<0) // person is online
  #define NOTIFY_STATUS_CHANGED (1<<1)
  unsigned char flag[MAX_NOTIFY_SERVERS];// one flag per server in aNotifyList->server
  struct TNotifyNick *next;
}NotifyNick;
typedef struct{
  char *name;
  unsigned short port;
}NotifyServer;

typedef struct{
  char *label;
  NotifyServer *server[MAX_NOTIFY_SERVERS];
  NotifyNick *start;
  NotifyNick *end;
}Notify;
extern Notify *aNotifyList;
extern char *fmt_notify_signon, *fmt_notify_signoff;
extern Notify_t NotifyListCount;
#define NOTIFY_EOL -2 
// use -2 to mark end of a servers list;simliar to '\0' in strings
#if 1
extern Notify_t new_notify_list(const char *label);
extern int remove_notify_list(Notify_t);
extern int addto_notify(Notify_t i,const char *nick);
extern int drop_from_notify(Notify_t i, const char *nick);
#endif
extern int load_notify_lists(const char *fname);
extern Notify_t find_notify_list_bylabel(const char *label);
#define NOTIFY_QUEUE_LEN	64	/* max # of nicks in a group.
ONLY applies when nicknames are being loaded from a file */
extern void copy_notify(Notify_t **dest, const Notify_t *src);

extern int attach_notify_group(Server *, Notify_t c);
extern int detach_notify_group(Server *, Notify_t c);
extern void remove_server_from_notifygroup(Server *s, Notify_t i);
extern void notify(char *, int);
extern void check_notify(int force_it);

typedef struct TNotify_sent{
 //char *nick;
 //time_t time;
 short port;
 char *server;
 struct TNotify_sent *next;
}Notify_sent;
extern Notify_sent *NotifySentStart,*NotifySentEnd;
//extern void clean_sent_notifies(void);//periodically remove sent ISONs
extern int requested_notify(const char *buf,Winstruct *win);
extern void remove_sent_notifies(Server *);
#define valid_notify_index(i) ((i)>-1 && NotifyListCount>(i) \
  && aNotifyList[(i)].label)

#endif
