/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/

#ifndef _sula_server_h
#define _sula_server_h
#include "spx.h"

extern Server *servFdTree;
typedef struct{
  Server *s;
  char *name;
}ServerGroup;
extern ServerGroup *aServerGroup;
extern int iServerGroupCount;
#define VALID_GROUP(_g) ((_g)>-1 && (_g)<iServerGroupCount && aServerGroup[_g].name)
#define DEFAULT_GRP "Unnamed"

extern int      connect_to_server (Server *, Winstruct * , const char *, int);
extern Server  *search_server_tree_byname (int group, const char *name, int flag);
extern int new_group(const char *name);
extern int insert_server(pServer * pp, Server * s, int flag);
#define BY_FD		1
#define BY_NAME		0
extern int init_serverlist(const char *fname);
extern int     remove_server_from_tree(int, const char *servname, u_short port);
extern void    close_server_connectionbyname(int group, const char *servname, u_short port);
extern void     prepare_server_output (int fd, const char *msg);

extern void     close_server_connection (int group, int *fd);
//extern void     new_close_connection (int *fd, char *reason, int update_win);
extern void connecting(int group, const char *, u_short, char);

extern int      save_servers (const char *fname);
extern int      init_serverlist (const char *filename);
extern int load_serverlist(const char *filename);
//extern void     list_servers (void);
#if USE_GTK
extern void redraw_server_entry(int group);
#else
#define redraw_server_entry(_g) \
  do{if(server_tool) TRIGGER_OBJECT(server_tool->update);}while(0)
#endif
#endif
