/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


#ifndef _SPRIMERIX_H
#define _SPRIMERIX_H

#if (USE_XFORMS && USE_GTK) || (!USE_XFORMS && !USE_GTK)
#error You must specify either -DUSE_XFORMS or -DUSE_GTK
#endif
#include <sys/time.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/times.h>
#include <assert.h>
#include <errno.h>
#include "version.h"
#include "scheme.h"
#include "util.h"
#ifndef COMMENT
#define COMMENT			'#'
#endif
#ifndef BUFSIZ
#define BUFSIZ 1024
#endif
#if USE_XFORMS
#include "../xforms/include/gui_xforms.h"

#define spx_display fl_display
#define SPX_CMD_OPT FL_CMD_OPT
#define SPX_NONE    FL_NONE
#define SPX_BOOL    FL_BOOL
#define SPX_SHORT   FL_SHORT
#define SPX_INT     FL_INT
#define SPX_LONG    FL_LONG
#define SPX_FLOAT   FL_FLOAT
#define SPX_DOUBLE  FL_FLOAT
#define SPX_STRING  FL_STRING
typedef  FL_RTYPE SPX_RES_TYPE;
typedef  FL_resource SPX_resource;
#define spx_initialize  fl_initialize
#define spx_get_app_resource  fl_get_resource
#define spx_get_app_resources  fl_get_app_resources
#define SPX_READ  FL_READ
#define SPX_WRITE FL_WRITE

//extern FD_main_form *main_window;
typedef FD_main_form SPX_main_window;
typedef FD_chanwin SPX_chanwin;
typedef FD_serverlist Server_tool;
typedef FD_scriptcontrol Script_control;
/*#define nc_tool script_form*/
//#define main_text main_window->browser

#define SPX_OBJ(__ob) FL_OBJECT *(__ob)
#define SPX_DATA(__data)  long (__data)
#define SPX_TEXT(w) ((w)->chanwin->browser)
#define SPX_TEXT2(w) ((w)->chanwin->brow2)
typedef int SPX_font;
typedef int SPX_colour;
#define spx_get_input(__ob) fl_get_input(__ob)
#define spx_set_input(__ob, __s) fl_set_input(__ob, __s)
#define spx_write(__ob, __str)  fl_addto_browser_chars((__ob), (__str))
#define spx_write0(__ob, __str)  fl_addto_browser_chars((__ob), (__str))
#define spx_write1(__ob, __str)  fl_addto_browser_chars((__ob), (__str))
#define spx_writeln0(__ob, __str)  fl_addto_browser((__ob), (__str))
#define spx_writeln(__w,__s)  fl_addto_browser((__w), (__s))
#define BUTTON_IS_ON(__ob) fl_get_button(__ob)
#define TO_QUERY(w) fl_get_button((w)->chanwin->r_query)
#define TO_QUOTE(w) fl_get_button((w)->chanwin->r_quote)
#define TO_DCC(w) fl_get_button((w)->chanwin->r_dcc_chat)
#define TO_CHANNEL(w) fl_get_button((w)->chanwin->r_channel)
#define TO_ECHO(w) fl_get_button((w)->chanwin->r_echo)
#define SET_BUTTON(__ob, _on_) fl_set_button(__ob, _on_)
#define TRIGGER_OBJECT(__ob) fl_trigger_object(__ob)
#define ACTIVATE_BUTTON(__ob) SET_BUTTON(__ob, 1)
#define DEACTIVATE_BUTTON(__ob) SET_BUTTON(__ob, 0)
#define SET_RADIO(__but, _f)  fl_set_button(__but, 1)

#define SET_WINDOW_TITLE(w,str) fl_set_form_title((w),(str))
#define TEXT_CLEAR(__w) fl_clear_browser(__w)
#define spx_add_timeout(__t, __proc,__data) \
  fl_add_timeout((double)(__t), (__proc),(void *)(__data))
#define spx_remove_timeout(__id)  fl_remove_timeout(__id)
#define spx_add_io_callback(__fd, __cond, __cb,__data) \
  fl_add_io_callback(__fd, __cond, __cb, (void *)(__data))
#define spx_remove_io_callback(__fd, __cond,__cb) \
  fl_remove_io_callback(__fd, __cond, __cb)


#elif USE_GTK
#include "../gtk/include/gui_gtk.h"
#include <gtk_tb.h>

extern Display *gdk_display;

#define spx_display gdk_display
#define SPX_CMD_OPT GTK_CMD_OPT
#define SPX_NONE    GTK_NONE
#define SPX_BOOL    GTK_BOOL
#define SPX_SHORT   GTK_SHORT
#define SPX_INT     GTK_INT
#define SPX_LONG    GTK_LONG
#define SPX_FLOAT   GTK_FLOAT
#define SPX_DOUBLE  GTK_FLOAT
#define SPX_STRING  GTK_STRING
typedef  GTK_RESOURCE_TYPE SPX_RES_TYPE;
typedef  GTK_resource SPX_resource;
#define spx_initialize  gtk_initialize
#define spx_get_app_resource  gtk_get_app_resource
#define spx_get_app_resources  gtk_get_app_resources
#define SPX_READ  GDK_INPUT_READ
#define SPX_WRITE GDK_INPUT_WRITE

typedef GdkFont *SPX_font;
typedef GdkColor SPX_colour;

typedef struct{
  gint fd;
  gint id;
}IO_id;
extern IO_id *io_id;
extern short io_count;
extern void spx_add_input(gint,GdkInputCondition,GdkInputFunction, gpointer);
extern void spx_remove_input(gint);

#define SPX_OBJ(__ob) GtkWidget *(__ob)
#define SPX_DATA(__data) gpointer (__data)
#define spx_get_input(__ob) gtk_entry_get_text(GTK_ENTRY(__ob))
#define spx_set_input(__ob, __s) gtk_entry_set_text(GTK_ENTRY(__ob), __s)
#define SPX_TEXT(__w) GTK_TEXT((__w)->chanwin->browser)
#define SPX_TEXT2(__w) GTK_TEXT((__w)->chanwin->brow2)
#define spx_write0(__ob, __str)  do{\
/*  gtk_text_insert(GTK_TEXT(__ob),NULL,NULL,NULL,"\n",1);*/\
  gtk_text_insert(GTK_TEXT(__ob),NULL,NULL,NULL,(__str),-1);}while(0)
#define spx_writeln0(__ob, __str)  do{\
  gtk_text_insert(GTK_TEXT(__ob),NULL,NULL,NULL,(__str),-1); \
  gtk_text_insert(GTK_TEXT(__ob),NULL,NULL,NULL,"\n",1);}while(0)
  
#define BUTTON_IS_ON(ob) GTK_TOGGLE_BUTTON (ob)->active
#define TO_QUERY(w) BUTTON_IS_ON ((w)->chanwin->r_query)
#define TO_QUOTE(w) GTK_TOGGLE_BUTTON ((w)->chanwin->r_quote)->active
#define TO_DCC(w) GTK_TOGGLE_BUTTON ((w)->chanwin->r_dcc_chat)->active
#define TO_CHANNEL(w) GTK_TOGGLE_BUTTON ((w)->chanwin->r_channel)->active
#define TO_ECHO(w) GTK_TOGGLE_BUTTON ((w)->chanwin->r_echo)->active
#if 0
#define DEACTIVATE_BUTTON(__ob) do{if(GTK_TOGGLE_BUTTON(__ob)->active) \
  gtk_signal_emit_by_name(GTK_OBJECT(__ob), "clicked");}while(0)
#endif
#define SET_BUTTON(__ob, __on) \
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(__ob), (__on)? TRUE:FALSE)
#define DEACTIVATE_BUTTON(__ob) SET_BUTTON(__ob, FALSE) /* has no effect on radio
buttons or if button already deactivated*/
#define ACTIVATE_BUTTON(__ob) SET_BUTTON(__ob, TRUE) /*
NOTE: the callback is activated! that isnt the case with xforms version*/
#define SET_RADIO(_b,_f) do{if(_f){ACTIVATE_BUTTON(_b);return;}}while(0)/*
set _f if callback should be called */

#define TRIGGER_OBJECT(__ob) gtk_signal_emit_by_name(GTK_OBJECT(__ob),"clicked")
#define SET_WINDOW_TITLE(__w,__s) gtk_window_set_title(GTK_WINDOW(__w),(__s))
#define TEXT_CLEAR(__w) do{guint _n_=gtk_text_get_length(GTK_TEXT(__w));\
  gtk_text_set_point(GTK_TEXT(__w),0);\
  gtk_text_forward_delete(GTK_TEXT(__w),_n_);}while(0)
#define spx_add_timeout(__t, __proc,__data) \
  gtk_timeout_add((guint32)(__t), (__proc),(gpointer)(__data))
#define spx_remove_timeout(__id) gtk_timeout_remove(__id)
#define spx_add_io_callback(__fd, __cond, __cb,__data) \
  spx_add_input(__fd, __cond, __cb, (gpointer)(__data))
#define spx_remove_io_callback(__fd, __junk0,__junk2) spx_remove_input(__fd)
/*
#define spx_swap_pixmap(__win, __old,__data) do{\
  GtkWidget *_new_=create_pixmap(__win, __data);\
  gdk_pixmap_unref(__old);
GtkWidget *
*/
#endif /*#if USE_XFORMS */
extern SPX_main_window *main_window;
extern Script_control *script_form;
extern Server_tool *server_tool;
#define spx_bell(__n) XBell(spx_display, (__n)%101)
#define spx_xflush()  XFlush(spx_display)
extern int gflags;                  /* global flags 0-31 */
extern int sflags;                  /* global flags 32-63 */

/* sflags */
#define FORCE_CONNECTION (1<<0) /* try to connect even if external process
                                   couldnt get remote hostname. This may block client */
#define EXTERNALGETHOST	 (1<<1)	/* use external program to get hostname */
#define EXTENDED_DCC	(1<<2)	/* use DCC RESUME and extended DCC */
#define SUPPRESS_MOTD	(1<<3)	/* suppress motd upon connecting */
#define DYNAMIC_SLIP	(1<<4)	/* we're on a dynamic slip conenction */
#define LOG		(1<<5)	/* log session to log_file */
#define FLOOD_CHECK	(1<<6)	/* turn on/off flood check */
#define sUPDATE_IGNORE_DISPLAY (1<<7) /*automatically update ignore display*/
#define sECHO_INPUT (1<<8) /* display commands typed in control window*/
#define sUPDATE_USER_DISPLAY    (1<<9) /*auto-update the list of channel users*/
#if _GUILE
#define s_VERBOSE_RETURN    (1<<10) /* display all values that Guile
returns.By default, only numeric and string values are displayed*/
#endif

#define s_DOING_INPUT_HOOK (1<<23) /* doing INPUT hook; input may be modified*/
#if MUTABLE_IRC
#define sMUTABLE_IRC (1<<24)
/* these cant be changed by user*/
#define s_IRC_OUTPUT_MODIFIED (1<<25)/*output been  changed by a hook*/
#define s_DOING_IRC_HOOK  (1<<26) /* in a hook; Msg may be modified*/
#define S_ALL	(~(s_IRC_OUTPUT_MODIFIED|s_DOING_IRC_HOOK|s_DOING_INPUT_HOOK))
#else
#define S_ALL (~s_DOING_INPUT_HOOK)
#endif
/*  g f l a g s */
#define SHOW_NUMERIC	(1 << 0)	/* just that */
#define AUTO_REJOIN	(1 << 1)	/* rejoin channel on kick */
#define AUTO_INVITE	(1 << 2)	/* auto accept invites */
#define AUTO_GETFILE	(1 << 3)	/* auto dcc get */
#define AUTO_CHAT	(1 << 4)	/* autoaccept dcc chat */
#define INFORM_IGNORED	(1 << 5)	/* tell 'em they're bein ignored */
#define VERBOSE_CLIENT	(1 << 6)	/* be a verbose client (still figurin out what that shld mean) */
#define SAVE_HISTORY	(1 << 7)	/* save cmd history on program exit */
#define HISTORY		(1 << 8)	/* add cmds to cmd history list */
#define VERBOSE_CTCP	(1 << 10)
#define QUOTE_ML	(1 << 12)	/* quote multiline commands */
#define SHOW_RAW_MSG	(1 << 13)	/* show raw server output */
#define SHOW_TIPS	(1 << 14)	/* display oneliners */
#define FINGER_UTMP	(1 << 16)	/* read utmp file for ctcp finger reply */
#define FINGER		(1 << 17)	/* (dis)allow finger on you */
#define BEEP_AWAY	(1 << 18)	/* private msg/notice/invite */
#define BEEP_DCC	(1 << 19)	/* when dcc request comes in */
#define BEEP_ERR	(1 << 20)	/* bad command and other client errors */
#define BEEP_SERVER_ERR	(1 << 21)	/* bad command to server */
#define BEEP_MSG	(1 << 22)	/* when a msg/notice comes in */
#define AUTO_CHECKLAG	(1 << 23)	/* auto check lag */
#define ENCRYPT_MSG	(1 << 24)	/* message de/encryption */

#define CTRL_WIN_SHOWN	(1 << 26)	/* control window is shown */
#define AUTO_CHECKNOTIFY	(1 << 27)	/* check notify */
#define QUOTE_EXEC	(1 << 28)	/*
		   This says how /EXEC should process the output of a command. If on,
		   output will be quoted so it can be sent via IRC. This takes care of
		   strange chars in the text.
		   If off, output will be sent line by line since IRC servers don't like
		   newlines. However, nuls, carriage returns and other special will not
		   be quoted.
		 */
 
#define ALL_GFLAGS	(~0)	/*0xffffffff) */
/*typedef u_char BOOL; */
typedef struct THistory
{
  char *line;
  struct THistory *left;
  struct THistory *right;
}
History;
extern History *histStart,
 *histCur;
extern History *mainhistStart,
 *mainhistCur;                  /* history for the one control window */

#define		MAX_HIST_SIZE	2000	/* 2000 bytes; currently unused */
typedef struct gTChannel
{
  char *name;                   /* channel name? */
  char *server;                 /* on which server? */
  unsigned int port;
  struct gTChannel *next;
}
gChannel;
extern gChannel *chanStart,
 *chanEnd;
typedef struct TUser
{
  char *nick;
  char *address;                /* user@host */
  char *mode;
  char *ircname;
  struct TUser *next;
}
User;
typedef struct TChanUser /* tree to enable fast searches*/
{
  User *user;/* */
  struct TChanUser *left;
  struct TChanUser *right;
  short bf;
}ChanUser;
typedef ChanUser *pChanUser;
typedef struct TChannel
{
  char *name;
  char *modes;
  char *key;
  int limit;
  char *topic;
  unsigned char flag;
  #define ch_UPDATE_USERS  (1<<0) /*user display needs to be updated*/
  #define ch_DEFAULT_FLAG  0
  User *userStart;
  User *userEnd;
//  #define UH_TABSIZE  50
  ChanUser *users;//[UH_TABSIZE];
  struct TChannel *left;
  struct TChannel *right;
}
Channel;

typedef struct TLag
{
  struct timeval when;
  struct TLag *next;
}
Lag;

typedef struct
{
  char *name;
  char *key;
}
NoChannel;
typedef struct TGo
{
  char *name;
  char *key;
  struct TGo *next;
}
Go;

//typedef  str
typedef struct TDCCChat
{                               /* active dcc chat on a window */
  int id;
  int fd;
  char *nick;
  char *email;                  /* the other side user@do.sa */
  char *rem_host;               /*  addr in dotted numerics of the other side */
  unsigned short port;
  unsigned wrote;
  unsigned read;                /* bytes we've read */
  time_t starttime;
  struct TDCCChat *left;
  struct TDCCChat *right;
}
DCCChat;
typedef short Notify_t;   //must be a signed type

typedef struct TServer
{
  short w;                    /* lead window if server is connected */
  int g;       /* [networg] group */
  int fd;
  char *alias;               /* /server servname */
  char *name;                   /* server to which you're actually connected */
  char *nick;
  int iNick;                   /* list */
  Notify_t *notify;
  char *email;
  char *ircname;
  char *mode;
  u_char flag;
#define SET_AWAY	(1<<0)	/* set away */
#define GOT_MOTD 	(1<<1)	/* got server motd already */
#define DOING_NOTICE	(1<<2)	/* processing a hook on NOTICE */
#define QUITTING	(1<<3)	/* in the process of quitting server */
#define CHANGING_W (1<<4) /* changing lead window */
#define SERVER_FLAG_RESET (0)
  char connecting;
  Lag *lag;
  struct timeval t;             /*lag */
  u_short port;
  char *password;
  char state;
  char *lastInvite;
  unsigned read;                /* total bytes read */
  unsigned wrote;
  time_t connect_time;          /* time at which connection was established */
  short int bf;
  struct TServer *left;
  struct TServer *right;
}
Server;
typedef Server *pServer;

typedef struct
{
  SPX_chanwin *chanwin;
  Server *server;
  char *query_nick;
  DCCChat *dccCur;
  DCCChat *dccStart;
  NoChannel *lastPart;
  NoChannel *lastJoin;
  Go *goStart;
  Go *goEnd;
  Channel *chanCur;
  Channel *chanStart;
  u_char flag;                  /* houses the followin bits: */
#define WIN_BEING_DESTROYED (1<<0)
#define WIN_UPDATING_STATUS (1<<1)
}
Winstruct;
extern Winstruct *winstruct;
extern short win_count;
#define win_invalid(_i) ((_i)<0 || (_i)>win_count-1 || !(winstruct[(_i)].chanwin))
SPX_chanwin *create_chanwin(Winstruct *);
extern void show_chanwin(Winstruct *, char **, int, int);
typedef struct TCmdSent
{
  char *cmd;
  char *arg;
  short w;
  time_t t;
  struct TCmdSent *next;
}
CmdSent;
extern CmdSent *cmdsentStart,
 *cmdsentEnd;

typedef struct TDCCChatWin
{                               /* ALL active chat connections */
  int id;                       /*nicks arent unique so we use an id */
  int *fd;                      /*  &dccChat->fd */
  char *nick;                   /* no malloc; dccChat->nick */
  char *email;                  /* no malloc; dccChat->email  NULL if we sent the request */
  unsigned *read;               /* & win->dccChat->read ... */
  unsigned *wrote;
  char *rem_host;
  unsigned short *port;
  time_t *starttime;
  short w;
  struct TDCCChatWin *next;
}
DCCChatWin;
extern DCCChatWin *dccchatwinStart,
 *dccchatwinEnd;
typedef struct TWinList
{
  short w;
  struct TWinList *next;
}
WinList;
/*
most of the following variables do not belong here.
Some need to 'externed' and put in the proper header files.
*/
extern WinList *servWin;/*tmporally used for storing lists of window*/
extern char *prog_home; /* /home/user/.sula */
extern char *Name;              /* user name */
extern char *sula_lib;          /* e.g. /usr/local/lib/sula */
extern int MaxChanLen,
  MaxNickLen;
extern size_t HistSize,
  mainHistSize;                 /* current cmd list size in bytes */
extern char *quit_text;         /* signoff msg */
extern char *away_text;         /*default away text */
extern char *gethostbynameprogram;     /* external prog for gethostbynmae */
extern char *log_file;
extern FILE *logFp;                    /* fd for log_file */
extern char chanopChar,
  chanvoiceChar,
  serveropChar;
extern int debug;
/* need to 'extern' these too:*/
extern int connect_timeout;            /* timeout in secs for gethostbyname */
extern int timeout;                    /* timeout for getstr in secs */
extern int tips_tmout;                 /* timeout for tipper in millisecs */
extern int lag_frequency;              /* autocheck lag frequency in secs */
extern int userupdate_frequency;       /* in secs; update display of channel users*/

extern int notify_frequency;           /* (secs) update notify list */
extern int max_go;
extern char *fmt_string;

/* procedures */

#if USE_XFORMS
extern void fit_object_label(FL_OBJECT * ob, const char *label);
extern void do_about(void);
extern void do_help(void);
extern void do_setup(void);
extern void go_menu_setup(Winstruct * win);
#define create_chanwin(__win)  create_form_chanwin()
#define spx_load_file(ob, fname) fl_load_browser((ob), (fname))
#define WINSTRUCT(__obj) \
 &winstruct[(int) ((FD_chanwin *) (__obj)->form->fdui)->bar->u_ldata]
#define iWINSTRUCT(__obj) \
 (int) ((FD_chanwin *) (__obj)->form->fdui)->bar->u_ldata
#elif USE_GTK
extern GtkWidget *chanusers_pup_menu;
extern Winstruct *chanusers_pup_window;
#define fit_object_label(w,l) gtk_label_set_text(GTK_LABEL(w), (l)? (l):"")
#define WINSTRUCT(__obj) \
  &winstruct[(int) gtk_object_get_user_data(GTK_OBJECT(__obj))]
#define iWINSTRUCT(__obj) \
  (int) gtk_object_get_user_data(GTK_OBJECT(__obj))
#endif /* USE_XFORMS */

#if HAVE_NO_STRSEP
extern char *strsep(char **, const char *);
#endif
extern void say2(int format_it,
                  int window,
                  int use_2nd_browser,
                  const char *, ...);
extern void _say(const char *, int, int, int format_it);
#define say(_s, _w, _w2) _say(_s, _w, _w2, 1) /*interprete format characters*/
#define say0(_s, _w, _w2) _say(_s, _w, _w2, 0)/*dont interprete format chars*/

extern int _save_history(History *, const char *);

#define save_history(f) _save_history(histStart,(f))
#define save_mainhistory(f) _save_history(mainhistStart,(f))
extern int load_history(const char *);
extern void AddToHistory(const char *);
extern void load_userlist(Winstruct *, const char *, int);
extern void cleanup(void);
extern void addto_cmd_sent(Winstruct *, const char *, const char *);
extern int sendto_server(Winstruct *, const char *);
extern void build_winlistbyfd(int fd);
extern void build_winlistbyservname(char *name, int port);
extern void UpdateWindows(int fd, char flag);
extern void UpdateStatus(Winstruct * win);
extern void update_topic(Winstruct *, const char *, const char *);

extern Winstruct *search_winlistbyfd(int fd, int *);
extern Winstruct *search_winlist_byservname(char *, int port, int *);
extern Winstruct *new_chan_win(void);
extern void set_object_attribs(Winstruct * win);
//extern Winstruct *new_win(void);
extern void _destroy_window(Winstruct * win, int force);

#define del_chanwin_from_list(win) _destroy_window((win), 0)

extern char *getstr2(const char *, const char *, const char *, int);
extern int confirm(const char *, const char *, double);
extern char *format_msg(char *,...);
extern void *getmemory(size_t size, int error_flag);
extern void *my_realloc(void *ptr, size_t size);
#define my_malloc(n) getmemory((n),ERR_SYS_QUIT)
#define my_malloc2(n) getmemory((n),ERR_SYS)
/*extern void my_free(void *ptr);*/
#define my_free(_p) free(_p)
/* networking */
extern char host[MAXHOSTNAMELEN + 1];	/* our host name */
extern struct sockaddr_in me;   /* our internet socket address */

#endif /* ifndef _SPRIMERIX_H */
