/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/



#ifndef _sula_TIMER_H
#define _sula_TIMER_H
#include <time.h>

#define ALARM_IN	0
   #ifdef _GUILE
 #define ALARM_SCM	1
   #endif
#define TIMER_ALARM (1<<0)
#define TIMER_CLOCK (1<<1)
typedef struct{
   int ref;
   char type; // ALARM_IN or ALARM_SCM; type==-1 ==>free slot
   char flag;  //  TIMER_ALARM|TIMER_CLOCK and any properties
   union{
     #ifdef _GUILE
     int scm;
     #endif
     char *cmd;
   }cmd;
   union{
     time_t stop;// when timer expires
     struct tm *date;// 133015==> 13:30:15
  }expire;
} Timer;
extern Timer *aTimer;
extern short   timer_count;

extern int add_timer(Timer *t,void *data);
//#define add_alarm(t,sec)   add_timer((t),(void *)&(s))
//#define add_clock(t,date)     ;
extern void del_timer(int ref, char type, char flag);
#define del_alarm(ref,type) del_timer((ref),(type),TIMER_ALARM)
#define del_clock(ref,type) del_timer((ref),(type),TIMER_CLOCK)

#endif
