/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
util.h - this and that.
Author: Tano Fotang (fotang@yahoo.com)

This is distributed under the GNU General Public License
as published by the Free Software Foundation; either
version 2 or any later version. The license is included
herein by reference.   
*/

#ifndef _sula_util_h_
#define _sula_util_h_

#include <signal.h> /* pid_t */
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h> /*FILE */
#include <ctype.h> /*isgraph, tolower*/
#include <string.h> /* memmove */
#ifndef COMMENT
#define COMMENT	'#'
#endif
//#ifndef INADDR_NONE
//#define INADDR_NONE	0xffffffff
//#endif
#ifndef MAXLINE
#define MAXLINE		2048
#endif
typedef void Sigfunc(int);
#if     defined(SIG_IGN) && !defined(SIG_ERR)
#define SIG_ERR         ((Sigfunc *)-1)
#endif
Sigfunc *Signal(int, Sigfunc *);
#define FILE_MODE       (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)
#define DIR_MODE        (FILE_MODE | S_IXUSR | S_IXGRP | S_IXOTH)

#define strshift(_s,_n) memmove((char *)(_s),(_s)+(_n),strlen((_s))-(_n)+1)
extern char    *expand_tilde (const char *pathname);
extern void      rmstr (const char *,unsigned int);
extern char    *nextword (const char *, unsigned int);
/*#define nextstr(s,n) nextword((s), (n)-1)*/

extern char    *strdchr (const char *t, int c);
extern char    *strcp (const char *s, size_t n);
extern char    *strdup2 (const char *);
extern void     uncomment (char *s, int comment);
extern char    *clean (const char *s);
extern char    *capitalize (const char *str);
extern char    *lowercase (const char *str);
extern char    *uppercase (const char *str);

extern void lowercase2 (char *);
extern void uppercase2 (char *);
#define LOWERCASE(__str)\
do{\
  char *_s_=__str; \
  while ((*_s_ = tolower(*_s_))) _s_++;\
}while(0)
#define UPPERCASE(__str)\
do{\
  char *_s_=__str; \
  while ((*_s_ = toupper(*_s_))) _s_++;\
}while(0)

extern char    *strsstr (const char *, const char *);
extern char    *strxstr (const char *, const char *);
extern char    *stristr (const char *, const char *);
extern int     delay (unsigned long microseconds);
extern void     new_str2args (char *, int *, char **,size_t);

extern void unescape(char *);
#define UNESCAPE(__str) \
do{\
  char *_p_=(char *)(__str);\
  while (isgraph(*_p_)) _p_++;\
  *_p_ = '\0';\
}while(0)

extern void unspace(const char *);
#define UNSPACE(_s) do{\
   char *_p_ = (char *) _s, *_q_=(char *)_s;\
   while (isspace(*_p_)) _p_++;\
   if(_p_!=_q_) while((*_q_=*_p_)){_q_++;_p_++;}\
}while(0)


extern size_t find_pos(const char *, u_int);
#define string_pos(_s,_n) find_pos((_s),(_n))
extern  void error(int, const char *,...);
#define ERR_SYS_QUIT	-2	// print system error and exit
#define ERR_SYS		-1 	// print sys error and return
#define ERR_FATAL	2	// print a msg and sigsegv
#define ERR_QUIT	1	// print a msg and exit
#define ERR_MSG		0	// print a msg and return


extern char *get_string_entries (FILE *, int *, char **,  size_t, int multiple);

//extern int h_errno;

extern struct sockaddr_in	tcp_rem_addr;/*when we connect anywhere */
extern char *tcp_err_msg;	/* error from last network command attempt */
extern ssize_t	readn(int, void *, size_t);
extern ssize_t	writen(int,const void *, size_t);
extern ssize_t	writestr (int, const char *,...);
extern int tcp_create_server(int backlog);
extern int tcp_open(char *, u_long, char *, int, u_int);

extern int TELL_WAIT(void);
extern void  TELL_CHILD(pid_t);
extern int  WAIT_PARENT(void);

#endif

