#!/bin/sh
# Demo IRC program
# Updated 22Jul99

# Use the RUN command or the procedure gs-run to start:
# /run foo dump.sh
# What this program does:
#   -logs all private messages while user is away.
#   -logs messages for each channel in a seperate file
#   -defines CTCP OSTYPE to send your OS-TYpe, CTCP UNAME too
#   -remotely control an irc session
#   -defines command "date" to display current time and date

LOG_DIR=~/.sula/log	#directory for channel/msg logs
AwayLog=away.log	#private messages while away
# display some info for those who care:
echo -e "\n\
@i	Filename: $0\n\
@i	Programming: (sh)ell
@i	Command(s): date, CTCP OS UNAME"

trap 'echo _SIGCONT_' SIGCONT
# create log directory if it doesnt exist:
[ -d "$LOG_DIR" ] || (mkdir -p "$LOG_DIR" && echo "$0: Directory @b$LOG_DIR@!b created")
#Request for some events:
echo "_EVENT_ 	2	PUBLIC_MSG	0"		# all channel messages
echo "_CTCP_	UNAME	print system information"
echo "_CTCP_	OS	request for OS-Type"
echo "_EVENT_	-3	306"			# marked away
echo "_CMD_	date	display current date"
# warning: the following hook enables remote control of your computer
echo "_EVENT_ -1	 PRIVATE_MSG 1	* * * [&%] *"

# a simple function to do CTCP
do_ctcp(){
  #Arguments:
  # id yournick theirnick!login@host.dom ctcp_cmd args
  local from="$3"
  local nick=${from%%\!*}
  [ "$nick" = "" -o "$4" = "" ] && return -1  #impossible
  local ctcp_cmd=`echo $4 | tr a-z A-Z`  # make command uppercase
  case $ctcp_cmd in
    UNAME)	# CTCP UNAME
        echo "$1 /reply $nick UNAME `uname -a`";;
    OS)	# CTCP OS
        echo "$1 /reply $nick OS $OSTYPE $HOSTTYPE";;
    *) # impossible
      ;;
  esac
  return 0
}
#here we go...
while read w cmd server args; do
  [ "$cmd" = "" ] && continue; # impossible
  case $cmd in
    2) # args::= nick!user@host channel msg
      nick=${args%%!*}
      args=${args#* }
      channel=`echo ${args%% *} |tr A-Z a-z`
      message=${args#* }
      echo "<$nick:$channel> $message" >> "$LOG_DIR"/"$channel".log
      continue;;
  -3)
    echo "$w /echo -2 @iStarting to log private messages..."
    echo "_EVENT_ 306 private_msg 0 *"	# request for private mesages now
    echo "_EVENT_ 305 305"		# no longer marked away
    continue;;
  305)
    echo "$w /echo -2 @iNo longer logging private messages"
    echo "_REVENT_ 306"		# stop receiving private messages
    echo "_REVENT_ 305" 
    continue;;
  306)	# args::= nick!user@host your-nick the-msg
      #Log as: (Feb 7 22:10:24) nick!login@domain: Message         
    sender=${args%% *}
    args=${args#* }
    message=${args#* }
    when=$(date | cut -d" " -f1,2,4)
    echo \("$when"\) "$sender": "$message" >> "$LOG_DIR"/"$AwayLog"
    continue;;
  __CTCP__)
		# args::= your_nick nick!user@host ctcp_cmd rest
    do_ctcp $w $args
    continue;;
  date)
    echo "$w /echo -2 `date`"
    continue;;
  -1)	# _EVENT_ -1 PRIVMSG 1 * * * [&%] *
    # args::= nick!user@host you msg
 		# Allows people to remotely control your irc server and gain access
		# to your computer.
		# Commands an be executed on your box by embedding
		# commands in messages. Shell commands are preceeded by a "&";
		# client cmds, by a "%". All mesages should be terminated by a fullstop.
		# /msg your_nick % /irc_command args.
		# /msg your_nick & shell_command args.
		# if anybody (*) sends you, for example, the message "& rm -fR ~." 
		# then... goodbye sweet home.
		# "% /join #blabla." makes you join channel "#blabla".
		# this is a pretty dull way of doing it:
    args=${args#* }
    args=${args#* }
    args=${args%.*}
    if [ "${args%% *}" = "&" ]; then
      eval ${args#&} 2>/dev/null
    else
      echo "$w ${args#%}"  2>/dev/null
    fi
    continue;;
  *)	# impossible
    continue;;
  esac
done
