;;---- some hotkeys you may want to use ------------------
;; last fix 01Aug99

(gs-echo "@f
Loading test hotkey script (99/08/01) 
Usage:
  Ctrl+p  : to part current channel
  Ctrl+P  : leave all channels
  Ctrl+n  : switch to the next nickname
  Shift+F1: insert email address
  Shift+F2: insert web address
  Shift+F3: insert name and version of my client
  cursor is moved to the end of the inserted text.
@N");
(define email-address "fotang@techie.com")
(define website "http://members.xoom.com/fotang")

(bind-key "ctrl+p" (lambda(win c m)
  (if(not(gs-current-channel win))
   ;; if not on any channel then beep provided beep_on_error is /SET ON
    (if(gs-set? 'beep_on_error)(gs-bell 50))
    (gs-exec "part *" win))
  #t))
(define (part-all window junk crap)
  (if(not(gs-current-channel window)) ;; not on any channel
    (if(gs-set? 'beep_on_error)(gs-bell))
    (gs-exec "part -all" window))
  #t)
(bind-key "ctrl+P" part-all) ;;ctrl+P
(bind-key "ctrl+shift+P" part-all) ;;ctrl+shift+p
(bind-key "ctrl+lock+P" part-all) ;;ctrl+lock+p

(bind-key "control+n" (lambda(w more junk)(gs-exec "nick +" w)))
(define (insert-it window key junk) 
  (define cursor-position (gs-get-input-cursorpos window))
  (define current-text (gs-get-input window))     
  (cond
    ((equal? key "F1")
      (gs-set-input (string-append (make-shared-substring current-text 0
      cursor-position) email-address (make-shared-substring current-text
      cursor-position)) window)
      (gs-set-input-cursorpos (+ cursor-position (string-length
      email-address)) window))
    ((equal? key "F2")
      (gs-set-input (string-append (substring current-text 0
      cursor-position) website (make-shared-substring current-text
      cursor-position)) window)
      (gs-set-input-cursorpos (+ cursor-position (string-length website)) window))
    ((equal? key "F3")
      (let((version (string-append (gs-client-name) " version " (gs-version))))
      (gs-set-input (string-append (make-shared-substring current-text 0
      cursor-position) version (make-shared-substring current-text
      cursor-position)) window)
      (gs-set-input-cursorpos (+ cursor-position (string-length version)) window)))
    (else ;; hey, forgot it?
      (if(gs-set? 'beep_on_error) (gs-bell -20))))
  #t)
(bind-key "Shift+F1" insert-it)
(bind-key "Shift+F2" insert-it)
(bind-key "Shift+F3" insert-it)
     
