;; Skeleton to implement a  URL grabber.
;; It captures URLs from IRC message that appear on your screen
;; (http://..., ftp://..., www.foo.com, ftp.foo.com, 123.32.33.23)
;; and displays the URLs on the mesage bar.
;; To add a new pattern, just include it in 'pats' below.

(use-modules (ice-9 regex))
(let*((pats (list "(http|ftp)://(localhost|[^.].+\\..+)"
                  "(www|ftp)\\..+\\..+"
                  "[0-9]{3}\\.[0-9]+\\.[0-9]+\\.[0-9]+"))
      (RL (let loop((res '())(p pats)); compile all regexps for future use...
         (if(null? p) res
            (loop (append res (list(make-regexp (car p) regexp/icase))) (cdr p)))))
      (char-test? (lambda(c) (char-whitespace? c)))
      (lab #f); just playing...
      (grab-url (lambda(str which? w) (if(< which? (length RL))
        (let* ((m (regexp-exec (list-ref RL which?) str))
              (url #f)
              (start (match:start m))
              (end (let loop((i start)(len (string-length str)))
                  (cond
                    ((= i len) i)
                    ((char-test? (string-ref str i)) i)
                    (else (loop (1+ i) len))))))
              
              (while(member (string-ref str (1- end)) '(#\. #\, #\; #\( #\) #\-
              #\: #\? #\!)) (set! end (1- end)))
              (set! url (make-shared-substring str start end))
              (if(not lab)(set! lab (gs-get-message w)))
              (gs-message (string-append "got a URL: " url". not validated.") w)
              (gs-alarm 4 (lambda(a b)(if lab (gs-message lab w))(set! lab #f)))))))
       ; a list of our grab functions:
       (grab-func (let loop((res '())(i 0)(l (length RL)))
         (if(= i l)
            res 
            (loop (append res (list (lambda(str w)
                    (if(not(string=? "OUTGOING" (next-word str 1)))
                      (grab-url str i w)))))  (1+ i) l)))))

  (let loop((i 0)(l (length grab-func)))
     (if(< i l)(begin
       (gs-iregex-hook "#irc_line_out" 200 (string-append "* * *" 
           (list-ref pats i)) (list-ref grab-func i))
       (loop (1+ i) l)))))
;-EOF
