#!
  Support for channel bookmarks.
  Tano Fotang, fotang@techie.com
!#

;when channel name contains "/", replace the slash with _bm_/ in the menu display
;_bm_/ should be a character that isnt allowed in channelnames.
(define _bm_/ #\001)
; in string ch replace character c1 with c2
(define (char-switch ch c1 c2)
  (let loop((res ch)(i 0)(end (string-length ch)))
    (if(= i end) res
      (begin
        (if(eqv? c1 (string-ref res i)) (string-set! res i c2))
        (loop res (1+ i) end)))))
; add a new bookmark
(define (_add_bookmark w path)
  (define ch (gs-current-channel w))
  (if ch
    (let ((serv (gs-window-server w)))
      (set! _Bookmarks_ (acons (string-copy ch) (list (server:name serv) (server:port serv)) _Bookmarks_))
      (sx-submit (display2string "/Bookmark/"
      (if(< _bm_index 10) 0 "") _bm_index ". "
       (char-switch ch #\/ _bm_/)) "_join_bookmark_channel")
       (set! _bm_index (1+ _bm_index)))))
#!
Join a bookmarked channel. The channel has been selected from the bookmark menu.
This is how it works:
if bookmark_ignoreserver is SET on, we join the channel using the
current window. Otherwise  first connect to the server/port on which
the channel was bookmarked, and once connected, join the channel. But we
check first to see whether we're already to that server/port-pair. If we
are, we join the channel using the first window that is connected to the
server/port. If we arent connected to the server/port, connect to the server
using the first unconnected window that is found. If no window is found
that isnt already associated with a server, create a new window.
!#
(define _join_bookmark_channel (lambda(w path)
  (let* ((connect-now (lambda(w ch)
      (let* ((entry (assoc ch _Bookmarks_))(servrname (cadr entry)))
      (if(not servrname)
        #f
        (connect-and-join servrname (caddr entry) ch)))))
  (ch0 (substring path (1+ (string-rindex path #\/))))
  (ch (let loop((i 0))
    (if(equal? #\. (string-ref ch0 i)) (substring ch0 (+ i 2)) (loop (1+ i))))))
  (set! ch (char-switch ch _bm_/ #\/))
  (if(or (gs-set? 'bookmark_ignoreserver)(not(connect-now w ch)))
    (gs-execute w "/Join " ch)))))
;--end of _join_bookmark_channel--
; redraw bookmark submenu
(define (_redraw_bookmark_menu w blabla)
  (sx-remove-path "Bookmark")
  (sx-submit "Bookmark/Add bookmark" "_add_bookmark")
  (sx-submit "/Bookmark/Operation/Save bookmarks" "_save_bookmarks"
    SX_FILE   "Save bookmarks as:" (string-append *sula-home* "/sula_bookmarks"))
  (sx-submit "/Bookmark/Operation/Reorder items" "_redraw_bookmark_menu")
  (sx-submit "/Bookmark/Operation/Display bookmark window" "_show_bookmarks")
  (set! _bm_index 0)
  (let loop((bm _Bookmarks_))
    (if(not(null? bm))(let((ch (string-copy (caar bm))))
      (sx-submit (display2string "/Bookmark/"
      (if(< _bm_index 10) 0 "") _bm_index ". "
       (char-switch ch #\/ _bm_/)) "_join_bookmark_channel")
      (set! _bm_index (1+ _bm_index))
      (loop (cdr bm))))))
  
;read and merge bookmarks from a file. entries are of form:
; channelname:anything:servername:port
; channelname must be given; the rest are optional
; e.g. #gimp::irc.gimp.org

(define (load_bookmarks fname)
   (define read_bm_file(lambda(fn)(letrec(
     (fp (open-input-file fn))
     (got_one #f)
     (get-next (lambda(s len prev)
         (let loop((i prev))
           (if(= i len) i
             (if(eqv? #\: (string-ref s i)) (1+ i) (loop (1+ i)))))))
     (parse-bm-line (lambda(s)
       (define item (get-item s))
       (if(not(null? item)) (set! got_one #t))
       (if(not(null? item))
         (set! _Bookmarks_ (acons (string-copy (car item))
          (list (if(cadr item) (string-copy (cadr item)) #f)
          (caddr item)) _Bookmarks_)))))
     (get-item (lambda(s)
       (let*((bm (list #f #f #f)) (prev 0)(len (string-length s))
       (n (get-next s len prev));channel name
       (tmp ""))
       (set! tmp (sans-surrounding-whitespace
         (substring s prev (if(and(= n len)(not(eqv? #\: (string-ref s (1- n)))))
           n (1- n)))))
       (call-with-current-continuation (lambda(return)
         (if(string-null? tmp) (return '()))
         (list-set! bm 0 tmp)
         (if(= n len) (return bm))
         (set! prev n)
         (set! n (get-next s len prev))
         (if(= n len) (return bm))
         (set! prev n)
         (set! n (get-next s len prev)); server name
         (set! tmp (sans-surrounding-whitespace
           (substring s prev (if(and(= n len)(not(eqv? #\: (string-ref s (1- n)))))
            n (1- n)))))
         (list-set! bm 1 (if(string-null? tmp) #f tmp))
         (if(= n len) (return bm))
         (set! prev n)
         (set! n (get-next s len prev)) ;port
         (set! tmp (sans-surrounding-whitespace
          (substring s prev (if(= n len) n (1- n)))))
         (list-set! bm 2 (if(string-null? tmp) #f (string->number tmp)))
         (return bm)))))))
     (let loop((s (read-line fp)))
       (if(not(eof-object? s))(begin
         (if(not(string-null? s))
           (let((c (string-ref s 0)))
             (if(or(eqv? #\# c)(eqv? #\& c)) (parse-bm-line s))))
         (loop (read-line fp)))))
     (close-input-port fp)
     got_one)))
  (if(access? fname R_OK) (if(read_bm_file fname) (_redraw_bookmark_menu 0 0) #f) #f))

(define (_save_bookmarks w ignore fname)
  (define fp (open-output-file fname))
  (display (string-append (gs-client-name) " " (gs-version) "\n"
      "Bookmarks created " (strftime "%a %b %d %H:%M:%S %Y."
       (localtime (current-time))) "\n\n") fp)
  (display
    (let loop((bm _Bookmarks_)(res ""))
      (if(null? bm)
        res
        (let*((entry (car bm))
          (chan (car entry))(servr (cadr entry)) (port (caddr entry)))
          (loop (cdr bm) (display2string res chan "::" (if servr servr "") ":"
            (if port port "") "\n")))))
      fp)
   (close-output-port fp))

(if(not(defined? '_Bookmarks_))(begin
  (define _Bookmarks_ '())
  (define _bm_index 0)
  (sx-submit "/Bookmark/Add bookmark" "_add_bookmark")
  (sx-submit "/Bookmark/Operation/Save bookmarks" "_save_bookmarks"
    SX_FILE   "Save bookmarks as:" (string-append *sula-home* "/sula_bookmarks"))
  (sx-submit "/Bookmark/Operation/Reorder items" "_redraw_bookmark_menu")
  (sx-submit "/Bookmark/Operation/Display bookmark window" "_show_bookmarks")
  (gs-new-variable 'boolean "bookmark_ignoreserver")
  (load_bookmarks (string-append *sula-home* "/sula_bookmarks"))
  (gs-set! "bookmark_ignoreserver" #t)))
;; junk
;; display all bookmarks in a Textbox
(if(not(defined? '_sx_bmw)) (define _sx_bmw -1))
(define (_show_bookmarks w mmmhhh)
  (define (update_window junk jjunk)
    (sx-clist-clear _sx_bmw)
    (sx-tb-set! _sx_bmw 'label (string-append "Script 7/99 by fotang@yahoo.com.\n"
    "BOOKMARK_IGNORESERVER is currently set "
    (if(gs-set? "bookmark_ignoreserver") "ON" "OFF")))
    (sx-clist-add-rows _sx_bmw (let loop ((res '())(bm _Bookmarks_))
    (if(null? bm)
      (reverse res)
      (let* ((item (car bm))(serv (cadr item))(port (caddr item)))
        (loop (cons (list (car item)
                            (if serv serv "any")
                            (if port (number->string port) "any"))
                        res) (cdr bm)))))))
  (if(= _sx_bmw -1)(begin
    (set! _sx_bmw
      (sx-clist-new 400 100 3 (lambda(id) (set! _sx_bmw -1))
        SX_TITLE  (string-append (gs-client-name) ": Channel Bookmarks")
        SX_BUTTON "Save" (lambda(id data)(gs-bell)) #f -1
        SX_BUTTON "Merge" (lambda(id data)(gs-bell)) #t -1
        SX_BUTTON "Refresh" update_window #f -1))
    (sx-clist-titles-show _sx_bmw)
    (sx-clist-title!  _sx_bmw 0 "Channel")
    (sx-clist-title!  _sx_bmw 1 "Server")
    (sx-clist-title!  _sx_bmw 2 "Port")
    (sx-clist-column-width! _sx_bmw 0 120)
    (sx-clist-column-width! _sx_bmw 1 200)))
  (update_window #f #f))
  ;(sx-clist-cell-style! _sx_bmw 0 2 "@C5")
;EOF
