;; Create a window and display DCC status
;; manipulate DCC items and status
;; (C) 1999 Tano Fotang

(if(not(defined? '_sx_dcc_win)) (define _sx_dcc_win -1))
(sx-submit "DCC/DCC List" "_dcc_list")
(define (_dcc_list w path)(let*
  ((update_display (lambda(junk junkjunk)
    (sx-clist-clear _sx_dcc_win)
    (let loop((All-DCCs (gs-dcc-list))(i 0))
      (if(not(null? All-DCCs))
         (let((one (car All-DCCs))(res '()))
           (sx-clist-add-rows _sx_dcc_win (cons
             (list (number->string (dcc:id one))
                   (if(dcc:chat? one) "CHAT" (if(dcc:sent? one) "SEND" "GET"))
                   (dcc:nick one)
                   (if(dcc:active? one) "Active" (if(dcc:forwarded? one)
                   "Forwarded"  "Waiting"))
                   (strftime "%H:%M.%S %d%b%y" (localtime (dcc:starttime one)))
                   (number->string (dcc:bytes-sent one))
                   (number->string (dcc:bytes-received one))
                   (if(dcc:chat? one) (dcc:userhost one) (dcc:file-name one)))
              res))
             (sx-clist-row-style! _sx_dcc_win i "@f@D0@C7")
             (sx-clist-cell-style! _sx_dcc_win i 1 "@C6")
             (sx-clist-cell-style! _sx_dcc_win i 3 "@C5")
             (sx-clist-cell-style! _sx_dcc_win i 7 "@s@C2")
             (loop (cdr All-DCCs) (1+ i)))))))
  (accept_it (lambda(id accept?)
    (define selection (sx-get-selected-text id))
    (if(null? selection)
      (begin (gs-bell) #f)
      (call-with-current-continuation (lambda(exit)
        (define all (gs-dcc-list))
        (if(null? all)(begin (update_display #f #f)(exit #f)))
        (let loop((cur selection))
          (if(null? cur) (exit #f)
            (let*((id (string->number(caar cur)))
              (one (let repeat((rest all))
                (cond
                  ((null? rest) #f)
                  (else (if(= id (dcc:id (car rest)))
                    (car rest)
                    (repeat (cdr rest))))))))
              (if(not one)
                (begin (say "**" cur " doesnt exist") (loop (cdr cur))))
              (if accept?
                (if(and (dcc:received? one) (dcc:queued? one)) 
                  (gs-execute (dcc:window one) "/DCC "
                    (if(dcc:chat? one) "CHAT " "GET ") (dcc:id one)))
                (gs-execute (dcc:window one) "/DCC CLOSE "
                    (if(dcc:chat? one) "CHAT " (if(dcc:sent? one) "SEND " "GET "))
                    (dcc:id one)))
              (loop (cdr cur)))))))))))
  (if(= -1 _sx_dcc_win)(let(
    (forward (lambda(id junk)
      (sx-dialog-new id
        (lambda(tb nick)
            (define selection (sx-get-selected-text tb))
            (if(or(null? selection)(string-null? nick))
              (begin (gs-bell) #f)
              (call-with-current-continuation (lambda(exit)
                (define all (gs-dcc-list))
                (if(null? all)(begin (update_display #f #f)(exit #f)))
                (let loop((cur selection))
                  (if(null? cur) (exit #f)
                    (let*((id (string->number(caar cur)))
                      (one (let repeat((rest all))
                        (cond
                          ((null? rest) #f)
                          (else (if(= id (dcc:id (car rest)))
                            (car rest)
                            (repeat (cdr rest))))))))
                      (if(not one)
                        (begin (say "**" cur " doesnt exist") (loop (cdr cur))))
                      (if(and (dcc:received? one) (dcc:queued? one)) 
                        (gs-execute (dcc:window one)
                        "/userhost "nick " -cmd "
                        (if(dcc:chat? one) "/fwdcr " "/fwdfr ")
                         (dcc:id one) " " nick))
                      (loop (cdr cur)))))))))
          #f
          SX_TITLE  (string-append (gs-client-name) ": Forward DCC")
          SX_STRING "Forward selection to" ""))))
             
    (set! _sx_dcc_win (sx-clist-new -400 150 8 (lambda(id)(set! _sx_dcc_win -1))
      SX_TITLE  (string-append (gs-client-name) ": DCC Status")
      SX_BUTTON "Refresh" update_display #f -1
      SX_BUTTON "Accept" accept_it #t -1
      SX_BUTTON "Forward" forward #f -1
      SX_BUTTON "Kill" accept_it #f -1
      SX_CANCEL "Done"))
    (sx-clist-titles-show _sx_dcc_win)
    (sx-clist-title!  _sx_dcc_win 0 "ID")
    (sx-clist-title!  _sx_dcc_win 1 "Type")
    (sx-clist-title!  _sx_dcc_win 2 "Peer")
    (sx-clist-title!  _sx_dcc_win 3 "Status")
    (sx-clist-title!  _sx_dcc_win 4 "Start time")
    (sx-clist-title!  _sx_dcc_win 5 "Wrote")
    (sx-clist-title!  _sx_dcc_win 6 "Read")
    (sx-clist-title!  _sx_dcc_win 7 "Misc")
    (sx-clist-column-width! _sx_dcc_win 0 30)
    (sx-clist-column-width! _sx_dcc_win 1 45)
    (sx-clist-column-width! _sx_dcc_win 2 50)
    (sx-clist-column-width! _sx_dcc_win 3 50)
    (sx-clist-column-width! _sx_dcc_win 4 100)
    (sx-clist-column-width! _sx_dcc_win 5 50)
    (sx-clist-column-width! _sx_dcc_win 6 50)
    (sx-clist-column-width! _sx_dcc_win 7 -200)
    (update_display #f #f)))))
;EOF
