#!
Last changed: 18Aug99 by fotang@techie.com.
Support for DCC SOUND, the most useless of all DCC commands.
Original idea from an EPIC script by hop.
New! ScriptX - graphical configuration is now available.

Default sound command: /usr/bin/play
ALternatively, specify play command based on sound type. Tthat's a
diffrent assignment..
You should specify the directories that hold sound files. All the given
directories will be searched until a file is found that can be read.
If file isnt found and it didnt have a suffix, a suffix (w.g. .wav, .au,.voc)
is appended and new search follows. Your sound program should be able to play
all of the given extensions. sox(1) does.

Default sound path: /usr/local/lib/sula/sounds ~/.sula/sounds
                    /usr/share/sounds/au /usr/share/sounds/wav

Use the graphical configuration defined below in order to change settings.

Example:
  /alias sound ctcp $1 SOUND $2-
  /sound xgl Goodbye is leaving...
  => $sound_path/Goodbye[.wav|.au|.voc] will played and then
  Action: fotang is leaving...
!#

(define PLAYWAV "/usr/bin/play")
; where to search for sounds
(define sound-path '("/usr/local/lib/sula/sounds" "~/.sula/sound"
                     "/usr/share/sounds/au" "/usr/share/sounds/wav"))
; the extensions to use if specified sound file cant be found
(define sound-extensions '(wav au voc))
(gs-add-hook "CTCP_ALL" "* * * SOUND *" (lambda(m w)
  (let* (
    (sound (next-word m 4))
;now get the full path of the sound file by searching in all directories
;using all of the given file extensions. I think this is fun game.
    (full-path (call-with-current-continuation (lambda(return)
      (let repeat((path sound-path))
        (if(null? path)
          (return #f)
          (let((cur-path (string-append (car path) "/" sound)))
            (if(access? cur-path R_OK) ; if we can read the file
               (return cur-path)
; if sound file cant be read, append the given (wav, au, voc,...) to
; the name (if it has none yet) and try again.
               (if(string-rindex sound #\.)
                 (repeat (cdr path))
                 (let loop((ext sound-extensions))
                   (if(null? ext)
                     (repeat (cdr path))
                     (let((tmp (string-append cur-path "." (car ext))))
                       (if(access? tmp R_OK)
                          (return tmp)
                          (loop (cdr ext)))))))))))))))
; all done. now play the sound if you got one, and display some action.
    (if full-path
      (let((sender (next-word m 1))(action (string-rest m 5)))
        (if(string-null? action)
          (_say w "*** This sound @i@$" sound "@!$@^@. courtesy of " sender)
          (_say w "@.* " (sender2nick sender) " " action))
        (gs-execute w "/exec " PLAYWAV " " full-path))))))

#!
/*
 * Usage: /sound <target|*> <wavfile> <action-text>
 * All the arguments are required, according to the specification.
 *
 * The first argument is who to send it to, '*' goes to current target
 * The second argument is the wav file to be played.  The receiver is
 *	assumed to have this wav file already..
 * The rest of the arguments are "action text", ala the /me command.
 */
 alias sound ctcp $0 SOUND $1-

#hop'96
!#
(gs-exec "/alias sound /ctcp $1 SOUND $2-")
;;-----done----
; And now the graphical configuration
(sx-submit "DCC/Sound options" "_config_dcc_sound"
  SX_TITLE "SPX II: Configure DCC Sound"
  SX_FILE "Sound command" "/usr/bin/play"
  SX_FILE "Sound path" "/usr/local/lib/sula/sounds"
  SX_FILE "Sound path1" (string-append *sula-home* "/.sula/sounds")
  SX_FILE "Sound path2" "/usr/share/sounds/au"
  SX_FILE "Sound path3" "/usr/share/sounds/wav"
  SX_FILE "Sound path4" ""
  SX_FILE "Sound path5" ""
  SX_MLIST "Sound suffix" '("wav" "au" "voc") 40 20
  )
(define (_config_dcc_sound w junk cmd p0 p1 p2 p3 p4 p5 ext)
  (set! sound-path '())
  (for-each (lambda(path)(if(not(string-null? path))
              (set! sound-path (append sound-path (list path)))))
        (quasiquote (,@(list p0 p1 p2 p3 p4 p5))))
  (if(not(string-null? cmd)) (set! PLAYWAV cmd))
  (set! sound-extensions ext)
; now print current settings:
  (_say2 w "@f@bCurrent DCC SOUND config:@!b@.\n"
  "  play command: " cmd "\n"
  "  sound path  : "
    (let loop((pp sound-path)(res ""))
      (if(null? pp)
        res
        (loop (cdr pp) (string-append res (if(string-null? res) ""
         "                ") (car pp)  "\n"))))
  "  extensions  : " (if(null? sound-extensions) "none" sound-extensions)))
;EOF
