;; this script resets your idle time every <idle-time> seconds (default 120)
;; use /set idle-time <seconds> to set maximum idle time:
;; use /set no-idling on|off|toggle to turn anti-idling off and on.

(gs-new-variable 'number "idle-time")
(gs-set! 'idle-time 120)
(gs-new-variable 'boolean "no-idling" (lambda(s val w)
; what to do each time that no-idling changes
  ((if val gs-preempt gs-delete-preempt) "RAW_NON_NUMERIC"
      (string-append "* * PRIVMSG * :" *sula-random-string*))
  ;; this one for purists:
  (if val
    (gs-preempt "RAW_NUMERIC" "* * 301 *" ;; ignore our 'marked away' notice
      (lambda(m w) (string-ci=? (next-word m 3) (next-word m 4))))
    (gs-delete-preempt "RAW_NUMERIC" "* * 301 *"))))
(gs-set! 'no-idling #t)
(gs-delete-alarm 555);; clear 555 and use it as alarm ID
;;the procedure that is called periodically to reset idle time
(define (anti-idle alarm-id)
   (gs-alarm 'ref alarm-id (gs-set? 'idle-time) (lambda(refnum at)
      (if(gs-set? 'no-idling)
         (let((socket-list (servers-socket-fd))) 
             (if(not(null? socket-list)) 
	             (for-each
                 (lambda(i)
	                 (gs-raw-write (car i) (string-append "PRIVMSG " (cdr i) " :"
	                 *sula-random-string* "\n")))
	               socket-list))))
      (anti-idle refnum))))
(anti-idle 555)
