;; clear all channel bans
;; Usage: /clrbans <channame>
;;        /help clrban
;;26aug99

(gs-new-command "clrbans" "remove all channel bans" (lambda(arg win)
  (let((channel (next-word arg 1)))
    (if(or(string-null? channel)(string-ci=? "-help" channel)); /help clrban
       (gs-echo (string-append "@bUsage: @fclrbans @^@ichannel@^ | @C1*@!C"
         "\n  @f@C0@D7This command removes all channel bans. @C1*@C0 is current channel") win)
    (let ((servr (gs-window-server2 win)))
    (if(or(null? servr) (not(server:connected? servr)))
      (begin(gs-message "No connection. Halt." win)(gs-bell))
      (let*((what? (string-append "* * 367 * " channel " *"))
        (remove-hooks (lambda(bla blah)
          (gs-delete-hook "RAW_NUMERIC" what?)
          (gs-delete-hook "RAW_NUMERIC" "* * 403 * " channel " *")
          (gs-delete-hook "RAW_NUMERIC" "* * 368 * " channel " *")
          (gs-delete-hook "#RAW_NUMERIC" -100 " * * 482 * " channel " *"))))
        ;; Start work:
        (gs-add-hook "RAW_NUMERIC" what? (lambda(m w)
    	    (gs-execute w "/mode " channel " -b " (next-word m 5))))
        (gs-execute win "/mode " channel " +b ")    
        ;; end of ban list:
        (gs-add-hook "RAW_NUMERIC" (string-append "* * 368 * " channel " *") remove-hooks)
        ;; you're not channel operator
        (gs-add-hook "#RAW_NUMERIC" -100 (string-append "* * 482 * " channel " *") remove-hooks)
        ;; no such channel:
        (gs-add-hook "RAW_NUMERIC" (string-append "* * 403 * " channel " *") remove-hooks))))))))
;EOF
