;; Quote the given string, making it sendable via IRC. The string
;; may contain binary data.
;; Backslashes are escaped. newlines, carriage returns and
;; and #\nul are coded.
;; Translated from the code in src/ctcp.c.
;; TODO: write ctcp-unquote.

(define CTCP_DELIM_CHAR #\001)
(define CTCP_QUOTE_CHAR #\\)
(define (ctcp-quote-it str)(let*
  ((len (string-length str))(i 0)(ptr 0)(buf (make-string (* 2 len))))
  (while (< ptr len)
    (case (string-ref str ptr)
      ((CTCP_DELIM_CHAR)
        (string-set! buf i CTCP_QUOTE_CHAR)
        (string-set! buf (1+ i) #\a)(set! i (+ 2 i)))
      ((#\nl)
        (string-set! buf i CTCP_QUOTE_CHAR)
        (string-set! buf (1+ i) #\n)(set! i (+ 2 i)))
      ((#\cr)
        (string-set! buf i CTCP_QUOTE_CHAR)
        (string-set! buf (1+ i) #\r)(set! i (+ 2 i)))
      ((CTCP_QUOTE_CHAR)
        (case (string-ref str (1+ i))
          ((#\n #\r #\t #\0 CTCP_QUOTE_CHAR)
            (string-set! buf i (string-ref str ptr))
            (set! i (1+ i)))
          (else
            (string-set! buf i CTCP_QUOTE_CHAR)
            (string-set! buf (1+ i) CTCP_QUOTE_CHAR)
            (set! i (+ 2 i)))))
      ((#\nul)
        (string-set! buf i CTCP_QUOTE_CHAR)
        (string-set! buf (1+ i) #\0)
        (set! i (+ 2 i)))
      (else
        (string-set! buf i (string-ref str ptr))
        (set! i (1+ i))))
    (set! ptr (1+ ptr)))
  (make-shared-substring buf 0 i)))
;EOF
