;; load/reload/clear/save command history
;; erase/save text
(sx-submit "/My Box/Brower ops/Erase Top" "_erase_browser")
(sx-submit "/My Box/Brower ops/Erase Bottom" "_erase_browser2")
(sx-submit "/My Box/Brower ops/Save Top" "_save_browser"
  SX_LABEL "Save contents:"
  SX_FILE "Save as" "")
(sx-submit "/My Box/Brower ops/Save Bottom" "_save_browser2"
  SX_LABEL "Save lower text:"
  SX_FILE "Save as" "")
(define (_save_browser w ig fname)
  (if(not(string-null? fname)) (gs-execute w "/window -s 1 -f" fname)))
(define (_save_browser2 w ig fname)
  (if(not(string-null? fname)) (gs-execute w "/window -s 2 -f " fname)))
(define _erase_browser (lambda(w path) (gs-exec "/window -c 1" w))) 
(define _erase_browser2 (lambda(w path) (gs-exec "/window -c 0" w)))

(sx-submit "/My Box/History/Clear" "_history_clear"
  SX_LABEL "Clear command history?")
(sx-submit "/My Box/History/Reload" "_history_reload"
  SX_LABEL "Reload input history?\nAll current entries wil be lost.")

(sx-submit "/My Box/History/Load" "_history_load"
  SX_FILE "File name" (string-append (getenv "HOME") "/.sula/.sula_history"))
(sx-submit "/My Box/History/Save" "_history_save"
  SX_FILE "Save as" (string-append (getenv "HOME") "/.sula/.sula_history"))

(define (_history_clear w ig)(gs-exec "/history -clear 1" w))
(define (_history_reload w ignore)(gs-exec "/history -reload 1" w))
(define (_history_load w ig fname)
  (if(not(string-null? fname)) (gs-execute w "/history  -lo " fname)))
(define (_history_save w ig fname)
  (if(not(string-null? fname)) (gs-execute w "/history  -sa " fname)))
