#!
/oops <nick> to correct messaging error
/help oops
!#

(let((last-sent '())) ;; holds what we last sent (nick . message)
  (gs-add-hook "#send_private_msg" 511 "*" (lambda(str win)
    ; str::=server,port nick msg
    (define nick (next-word str 1))
    (define msg (string-rest str 2))
    (set! last-sent (list nick msg))))
  
  (gs-new-command "oops" "resend message, now to the correct person"
    (lambda(str win)
      (define nick (next-word str 1))
      (cond
        ((string-null? nick) (gs-echo "Usage: /oops <nick>" win 1))
        ((string-ci=? "-help" nick) ;; /help when
          (gs-echo "@C5@vUSAGE:@!C @b/oops@!b @inick
@^where @inick@!i is person you want to receive previously sent message.
Example: You wanted to message Tiger but instead did:
@f/msg aaron hi there
@^Then you realised you messaged wrong person, to fix error type
@f/oops tiger
@^and it will do these at once:
-> *aaron* Sorry, message was not meant for you
-> *Tiger* Hi there\n@iThis help text is from Barron's SUPERPAK."
          win))
        (else
          (if(not(null? last-sent))
            (let((last_msg (cadr last-sent))
                 (last_nick (car last-sent))) 
              (gs-execute win "/msg " last_nick
               " sorry, that wasnt meant for you.")
              (gs-execute win "msg " nick " " last_msg))))))))
;EOF
